/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.util.List;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.util.Assert;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class BindException
extends Exception
implements BindingResult {
    public static final String ERROR_KEY_PREFIX = BindException.class.getName() + ".";
    private final BindingResult bindingResult;

    public BindException(BindingResult bindingResult) {
        Assert.notNull(bindingResult, "BindingResult must not be null");
        this.bindingResult = bindingResult;
    }

    public BindException(Object target, String objectName) {
        Assert.notNull(target, "Target object must not be null");
        this.bindingResult = new BeanPropertyBindingResult(target, objectName);
    }

    public final BindingResult getBindingResult() {
        return this.bindingResult;
    }

    public final PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.bindingResult.getPropertyEditorRegistry();
    }

    public String getObjectName() {
        return this.bindingResult.getObjectName();
    }

    public void setNestedPath(String nestedPath) {
        this.bindingResult.setNestedPath(nestedPath);
    }

    public String getNestedPath() {
        return this.bindingResult.getNestedPath();
    }

    public void pushNestedPath(String subPath) {
        this.bindingResult.pushNestedPath(subPath);
    }

    public void popNestedPath() throws IllegalStateException {
        this.bindingResult.popNestedPath();
    }

    public void reject(String errorCode) {
        this.bindingResult.reject(errorCode);
    }

    public void reject(String errorCode, String defaultMessage) {
        this.bindingResult.reject(errorCode, defaultMessage);
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.bindingResult.reject(errorCode, errorArgs, defaultMessage);
    }

    public void rejectValue(String field, String errorCode) {
        this.bindingResult.rejectValue(field, errorCode);
    }

    public void rejectValue(String field, String errorCode, String defaultMessage) {
        this.bindingResult.rejectValue(field, errorCode, defaultMessage);
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        this.bindingResult.rejectValue(field, errorCode, errorArgs, defaultMessage);
    }

    public void addAllErrors(Errors errors) {
        this.bindingResult.addAllErrors(errors);
    }

    public boolean hasErrors() {
        return this.bindingResult.hasErrors();
    }

    public int getErrorCount() {
        return this.bindingResult.getErrorCount();
    }

    public List getAllErrors() {
        return this.bindingResult.getAllErrors();
    }

    public boolean hasGlobalErrors() {
        return this.bindingResult.hasGlobalErrors();
    }

    public int getGlobalErrorCount() {
        return this.bindingResult.getGlobalErrorCount();
    }

    public List getGlobalErrors() {
        return this.bindingResult.getGlobalErrors();
    }

    public ObjectError getGlobalError() {
        return this.bindingResult.getGlobalError();
    }

    public boolean hasFieldErrors() {
        return this.bindingResult.hasFieldErrors();
    }

    public int getFieldErrorCount() {
        return this.bindingResult.getFieldErrorCount();
    }

    public List getFieldErrors() {
        return this.bindingResult.getFieldErrors();
    }

    public FieldError getFieldError() {
        return this.bindingResult.getFieldError();
    }

    public boolean hasFieldErrors(String field) {
        return this.bindingResult.hasFieldErrors(field);
    }

    public int getFieldErrorCount(String field) {
        return this.bindingResult.getFieldErrorCount(field);
    }

    public List getFieldErrors(String field) {
        return this.bindingResult.getFieldErrors(field);
    }

    public FieldError getFieldError(String field) {
        return this.bindingResult.getFieldError(field);
    }

    public Object getFieldValue(String field) {
        return this.bindingResult.getFieldValue(field);
    }

    public Class getFieldType(String field) {
        return this.bindingResult.getFieldType(field);
    }

    public Object getTarget() {
        return this.bindingResult.getTarget();
    }

    public Map getModel() {
        return this.bindingResult.getModel();
    }

    public void recordSuppressedField(String fieldName) {
        this.bindingResult.recordSuppressedField(fieldName);
    }

    public String[] getSuppressedFields() {
        return this.bindingResult.getSuppressedFields();
    }

    public void addError(ObjectError error) {
        this.bindingResult.addError(error);
    }

    public String[] resolveMessageCodes(String errorCode, String field) {
        return this.bindingResult.resolveMessageCodes(errorCode, field);
    }

    public String getMessage() {
        return this.bindingResult.toString();
    }

    public boolean equals(Object other) {
        return this == other || this.bindingResult.equals(other);
    }

    public int hashCode() {
        return this.bindingResult.hashCode();
    }
}

