/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.persistence;

import org.hibernate.FlushMode;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionListenerAdapter;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;

public class HibernateFlowExecutionListener
extends FlowExecutionListenerAdapter {
    public static final String PERSISTENCE_CONTEXT_ATTRIBUTE = "persistenceContext";
    private SessionFactory sessionFactory;
    private TransactionTemplate transactionTemplate;
    private Interceptor entityInterceptor;

    public HibernateFlowExecutionListener(SessionFactory sessionFactory, PlatformTransactionManager transactionManager) {
        this.sessionFactory = sessionFactory;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public void sessionStarting(RequestContext context, FlowSession session, MutableAttributeMap input) {
        FlowSession parent;
        if (!session.isRoot() && this.isPersistenceContext((parent = session.getParent()).getDefinition())) {
            this.unbind(this.getHibernateSession(parent));
        }
        if (this.isPersistenceContext(session.getDefinition())) {
            org.hibernate.Session hibernateSession = this.createSession(context);
            session.getScope().put(PERSISTENCE_CONTEXT_ATTRIBUTE, hibernateSession);
            this.bind(hibernateSession);
        }
    }

    public void paused(RequestContext context) {
        if (this.isPersistenceContext(context.getActiveFlow())) {
            org.hibernate.Session session = this.getHibernateSession(context.getFlowExecutionContext().getActiveSession());
            this.unbind(session);
            session.disconnect();
        }
    }

    public void resuming(RequestContext context) {
        if (this.isPersistenceContext(context.getActiveFlow())) {
            this.bind(this.getHibernateSession(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    public void sessionEnded(RequestContext context, FlowSession session, String outcome, AttributeMap output) {
        FlowSession parent;
        if (this.isPersistenceContext(session.getDefinition())) {
            org.hibernate.Session hibernateSession = (org.hibernate.Session)session.getScope().remove(PERSISTENCE_CONTEXT_ATTRIBUTE);
            Boolean commitStatus = session.getState().getAttributes().getBoolean("commit");
            if (Boolean.TRUE.equals(commitStatus)) {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        HibernateFlowExecutionListener.this.sessionFactory.getCurrentSession();
                    }
                });
            }
            this.unbind(hibernateSession);
            hibernateSession.close();
        }
        if (!session.isRoot() && this.isPersistenceContext((parent = session.getParent()).getDefinition())) {
            this.bind(this.getHibernateSession(parent));
        }
    }

    public void exceptionThrown(RequestContext context, FlowExecutionException exception) {
        if (context.getFlowExecutionContext().isActive() && this.isPersistenceContext(context.getActiveFlow())) {
            this.unbind(this.getHibernateSession(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    private boolean isPersistenceContext(FlowDefinition flow) {
        return flow.getAttributes().contains(PERSISTENCE_CONTEXT_ATTRIBUTE);
    }

    private org.hibernate.Session createSession(RequestContext context) {
        Session session = this.entityInterceptor != null ? this.sessionFactory.openSession(this.entityInterceptor) : this.sessionFactory.openSession();
        session.setFlushMode(FlushMode.MANUAL);
        return session;
    }

    private org.hibernate.Session getHibernateSession(FlowSession session) {
        return (org.hibernate.Session)session.getScope().get(PERSISTENCE_CONTEXT_ATTRIBUTE);
    }

    private void bind(org.hibernate.Session session) {
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(session));
    }

    private void unbind(org.hibernate.Session session) {
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }
    }
}

