/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.MappingResultsCriteria;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageCriteria;
import org.springframework.binding.message.Severity;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractErrors;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.webflow.engine.builder.BinderConfiguration;

public class BindingModel
extends AbstractErrors {
    private String objectName;
    private Object boundObject;
    private ExpressionParser expressionParser;
    private ConversionService conversionService;
    private MappingResults mappingResults;
    private MessageContext messageContext;
    private BinderConfiguration binderConfiguration;
    private static final MessageCriteria ERRORS_ANY_SOURCE = new MessageCriteria(){

        public boolean test(Message message) {
            return message.getSeverity() == Severity.ERROR;
        }
    };
    private static final MessageCriteria ERRORS_NULL_SOURCE = new MessageCriteria(){

        public boolean test(Message message) {
            return message.getSource() == null && message.getSeverity() == Severity.ERROR;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public BindingModel(String objectName, Object boundObject, ExpressionParser expressionParser, ConversionService conversionService, MessageContext messageContext) {
        Assert.hasText((String)objectName, (String)"The object name is required");
        Assert.notNull((Object)boundObject, (String)"The bound object instance is required");
        this.objectName = objectName;
        this.boundObject = boundObject;
        this.expressionParser = expressionParser;
        this.conversionService = conversionService;
        this.messageContext = messageContext;
    }

    public void setMappingResults(MappingResults results) {
        this.mappingResults = results;
    }

    public void setBinderConfiguration(BinderConfiguration binderConfiguration) {
        this.binderConfiguration = binderConfiguration;
    }

    public List getAllErrors() {
        return this.toErrors(this.messageContext.getMessagesByCriteria(ERRORS_ANY_SOURCE));
    }

    public List getGlobalErrors() {
        return this.toErrors(this.messageContext.getMessagesByCriteria(ERRORS_NULL_SOURCE));
    }

    public List getFieldErrors(String field) {
        return this.toErrors(this.messageContext.getMessagesByCriteria((MessageCriteria)new FieldErrorMessage(field)));
    }

    public Class getFieldType(String field) {
        return this.parseFieldExpression(field).getValueType(this.boundObject);
    }

    public Object getFieldValue(String field) {
        List results;
        if (this.mappingResults != null && !(results = this.mappingResults.getResults((MappingResultsCriteria)new FieldErrorResult(field))).isEmpty()) {
            MappingResult fieldError = (MappingResult)results.get(0);
            return fieldError.getOriginalValue();
        }
        return this.getFormattedValue(this.parseFieldExpression(field));
    }

    public List getFieldErrors() {
        return this.toErrors(this.messageContext.getMessagesByCriteria((MessageCriteria)new FieldErrorMessage()));
    }

    private Expression parseFieldExpression(String field) {
        return this.expressionParser.parseExpression(field, (ParserContext)new FluentParserContext().evaluate(this.boundObject.getClass()));
    }

    private Object getFormattedValue(Expression fieldExpression) {
        ConversionExecutor converter = this.getConverter(fieldExpression);
        if (converter != null) {
            return converter.execute(fieldExpression.getValue(this.boundObject));
        }
        return fieldExpression.getValue(this.boundObject);
    }

    private ConversionExecutor getConverter(Expression fieldExpression) {
        block21: {
            String converterId;
            BinderConfiguration.Binding binding;
            Class valueType;
            block23: {
                block22: {
                    if (this.conversionService == null) break block21;
                    valueType = fieldExpression.getValueType(this.boundObject);
                    if (valueType == null || valueType.isArray()) break block22;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.util.Collection");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isAssignableFrom(valueType)) break block22;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("java.util.Map");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz2.isAssignableFrom(valueType)) break block23;
                }
                return null;
            }
            if (this.binderConfiguration != null && (binding = this.binderConfiguration.getBinding(fieldExpression.getExpressionString())) != null && (converterId = binding.getConverter()) != null) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return this.conversionService.getConversionExecutor(converterId, valueType, (Class)clazz);
            }
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.conversionService.getConversionExecutor(valueType, (Class)clazz);
        }
        return null;
    }

    private List toErrors(Message[] messages) {
        if (messages == null || messages.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> errors = new ArrayList<Object>(messages.length);
        int i = 0;
        while (i < messages.length) {
            Message message = messages[i];
            if (message.getSource() == null) {
                errors.add(new ObjectError(this.objectName, message.getText()));
            } else {
                errors.add(new FieldError(this.objectName, (String)message.getSource(), message.getText()));
            }
            ++i;
        }
        return errors;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void addAllErrors(Errors errors) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    private static class FieldErrorMessage
    implements MessageCriteria {
        private String field;

        public FieldErrorMessage() {
        }

        public FieldErrorMessage(String field) {
            this.field = field;
        }

        public boolean test(Message message) {
            if (this.field != null) {
                return this.field.equals(message.getSource()) && message.getSeverity() == Severity.ERROR;
            }
            return message.getSource() != null && message.getSeverity() == Severity.ERROR;
        }
    }

    private static class FieldErrorResult
    implements MappingResultsCriteria {
        private String field;

        public FieldErrorResult(String field) {
            this.field = field;
        }

        public boolean test(MappingResult result) {
            return this.field.equals(result.getMapping().getTargetExpression().getExpressionString());
        }
    }
}

