/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.servlet;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.js.ajax.AjaxHandler;
import org.springframework.js.ajax.SpringJavascriptAjaxHandler;
import org.springframework.util.Assert;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.MvcExternalContext;

public class FlowHandlerAdapter
extends WebContentGenerator
implements HandlerAdapter,
InitializingBean {
    private static final Log logger;
    private static final String SERVLET_RELATIVE_LOCATION_PREFIX = "servletRelative:";
    private static final String CONTEXT_RELATIVE_LOCATION_PREFIX = "contextRelative:";
    private static final String SERVER_RELATIVE_LOCATION_PREFIX = "serverRelative:";
    private FlowExecutor flowExecutor;
    private FlowUrlHandler flowUrlHandler;
    private AjaxHandler ajaxHandler;
    private boolean redirectHttp10Compatible = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.mvc.servlet.FlowHandlerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public FlowHandlerAdapter() {
        this.setCacheSeconds(0);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowUrlHandler getFlowUrlHandler() {
        return this.flowUrlHandler;
    }

    public void setFlowUrlHandler(FlowUrlHandler flowUrlHandler) {
        this.flowUrlHandler = flowUrlHandler;
    }

    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    public void setRedirectHttp10Compatible(boolean redirectHttp10Compatible) {
        this.redirectHttp10Compatible = redirectHttp10Compatible;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.flowExecutor, (String)"The FlowExecutor to execute flows is required");
        if (this.flowUrlHandler == null) {
            this.flowUrlHandler = new DefaultFlowUrlHandler();
        }
        if (this.ajaxHandler == null) {
            this.ajaxHandler = new SpringJavascriptAjaxHandler();
        }
    }

    public boolean supports(Object handler) {
        return handler instanceof FlowHandler;
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        FlowHandler flowHandler = (FlowHandler)handler;
        this.checkAndPrepare(request, response, false);
        String flowExecutionKey = this.flowUrlHandler.getFlowExecutionKey(request);
        if (flowExecutionKey != null) {
            try {
                ServletExternalContext context = this.createServletExternalContext(request, response);
                FlowExecutionResult result = this.flowExecutor.resumeExecution(flowExecutionKey, context);
                this.handleFlowExecutionResult(result, context, request, response, flowHandler);
            }
            catch (FlowException e) {
                this.handleFlowException(e, request, response, flowHandler);
            }
        } else {
            try {
                String flowId = this.getFlowId(flowHandler, request);
                MutableAttributeMap input = this.getInputMap(flowHandler, request);
                ServletExternalContext context = this.createServletExternalContext(request, response);
                FlowExecutionResult result = this.flowExecutor.launchExecution(flowId, input, context);
                this.handleFlowExecutionResult(result, context, request, response, flowHandler);
            }
            catch (FlowException e) {
                this.handleFlowException(e, request, response, flowHandler);
            }
        }
        return null;
    }

    protected ServletExternalContext createServletExternalContext(HttpServletRequest request, HttpServletResponse response) {
        MvcExternalContext context = new MvcExternalContext(this.getServletContext(), request, response, this.flowUrlHandler);
        context.setAjaxRequest(this.ajaxHandler.isAjaxRequest(request, response));
        return context;
    }

    protected String defaultGetFlowId(HttpServletRequest request) {
        return this.flowUrlHandler.getFlowId(request);
    }

    protected MutableAttributeMap defaultCreateFlowExecutionInputMap(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        if (parameterMap.size() == 0) {
            return null;
        }
        LocalAttributeMap inputMap = new LocalAttributeMap(parameterMap.size(), 1);
        Iterator it = parameterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 1) {
                inputMap.put(name, values[0]);
                continue;
            }
            inputMap.put(name, values);
        }
        return inputMap;
    }

    protected void defaultHandleExecutionOutcome(String flowId, FlowExecutionOutcome outcome, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!context.isResponseComplete()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ended flow '" + flowId + "' did not commit a response; " + "attempting to start a new flow execution as a default outcome handler"));
            }
            response.sendRedirect(this.flowUrlHandler.createFlowDefinitionUrl(flowId, outcome.getOutput(), request));
        }
    }

    protected void defaultHandleException(String flowId, FlowException e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (e instanceof NoSuchFlowExecutionException && flowId != null) {
            if (!response.isCommitted()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Restarting a new execution of previously ended flow '" + flowId + "'"));
                }
                response.sendRedirect(this.flowUrlHandler.createFlowDefinitionUrl(flowId, null, request));
            }
        } else {
            throw e;
        }
    }

    private void handleFlowExecutionResult(FlowExecutionResult result, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response, FlowHandler handler) throws IOException {
        if (result.isPaused()) {
            if (context.getFlowExecutionRedirectRequested()) {
                this.sendFlowExecutionRedirect(result, context, request, response);
            } else if (context.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(result, context, request, response);
            } else if (context.getExternalRedirectRequested()) {
                this.sendExternalRedirect(context.getExternalRedirectUrl(), request, response);
            }
        } else if (result.isEnded()) {
            if (context.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(result, context, request, response);
            } else if (context.getExternalRedirectRequested()) {
                this.sendExternalRedirect(context.getExternalRedirectUrl(), request, response);
            } else {
                String location = handler.handleExecutionOutcome(result.getOutcome(), request, response);
                if (location != null) {
                    this.sendExternalRedirect(location, request, response);
                } else {
                    this.defaultHandleExecutionOutcome(result.getFlowId(), result.getOutcome(), context, request, response);
                }
            }
        } else {
            throw new IllegalStateException("Execution result should have been one of [paused] or [ended]");
        }
    }

    private void sendFlowExecutionRedirect(FlowExecutionResult result, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = this.flowUrlHandler.createFlowExecutionUrl(result.getFlowId(), result.getPausedKey(), request);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending flow execution redirect to '" + url + "'"));
        }
        if (context.isAjaxRequest()) {
            this.ajaxHandler.sendAjaxRedirect(url, request, response, context.getRedirectInPopup());
        } else {
            this.sendRedirect(url, request, response);
        }
    }

    private void sendFlowDefinitionRedirect(FlowExecutionResult result, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String flowId = context.getFlowRedirectFlowId();
        MutableAttributeMap input = context.getFlowRedirectFlowInput();
        if (result.isPaused()) {
            input.put("refererExecution", result.getPausedKey());
        }
        String url = this.flowUrlHandler.createFlowDefinitionUrl(flowId, input, request);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending flow definition redirect to '" + url + "'"));
        }
        this.sendRedirect(url, request, response);
    }

    private void sendExternalRedirect(String location, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending external redirect to '" + location + "'"));
        }
        if (location.startsWith(SERVLET_RELATIVE_LOCATION_PREFIX)) {
            this.sendServletRelativeRedirect(location.substring(SERVLET_RELATIVE_LOCATION_PREFIX.length()), request, response);
        } else if (location.startsWith(CONTEXT_RELATIVE_LOCATION_PREFIX)) {
            StringBuffer url = new StringBuffer(request.getContextPath());
            String contextRelativeUrl = location.substring(CONTEXT_RELATIVE_LOCATION_PREFIX.length());
            if (!contextRelativeUrl.startsWith("/")) {
                url.append('/');
            }
            url.append(contextRelativeUrl);
            this.sendRedirect(url.toString(), request, response);
        } else if (location.startsWith(SERVER_RELATIVE_LOCATION_PREFIX)) {
            String url = location.substring(SERVER_RELATIVE_LOCATION_PREFIX.length());
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            this.sendRedirect(url, request, response);
        } else if (location.startsWith("http://") || location.startsWith("https://")) {
            this.sendRedirect(location, request, response);
        } else {
            this.sendServletRelativeRedirect(location, request, response);
        }
    }

    private void sendServletRelativeRedirect(String location, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer url = new StringBuffer(request.getContextPath());
        url.append(request.getServletPath());
        if (!location.startsWith("/")) {
            url.append('/');
        }
        url.append(location);
        this.sendRedirect(url.toString(), request, response);
    }

    private void sendRedirect(String url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.ajaxHandler.isAjaxRequest(request, response)) {
            this.ajaxHandler.sendAjaxRedirect(url, request, response, false);
        } else if (this.redirectHttp10Compatible) {
            response.sendRedirect(response.encodeRedirectURL(url));
        } else {
            response.setStatus(303);
            response.setHeader("Location", response.encodeRedirectURL(url));
        }
    }

    private void handleFlowException(FlowException e, HttpServletRequest request, HttpServletResponse response, FlowHandler handler) throws IOException {
        String location = handler.handleException(e, request, response);
        if (location != null) {
            this.sendExternalRedirect(location, request, response);
        } else {
            this.defaultHandleException(this.getFlowId(handler, request), e, request, response);
        }
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    private String getFlowId(FlowHandler handler, HttpServletRequest request) {
        String flowId = handler.getFlowId();
        if (flowId != null) {
            return flowId;
        }
        return this.defaultGetFlowId(request);
    }

    private MutableAttributeMap getInputMap(FlowHandler handler, HttpServletRequest request) {
        MutableAttributeMap input = handler.createExecutionInputMap(request);
        if (input != null) {
            return input;
        }
        return this.defaultCreateFlowExecutionInputMap(request);
    }
}

