/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.builder;

import java.util.List;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.beanwrapper.BeanWrapperExpressionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.mvc.builder.DelegatingFlowViewResolver;
import org.springframework.webflow.mvc.builder.FlowResourceFlowViewResolver;
import org.springframework.webflow.mvc.builder.MvcEnvironment;
import org.springframework.webflow.mvc.portlet.PortletMvcViewFactory;
import org.springframework.webflow.mvc.servlet.ServletMvcViewFactory;
import org.springframework.webflow.mvc.view.AbstractMvcViewFactory;
import org.springframework.webflow.mvc.view.FlowViewResolver;

public class MvcViewFactoryCreator
implements ViewFactoryCreator,
ApplicationContextAware {
    private MvcEnvironment environment;
    private FlowViewResolver flowViewResolver = new FlowResourceFlowViewResolver();
    private boolean useSpringBeanBinding;
    private String eventIdParameterName;
    private String fieldMarkerPrefix;

    public void setDefaultViewSuffix(String defaultViewSuffix) {
        FlowResourceFlowViewResolver internalResourceResolver = new FlowResourceFlowViewResolver();
        internalResourceResolver.setDefaultViewSuffix(defaultViewSuffix);
        this.flowViewResolver = internalResourceResolver;
    }

    public void setEventIdParameterName(String eventIdParameterName) {
        this.eventIdParameterName = eventIdParameterName;
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    public void setUseSpringBeanBinding(boolean useSpringBeanBinding) {
        this.useSpringBeanBinding = useSpringBeanBinding;
    }

    public void setFlowViewResolver(FlowViewResolver flowViewResolver) {
        this.flowViewResolver = flowViewResolver;
    }

    public void setViewResolvers(List viewResolvers) {
        this.flowViewResolver = new DelegatingFlowViewResolver(viewResolvers);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.environment = MvcEnvironment.environmentFor(applicationContext);
    }

    public ViewFactory createViewFactory(Expression viewId, ExpressionParser expressionParser, ConversionService conversionService, BinderConfiguration binderConfiguration) {
        if (this.useSpringBeanBinding) {
            expressionParser = new BeanWrapperExpressionParser(conversionService);
        }
        AbstractMvcViewFactory viewFactory = this.createMvcViewFactory(viewId, expressionParser, conversionService, binderConfiguration);
        if (StringUtils.hasText((String)this.eventIdParameterName)) {
            viewFactory.setEventIdParameterName(this.eventIdParameterName);
        }
        if (StringUtils.hasText((String)this.fieldMarkerPrefix)) {
            viewFactory.setFieldMarkerPrefix(this.fieldMarkerPrefix);
        }
        return viewFactory;
    }

    private AbstractMvcViewFactory createMvcViewFactory(Expression viewId, ExpressionParser expressionParser, ConversionService conversionService, BinderConfiguration binderConfiguration) {
        if (this.environment == MvcEnvironment.SERVLET) {
            return new ServletMvcViewFactory(viewId, this.flowViewResolver, expressionParser, conversionService, binderConfiguration);
        }
        if (this.environment == MvcEnvironment.PORTLET) {
            return new PortletMvcViewFactory(viewId, this.flowViewResolver, expressionParser, conversionService, binderConfiguration);
        }
        throw new IllegalStateException("Web MVC Environment " + (Object)((Object)this.environment) + " not supported ");
    }

    public String getViewIdByConvention(String viewStateId) {
        return this.flowViewResolver.getViewIdByConvention(viewStateId);
    }
}

