/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.util.Map;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutor;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;

public class ActionExecutingViewFactory
implements ViewFactory {
    private Action action;

    public ActionExecutingViewFactory(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public View getView(RequestContext context) {
        return new ActionExecutingView(this.action, context);
    }

    private static class ActionExecutingView
    implements View {
        private Action action;
        private RequestContext requestContext;
        private String eventId;

        private ActionExecutingView(Action action, RequestContext requestContext) {
            this.action = action;
            this.requestContext = requestContext;
        }

        public void render() {
            if (this.action != null) {
                ActionExecutor.execute(this.action, this.requestContext);
            }
        }

        public void processUserEvent() {
            this.determineEventId(this.requestContext);
        }

        public boolean hasFlowEvent() {
            return this.eventId != null;
        }

        public Event getFlowEvent() {
            if (!this.hasFlowEvent()) {
                return null;
            }
            return new Event(this, this.eventId);
        }

        private void determineEventId(RequestContext context) {
            this.eventId = WebUtils.findParameterValue((Map)context.getRequestParameters().asMap(), (String)"_eventId");
        }
    }
}

