/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.builder;

import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.model.FlowModel;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilderException;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;

public class DefaultFlowModelHolder
implements FlowModelHolder {
    private FlowModel flowModel;
    private FlowModelBuilder flowModelBuilder;

    public DefaultFlowModelHolder(FlowModelBuilder flowModelBuilder) {
        Assert.notNull((Object)flowModelBuilder, (String)"The flow model builder is required");
        this.flowModelBuilder = flowModelBuilder;
    }

    public synchronized FlowModel getFlowModel() {
        if (this.flowModel == null) {
            this.assembleFlowModel();
        } else if (this.flowModelBuilder.hasFlowModelResourceChanged()) {
            this.assembleFlowModel();
        }
        return this.flowModel;
    }

    public Resource getFlowModelResource() {
        return this.flowModelBuilder.getFlowModelResource();
    }

    public boolean hasFlowModelChanged() {
        return this.flowModelBuilder.hasFlowModelResourceChanged();
    }

    public synchronized void refresh() {
        this.assembleFlowModel();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void assembleFlowModel() throws FlowModelBuilderException {
        try {
            this.flowModelBuilder.init();
            this.flowModelBuilder.build();
            this.flowModel = this.flowModelBuilder.getFlowModel();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.flowModelBuilder.dispose();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.flowModelBuilder.dispose();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowModelBuilder", (Object)this.flowModelBuilder).toString();
    }
}

