/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.webflow.engine.model.AbstractStateModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.SecuredModel;

public class DecisionStateModel
extends AbstractStateModel {
    private LinkedList ifs;
    private LinkedList onExitActions;

    public DecisionStateModel(String id) {
        this.setId(id);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof DecisionStateModel)) {
            return false;
        }
        DecisionStateModel state = (DecisionStateModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)state.getId());
    }

    public void merge(Model model) {
        DecisionStateModel state = (DecisionStateModel)model;
        this.setParent(null);
        this.setAttributes(this.merge(this.getAttributes(), state.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), state.getSecured()));
        this.setOnEntryActions(this.merge(this.getOnEntryActions(), state.getOnEntryActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), state.getExceptionHandlers()));
        this.setIfs(this.merge(this.getIfs(), state.getIfs()));
        this.setOnExitActions(this.merge(this.getOnExitActions(), state.getOnExitActions(), false));
    }

    public LinkedList getIfs() {
        return this.ifs;
    }

    public void setIfs(LinkedList ifs) {
        this.ifs = ifs;
    }

    public LinkedList getOnExitActions() {
        return this.onExitActions;
    }

    public void setOnExitActions(LinkedList onExitActions) {
        this.onExitActions = onExitActions;
    }
}

