/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.Model;

public class BindingModel
extends AbstractModel {
    private String property;
    private String converter;
    private String required;

    public BindingModel(String property, String converter, String required) {
        this.setProperty(property);
        this.setConverter(converter);
        this.setRequired(required);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof BindingModel)) {
            return false;
        }
        BindingModel binding = (BindingModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getProperty(), (Object)binding.getProperty());
    }

    public void merge(Model model) {
        BindingModel binding = (BindingModel)model;
        this.setConverter(this.merge(this.getConverter(), binding.getConverter()));
        this.setRequired(this.merge(this.getRequired(), binding.getRequired()));
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = StringUtils.hasText((String)property) ? property : null;
    }

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = StringUtils.hasText((String)converter) ? converter : null;
    }

    public String getRequired() {
        return this.required;
    }

    public void setRequired(String required) {
        this.required = StringUtils.hasText((String)required) ? required : null;
    }
}

