/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import org.springframework.binding.message.MessageContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.View;

class RequestControlContextImpl
implements RequestControlContext {
    private FlowExecutionImpl flowExecution;
    private ExternalContext externalContext;
    private MessageContext messageContext;
    private LocalAttributeMap requestScope = new LocalAttributeMap();
    private LocalAttributeMap attributes = new LocalAttributeMap();
    private Event currentEvent;
    private Transition currentTransition;

    public RequestControlContextImpl(FlowExecutionImpl flowExecution, ExternalContext externalContext, MessageContext messageContext) {
        this.flowExecution = flowExecution;
        this.externalContext = externalContext;
        this.messageContext = messageContext;
    }

    public FlowDefinition getActiveFlow() {
        return this.flowExecution.getActiveSession().getDefinition();
    }

    public StateDefinition getCurrentState() {
        return this.flowExecution.getActiveSession().getState();
    }

    public TransitionDefinition getMatchingTransition(String eventId) throws IllegalStateException {
        return this.flowExecution.getMatchingTransition(eventId);
    }

    public MutableAttributeMap getRequestScope() {
        return this.requestScope;
    }

    public MutableAttributeMap getFlashScope() {
        return this.flowExecution.getFlashScope();
    }

    public boolean inViewState() {
        return this.flowExecution.isActive() && this.getCurrentState() != null && this.getCurrentState().isViewState();
    }

    public MutableAttributeMap getViewScope() throws IllegalStateException {
        return this.flowExecution.getActiveSession().getViewScope();
    }

    public MutableAttributeMap getFlowScope() {
        return this.flowExecution.getActiveSession().getScope();
    }

    public MutableAttributeMap getConversationScope() {
        return this.flowExecution.getConversationScope();
    }

    public ParameterMap getRequestParameters() {
        return this.externalContext.getRequestParameterMap();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecution;
    }

    public Event getCurrentEvent() {
        return this.currentEvent;
    }

    public TransitionDefinition getCurrentTransition() {
        return this.currentTransition;
    }

    public MutableAttributeMap getAttributes() {
        return this.attributes;
    }

    public String getFlowExecutionUrl() {
        String key;
        String string = key = this.flowExecution.getKey() != null ? this.flowExecution.getKey().toString() : null;
        if (key != null) {
            return this.externalContext.getFlowExecutionUrl(this.flowExecution.getDefinition().getId(), key);
        }
        return null;
    }

    public void sendFlowExecutionRedirect() {
        this.externalContext.requestFlowExecutionRedirect();
    }

    public void setCurrentState(State state) {
        this.flowExecution.setCurrentState(state, this);
    }

    public FlowExecutionKey assignFlowExecutionKey() {
        return this.flowExecution.assignKey();
    }

    public void viewRendering(View view) {
        this.flowExecution.viewRendering(view, this);
    }

    public void viewRendered(View view) {
        this.flowExecution.viewRendered(view, this);
    }

    public boolean handleEvent(Event event) throws FlowExecutionException {
        this.currentEvent = event;
        return this.flowExecution.handleEvent(event, this);
    }

    public boolean execute(Transition transition) {
        return this.flowExecution.execute(transition, this);
    }

    public void setCurrentTransition(Transition transition) {
        this.currentTransition = transition;
    }

    public void updateCurrentFlowExecutionSnapshot() {
        this.flowExecution.updateCurrentFlowExecutionSnapshot();
    }

    public void removeCurrentFlowExecutionSnapshot() {
        this.flowExecution.removeCurrentFlowExecutionSnapshot();
    }

    public void removeAllFlowExecutionSnapshots() {
        this.flowExecution.removeAllFlowExecutionSnapshots();
    }

    public void start(Flow flow, MutableAttributeMap input) throws FlowExecutionException {
        this.flowExecution.start(flow, input, this);
    }

    public void endActiveFlowSession(String outcome, MutableAttributeMap output) throws IllegalStateException {
        this.flowExecution.endActiveFlowSession(outcome, output, this);
    }

    public boolean getRedirectOnPause() {
        Boolean redirectOnPause = this.flowExecution.getAttributes().getBoolean("alwaysRedirectOnPause");
        return redirectOnPause != null ? redirectOnPause : false;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("externalContext", (Object)this.externalContext).append("currentEvent", (Object)this.currentEvent).append("requestScope", (Object)this.requestScope).append("attributes", (Object)this.attributes).append("messageContext", (Object)this.messageContext).append("flowExecution", (Object)this.flowExecution).toString();
    }
}

