/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.support;

import java.util.Set;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionExecutorNotFoundException;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.binding.convert.service.GenericConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.builder.support.TextToTargetStateResolver;
import org.springframework.webflow.engine.builder.support.TextToTransitionCriteria;

public class FlowBuilderContextImpl
implements FlowBuilderContext {
    private String flowId;
    private AttributeMap flowAttributes;
    private FlowDefinitionLocator flowDefinitionLocator;
    private FlowBuilderServices flowBuilderServices;
    private ConversionService conversionService;

    public FlowBuilderContextImpl(String flowId, AttributeMap flowAttributes, FlowDefinitionLocator flowDefinitionLocator, FlowBuilderServices flowBuilderServices) {
        Assert.hasText((String)flowId, (String)"The flow id is required");
        Assert.notNull((Object)flowDefinitionLocator, (String)"The flow definition locator is required");
        Assert.notNull((Object)flowBuilderServices, (String)"The flow builder services holder is required");
        this.flowId = flowId;
        this.initFlowAttributes(flowAttributes);
        this.flowDefinitionLocator = flowDefinitionLocator;
        this.flowBuilderServices = flowBuilderServices;
        this.conversionService = this.createConversionService();
    }

    public FlowBuilderServices getFlowBuilderServices() {
        return this.flowBuilderServices;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public AttributeMap getFlowAttributes() {
        return this.flowAttributes;
    }

    public FlowArtifactFactory getFlowArtifactFactory() {
        return this.flowBuilderServices.getFlowArtifactFactory();
    }

    public FlowDefinitionLocator getFlowDefinitionLocator() {
        return this.flowDefinitionLocator;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public ViewFactoryCreator getViewFactoryCreator() {
        return this.flowBuilderServices.getViewFactoryCreator();
    }

    public ExpressionParser getExpressionParser() {
        return this.flowBuilderServices.getExpressionParser();
    }

    public ApplicationContext getApplicationContext() {
        return this.flowBuilderServices.getApplicationContext();
    }

    protected ConversionService createConversionService() {
        GenericConversionService service = new GenericConversionService();
        service.addConverter((Converter)new TextToTransitionCriteria(this));
        service.addConverter((Converter)new TextToTargetStateResolver(this));
        service.setParent((ConversionService)new ParentConversionServiceProxy());
        return service;
    }

    private void initFlowAttributes(AttributeMap flowAttributes) {
        this.flowAttributes = flowAttributes != null ? flowAttributes : CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    }

    private class ParentConversionServiceProxy
    implements ConversionService {
        private ParentConversionServiceProxy() {
        }

        public Object executeConversion(Object source, Class targetClass) throws ConversionException {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().executeConversion(source, targetClass);
        }

        public ConversionExecutor getConversionExecutor(Class sourceClass, Class targetClass) throws ConversionExecutionException {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().getConversionExecutor(sourceClass, targetClass);
        }

        public Set getConversionExecutors(Class sourceClass) {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().getConversionExecutors(sourceClass);
        }

        public ConversionExecutor getConversionExecutor(String id, Class sourceClass, Class targetClass) throws ConversionExecutorNotFoundException {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().getConversionExecutor(id, sourceClass, targetClass);
        }

        public Class getClassForAlias(String name) {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().getClassForAlias(name);
        }
    }
}

