/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.History;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewRenderingException;
import org.springframework.webflow.engine.ViewVariable;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;

public class ViewState
extends TransitionableState {
    private ActionList renderActionList = new ActionList();
    private ViewFactory viewFactory;
    private Map variables = new LinkedHashMap();
    private Boolean redirect;
    private boolean popup;

    public ViewState(Flow flow, String id, ViewFactory viewFactory) throws IllegalArgumentException {
        super(flow, id);
        Assert.notNull((Object)viewFactory, (String)"The view factory is required");
        this.viewFactory = viewFactory;
    }

    public boolean isViewState() {
        return true;
    }

    public void addVariable(ViewVariable variable) {
        this.variables.put(variable.getName(), variable);
    }

    public void addVariables(ViewVariable[] variables) {
        int i = 0;
        while (i < variables.length) {
            this.addVariable(variables[i]);
            ++i;
        }
    }

    public ViewVariable getVariable(String name) {
        return (ViewVariable)this.variables.get(name);
    }

    public ViewVariable[] getVariables() {
        return this.variables.values().toArray(new ViewVariable[this.variables.size()]);
    }

    public boolean getRedirect() {
        return this.redirect;
    }

    public void setRedirect(Boolean redirect) {
        this.redirect = redirect;
    }

    public boolean getPopup() {
        return this.popup;
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public ActionList getRenderActionList() {
        return this.renderActionList;
    }

    protected void doPreEntryActions(RequestControlContext context) throws FlowExecutionException {
        this.createVariables(context);
    }

    protected void doEnter(RequestControlContext context) throws FlowExecutionException {
        context.assignFlowExecutionKey();
        if (context.getExternalContext().isResponseAllowed()) {
            if (this.shouldRedirect(context)) {
                context.getExternalContext().requestFlowExecutionRedirect();
                if (this.popup) {
                    context.getExternalContext().requestRedirectInPopup();
                }
            } else {
                View view = this.viewFactory.getView(context);
                this.render(context, view);
            }
        }
    }

    public void resume(RequestControlContext context) {
        this.restoreVariables(context);
        View view = this.viewFactory.getView(context);
        view.processUserEvent();
        if (view.hasFlowEvent()) {
            Event event = view.getFlowEvent();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Event '" + event.getId() + "' returned from view " + view));
            }
            context.getRequestScope().put("webflow.originatingViewState", this);
            boolean stateExited = context.handleEvent(event);
            if (!stateExited && context.getExternalContext().isResponseAllowed()) {
                if (context.getExternalContext().isAjaxRequest()) {
                    this.render(context, view);
                } else {
                    context.getExternalContext().requestFlowExecutionRedirect();
                }
            }
        } else if (context.getExternalContext().isResponseAllowed()) {
            this.render(context, view);
        }
    }

    public void exit(RequestControlContext context) {
        super.exit(context);
        this.updateHistory(context);
        this.destroyVariables(context);
    }

    private void createVariables(RequestContext context) {
        Iterator it = this.variables.values().iterator();
        while (it.hasNext()) {
            ViewVariable variable = (ViewVariable)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating " + variable));
            }
            variable.create(context);
        }
    }

    private boolean shouldRedirect(RequestControlContext context) {
        if (this.redirect != null) {
            return this.redirect;
        }
        return context.getRedirectOnPause();
    }

    private void render(RequestControlContext context, View view) throws ViewRenderingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering + " + view));
            this.logger.debug((Object)("  Flash scope = " + context.getFlashScope()));
            this.logger.debug((Object)("  Messages = " + context.getMessageContext()));
        }
        context.viewRendering(view);
        this.renderActionList.execute(context);
        try {
            view.render();
        }
        catch (IOException e) {
            throw new ViewRenderingException(this.getOwner().getId(), this.getId(), view, (Throwable)e);
        }
        context.getFlashScope().clear();
        context.getMessageContext().clearMessages();
        context.getExternalContext().recordResponseComplete();
        context.viewRendered(view);
    }

    private void restoreVariables(RequestContext context) {
        Iterator it = this.variables.values().iterator();
        while (it.hasNext()) {
            ViewVariable variable = (ViewVariable)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Restoring " + variable));
            }
            variable.restore(context);
        }
    }

    private void updateHistory(RequestControlContext context) {
        TransitionDefinition transition = context.getCurrentTransition();
        History history = (History)((Object)transition.getAttributes().get("history"));
        if (history == null || history == History.PRESERVE) {
            context.updateCurrentFlowExecutionSnapshot();
        } else if (history == History.DISCARD) {
            context.removeCurrentFlowExecutionSnapshot();
        } else if (history == History.INVALIDATE) {
            context.removeAllFlowExecutionSnapshots();
        }
    }

    private void destroyVariables(RequestContext context) {
        Iterator it = this.variables.values().iterator();
        while (it.hasNext()) {
            ViewVariable variable = (ViewVariable)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Destroying " + variable));
            }
            variable.destroy(context);
        }
    }

    protected void appendToString(ToStringCreator creator) {
        super.appendToString(creator);
        creator.append("viewFactory", (Object)this.viewFactory).append("variables", (Object)this.variables).append("redirect", (Object)this.redirect).append("popup", this.popup);
    }
}

