/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.core.collection.AttributeMap;

public class DefaultFlowUrlHandler
implements FlowUrlHandler {
    private static final String DEFAULT_URL_ENCODING_SCHEME = "UTF-8";
    private String urlEncodingScheme = "UTF-8";

    public String getFlowExecutionKey(HttpServletRequest request) {
        return request.getParameter("execution");
    }

    public String getFlowId(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return pathInfo.substring(1);
        }
        String servletPath = request.getServletPath();
        if (StringUtils.hasText((String)servletPath)) {
            int dotIndex = servletPath.lastIndexOf(46);
            if (dotIndex != -1) {
                return servletPath.substring(1, dotIndex);
            }
            return servletPath.substring(1);
        }
        return request.getContextPath().substring(1);
    }

    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, HttpServletRequest request) {
        StringBuffer url = new StringBuffer();
        url.append(request.getRequestURI());
        url.append('?');
        this.appendQueryParameter(url, "execution", flowExecutionKey);
        return url.toString();
    }

    public String createFlowDefinitionUrl(String flowId, AttributeMap input, HttpServletRequest request) {
        StringBuffer url = new StringBuffer();
        if (request.getPathInfo() != null) {
            url.append(request.getContextPath());
            url.append(request.getServletPath());
            url.append('/');
            url.append(flowId);
        } else if (StringUtils.hasText((String)request.getServletPath())) {
            url.append(request.getContextPath());
            url.append('/');
            url.append(flowId);
        } else {
            url.append('/');
            url.append(flowId);
        }
        if (input != null && !input.isEmpty()) {
            url.append('?');
            this.appendQueryParameters(url, input.asMap());
        }
        return url.toString();
    }

    private void appendQueryParameters(StringBuffer url, Map parameters) {
        Iterator entries = parameters.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.appendQueryParameter(url, entry.getKey(), entry.getValue());
            if (!entries.hasNext()) continue;
            url.append('&');
        }
    }

    private void appendQueryParameter(StringBuffer url, Object key, Object value) {
        String encodedKey = this.encode(key);
        String encodedValue = this.encode(value);
        url.append(encodedKey).append('=').append(encodedValue);
    }

    private String encode(Object value) {
        return value != null ? this.urlEncode(String.valueOf(value)) : "";
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(String.valueOf(value), this.urlEncodingScheme);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Cannot url encode " + value);
        }
    }
}

