/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import reactor.cache.CacheFlux;
import reactor.core.publisher.Flux;

public class CachingRouteLocator
implements RouteLocator {
    private final RouteLocator delegate;
    private final Flux<Route> routes;
    private final Map<String, List> cache = new HashMap<String, List>();

    public CachingRouteLocator(RouteLocator delegate) {
        this.delegate = delegate;
        this.routes = CacheFlux.lookup(this.cache, (Object)"routes", Route.class).onCacheMissResume(() -> this.delegate.getRoutes().sort((Comparator)AnnotationAwareOrderComparator.INSTANCE));
    }

    @Override
    public Flux<Route> getRoutes() {
        return this.routes;
    }

    public Flux<Route> refresh() {
        this.cache.clear();
        return this.routes;
    }

    @EventListener(value={RefreshRoutesEvent.class})
    void handleRefresh() {
        this.refresh();
    }
}

