/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Map;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.cloud.gateway.support.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.support.DefaultServerRequest;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReadBodyPredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private static final String TEST_ATTRIBUTE = "read_body_predicate_test_attribute";
    private final ServerCodecConfigurer codecConfigurer;

    public ReadBodyPredicateFactory(ServerCodecConfigurer codecConfigurer) {
        super(Config.class);
        this.codecConfigurer = codecConfigurer;
    }

    @Override
    public AsyncPredicate<ServerWebExchange> applyAsync(Config config) {
        return exchange -> {
            Class inClass = config.getInClass();
            DefaultServerRequest serverRequest = new DefaultServerRequest((ServerWebExchange)exchange);
            Mono modifiedBody = serverRequest.bodyToMono(inClass).flatMap(body -> {
                boolean test = config.predicate.test(body);
                exchange.getAttributes().put(TEST_ATTRIBUTE, test);
                return Mono.just((Object)body);
            });
            BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)modifiedBody, (Class)inClass);
            CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage((ServerWebExchange)exchange, exchange.getRequest().getHeaders());
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                boolean test = exchange.getAttributes().getOrDefault(TEST_ATTRIBUTE, Boolean.FALSE);
                exchange.getAttributes().remove(TEST_ATTRIBUTE);
                exchange.getAttributes().put("cachedRequestBody", outputMessage.getBody());
                return Mono.just((Object)test);
            }));
        };
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        throw new UnsupportedOperationException("ReadBodyPredicateFactory is only async.");
    }

    public static class Config {
        private Class inClass;
        private Predicate predicate;
        private Map<String, Object> hints;

        public Class getInClass() {
            return this.inClass;
        }

        public Config setInClass(Class inClass) {
            this.inClass = inClass;
            return this;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        public <T> Config setPredicate(Class<T> inClass, Predicate<T> predicate) {
            this.setInClass(inClass);
            this.predicate = predicate;
            return this;
        }

        public Config setPredicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Map<String, Object> getHints() {
            return this.hints;
        }

        public Config setHints(Map<String, Object> hints) {
            this.hints = hints;
            return this;
        }
    }
}

