/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.server.PathContainer;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class PathRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private static final Log log = LogFactory.getLog(RoutePredicateFactory.class);
    private PathPatternParser pathPatternParser = new PathPatternParser();

    public PathRoutePredicateFactory() {
        super(Config.class);
    }

    public void setPathPatternParser(PathPatternParser pathPatternParser) {
        this.pathPatternParser = pathPatternParser;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("pattern");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        PathPatternParser pathPatternParser = this.pathPatternParser;
        synchronized (pathPatternParser) {
            config.pathPattern = this.pathPatternParser.parse(config.pattern);
        }
        return exchange -> {
            PathContainer path = PathContainer.parsePath((String)exchange.getRequest().getURI().getPath());
            boolean match = config.pathPattern.matches(path);
            PathRoutePredicateFactory.traceMatch("Pattern", config.pathPattern.getPatternString(), path, match);
            if (match) {
                PathPattern.PathMatchInfo uriTemplateVariables = config.pathPattern.matchAndExtract(path);
                exchange.getAttributes().put(ServerWebExchangeUtils.URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriTemplateVariables);
                return true;
            }
            return false;
        };
    }

    private static void traceMatch(String prefix, Object desired, Object actual, boolean match) {
        if (log.isTraceEnabled()) {
            String message = String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual);
            log.trace((Object)message);
        }
    }

    @Validated
    public static class Config {
        private String pattern;
        private PathPattern pathPattern;

        public String getPattern() {
            return this.pattern;
        }

        public Config setPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("pattern", (Object)this.pattern).toString();
        }
    }
}

