/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class HostRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private PathMatcher pathMatcher = new AntPathMatcher(".");

    public HostRoutePredicateFactory() {
        super(Config.class);
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("pattern");
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        return exchange -> {
            String host = exchange.getRequest().getHeaders().getFirst("Host");
            return this.pathMatcher.match(config.getPattern(), host);
        };
    }

    @Validated
    public static class Config {
        private String pattern;

        public String getPattern() {
            return this.pattern;
        }

        public Config setPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("pattern", (Object)this.pattern).toString();
        }
    }
}

