/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class HeaderRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String HEADER_KEY = "header";
    public static final String REGEXP_KEY = "regexp";

    public HeaderRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(HEADER_KEY, REGEXP_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        return exchange -> {
            List values = exchange.getRequest().getHeaders().get((Object)config.header);
            if (values != null) {
                for (String value : values) {
                    if (!value.matches(config.regexp)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    @Validated
    public static class Config {
        @NotEmpty
        private String header;
        private String regexp;

        public String getHeader() {
            return this.header;
        }

        public Config setHeader(String header) {
            this.header = header;
            return this;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }
    }
}

