/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class BetweenRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String DATETIME1_KEY = "datetime1";
    public static final String DATETIME2_KEY = "datetime2";

    public BetweenRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(DATETIME1_KEY, DATETIME2_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        ZonedDateTime datetime1 = BetweenRoutePredicateFactory.getZonedDateTime(config.datetime1);
        ZonedDateTime datetime2 = BetweenRoutePredicateFactory.getZonedDateTime(config.datetime2);
        Assert.isTrue((boolean)datetime1.isBefore(datetime2), (String)(config.datetime1 + " must be before " + config.datetime2));
        return exchange -> {
            ZonedDateTime now = ZonedDateTime.now();
            return now.isAfter(datetime1) && now.isBefore(datetime2);
        };
    }

    public static ZonedDateTime getZonedDateTime(Object value) {
        ZonedDateTime dateTime = value instanceof ZonedDateTime ? (ZonedDateTime)ZonedDateTime.class.cast(value) : BetweenRoutePredicateFactory.parseZonedDateTime(value.toString());
        return dateTime;
    }

    public static ZonedDateTime parseZonedDateTime(String dateString) {
        ZonedDateTime dateTime;
        try {
            long epoch = Long.parseLong(dateString);
            dateTime = Instant.ofEpochMilli(epoch).atOffset(ZoneOffset.ofTotalSeconds(0)).toZonedDateTime();
        }
        catch (NumberFormatException e) {
            dateTime = ZonedDateTime.parse(dateString);
        }
        return dateTime;
    }

    @Validated
    public static class Config {
        @NotEmpty
        private String datetime1;
        @NotEmpty
        private String datetime2;

        public String getDatetime1() {
            return this.datetime1;
        }

        public Config setDatetime1(String datetime1) {
            this.datetime1 = datetime1;
            return this;
        }

        public String getDatetime2() {
            return this.datetime2;
        }

        public Config setDatetime2(String datetime2) {
            this.datetime2 = datetime2;
            return this;
        }
    }
}

