/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import reactor.ipc.netty.resources.PoolResources;

@ConfigurationProperties(value="spring.cloud.gateway.httpclient")
public class HttpClientProperties {
    private Integer connectTimeout;
    private Pool pool = new Pool();
    private Proxy proxy = new Proxy();
    private Ssl ssl = new Ssl();

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public String toString() {
        return "HttpClientProperties{connectTimeout=" + this.connectTimeout + ", pool=" + this.pool + ", proxy=" + this.proxy + ", ssl=" + this.ssl + '}';
    }

    public class Ssl {
        private boolean useInsecureTrustManager = false;

        public boolean isUseInsecureTrustManager() {
            return this.useInsecureTrustManager;
        }

        public void setUseInsecureTrustManager(boolean useInsecureTrustManager) {
            this.useInsecureTrustManager = useInsecureTrustManager;
        }

        public String toString() {
            return "Ssl{useInsecureTrustManager=" + this.useInsecureTrustManager + '}';
        }
    }

    public class Proxy {
        private String host;
        private Integer port;
        private String username;
        private String password;
        private String nonProxyHostsPattern;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getNonProxyHostsPattern() {
            return this.nonProxyHostsPattern;
        }

        public void setNonProxyHostsPattern(String nonProxyHostsPattern) {
            this.nonProxyHostsPattern = nonProxyHostsPattern;
        }

        public String toString() {
            return "Proxy{host='" + this.host + '\'' + ", port=" + this.port + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", nonProxyHostsPattern='" + this.nonProxyHostsPattern + '\'' + '}';
        }
    }

    public static class Pool {
        private PoolType type = PoolType.ELASTIC;
        private String name = "proxy";
        private Integer maxConnections = PoolResources.DEFAULT_POOL_MAX_CONNECTION;
        private Long acquireTimeout = PoolResources.DEFAULT_POOL_ACQUIRE_TIMEOUT;

        public PoolType getType() {
            return this.type;
        }

        public void setType(PoolType type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        public Long getAcquireTimeout() {
            return this.acquireTimeout;
        }

        public void setAcquireTimeout(Long acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
        }

        public String toString() {
            return "Pool{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", maxConnections=" + this.maxConnections + ", acquireTimeout=" + this.acquireTimeout + '}';
        }

        public static enum PoolType {
            ELASTIC,
            FIXED,
            DISABLED;

        }
    }
}

