/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import javax.sql.DataSource;
import org.springframework.batch.item.database.support.SqlWindowingPagingQueryProvider;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.support.JdbcUtils;

public class DerbyPagingQueryProvider
extends SqlWindowingPagingQueryProvider {
    private String version;

    @Override
    public void init(DataSource dataSource) throws Exception {
        super.init(dataSource);
        this.version = JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getDatabaseProductVersion").toString();
        if ("10.4.1.3".compareTo(this.version) > 0) {
            throw new InvalidDataAccessResourceUsageException("Apache Derby version " + this.version + " is not supported by this class,  Only version 10.4.1.3 or later is supported");
        }
    }

    @Override
    protected String getOrderedQueryAlias() {
        return "TMP_ORDERED";
    }

    @Override
    protected String getOverClause() {
        return "";
    }

    @Override
    protected String getOverSubstituteClauseStart() {
        return " FROM (SELECT " + this.getSelectClause();
    }

    @Override
    protected String getOverSubstituteClauseEnd() {
        return " ) AS " + this.getOrderedQueryAlias();
    }
}

