/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class StepBuilderHelper<B extends StepBuilderHelper<B>> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final CommonStepProperties properties;

    public StepBuilderHelper(String name) {
        this.properties = new CommonStepProperties();
        this.properties.name = name;
    }

    protected StepBuilderHelper(StepBuilderHelper<?> parent) {
        this.properties = new CommonStepProperties(parent.properties);
    }

    public B repository(JobRepository jobRepository) {
        this.properties.jobRepository = jobRepository;
        StepBuilderHelper result = this;
        return (B)result;
    }

    public B transactionManager(PlatformTransactionManager transactionManager) {
        this.properties.transactionManager = transactionManager;
        StepBuilderHelper result = this;
        return (B)result;
    }

    public B startLimit(int startLimit) {
        this.properties.startLimit = startLimit;
        StepBuilderHelper result = this;
        return (B)result;
    }

    public B listener(StepExecutionListener listener) {
        this.properties.addStepExecutionListener(listener);
        StepBuilderHelper result = this;
        return (B)result;
    }

    public B allowStartIfComplete(boolean allowStartIfComplete) {
        this.properties.allowStartIfComplete = allowStartIfComplete;
        StepBuilderHelper result = this;
        return (B)result;
    }

    protected String getName() {
        return this.properties.name;
    }

    protected JobRepository getJobRepository() {
        return this.properties.jobRepository;
    }

    protected PlatformTransactionManager getTransactionManager() {
        return this.properties.transactionManager;
    }

    protected boolean isAllowStartIfComplete() {
        return this.properties.allowStartIfComplete != null ? this.properties.allowStartIfComplete : false;
    }

    protected void enhance(Step target) {
        AbstractStep step;
        if (target instanceof AbstractStep) {
            step = (AbstractStep)target;
            step.setJobRepository(this.properties.getJobRepository());
            Boolean allowStartIfComplete = this.properties.allowStartIfComplete;
            if (allowStartIfComplete != null) {
                step.setAllowStartIfComplete(allowStartIfComplete);
            }
            step.setStartLimit(this.properties.startLimit);
            List listeners = this.properties.stepExecutionListeners;
            if (!listeners.isEmpty()) {
                step.setStepExecutionListeners(listeners.toArray(new StepExecutionListener[0]));
            }
        }
        if (target instanceof TaskletStep) {
            step = (TaskletStep)target;
            ((TaskletStep)step).setTransactionManager(this.properties.transactionManager);
        }
    }

    public static class CommonStepProperties {
        private List<StepExecutionListener> stepExecutionListeners = new ArrayList<StepExecutionListener>();
        private int startLimit = Integer.MAX_VALUE;
        private Boolean allowStartIfComplete;
        private JobRepository jobRepository;
        private PlatformTransactionManager transactionManager;
        private String name;

        public CommonStepProperties() {
        }

        public CommonStepProperties(CommonStepProperties properties) {
            this.name = properties.name;
            this.startLimit = properties.startLimit;
            this.allowStartIfComplete = properties.allowStartIfComplete;
            this.jobRepository = properties.jobRepository;
            this.transactionManager = properties.transactionManager;
            this.stepExecutionListeners = new ArrayList<StepExecutionListener>(properties.stepExecutionListeners);
        }

        public JobRepository getJobRepository() {
            return this.jobRepository;
        }

        public void setJobRepository(JobRepository jobRepository) {
            this.jobRepository = jobRepository;
        }

        public PlatformTransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public void setTransactionManager(PlatformTransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<StepExecutionListener> getStepExecutionListeners() {
            return this.stepExecutionListeners;
        }

        public void addStepExecutionListeners(List<StepExecutionListener> stepExecutionListeners) {
            this.stepExecutionListeners.addAll(stepExecutionListeners);
        }

        public void addStepExecutionListener(StepExecutionListener stepExecutionListener) {
            this.stepExecutionListeners.add(stepExecutionListener);
        }

        public Integer getStartLimit() {
            return this.startLimit;
        }

        public void setStartLimit(Integer startLimit) {
            this.startLimit = startLimit;
        }

        public Boolean getAllowStartIfComplete() {
            return this.allowStartIfComplete;
        }

        public void setAllowStartIfComplete(Boolean allowStartIfComplete) {
            this.allowStartIfComplete = allowStartIfComplete;
        }
    }
}

