/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.beans;

import com.ibatis.common.beans.GetFieldInvoker;
import com.ibatis.common.beans.Invoker;
import com.ibatis.common.beans.MethodInvoker;
import com.ibatis.common.beans.ProbeException;
import com.ibatis.common.beans.SetFieldInvoker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class ClassInfo {
    private static boolean cacheEnabled = true;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Set SIMPLE_TYPE_SET = new HashSet();
    private static final Map<Class, ClassInfo> CLASS_INFO_MAP = new ConcurrentHashMap<Class, ClassInfo>();
    private String className;
    private String[] readablePropertyNames = EMPTY_STRING_ARRAY;
    private String[] writeablePropertyNames = EMPTY_STRING_ARRAY;
    private HashMap setMethods = new HashMap();
    private HashMap getMethods = new HashMap();
    private HashMap setTypes = new HashMap();
    private HashMap getTypes = new HashMap();
    private Constructor defaultConstructor;

    private ClassInfo(Class clazz) {
        this.className = clazz.getName();
        this.addDefaultConstructor(clazz);
        this.addGetMethods(clazz);
        this.addSetMethods(clazz);
        this.addFields(clazz);
        this.readablePropertyNames = this.getMethods.keySet().toArray(new String[this.getMethods.keySet().size()]);
        this.writeablePropertyNames = this.setMethods.keySet().toArray(new String[this.setMethods.keySet().size()]);
    }

    private void addDefaultConstructor(Class clazz) {
        Constructor<?>[] consts = clazz.getDeclaredConstructors();
        for (int i = 0; i < consts.length; ++i) {
            Constructor<?> constructor = consts[i];
            if (constructor.getParameterTypes().length != 0) continue;
            if (ClassInfo.canAccessPrivateMethods()) {
                try {
                    constructor.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!constructor.isAccessible()) continue;
            this.defaultConstructor = constructor;
        }
    }

    private void addGetMethods(Class cls) {
        Method[] methods = this.getClassMethods(cls);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            if (name.startsWith("get") && name.length() > 3) {
                if (method.getParameterTypes().length != 0) continue;
                name = ClassInfo.dropCase(name);
                this.addGetMethod(name, method);
                continue;
            }
            if (!name.startsWith("is") || name.length() <= 2 || method.getParameterTypes().length != 0) continue;
            name = ClassInfo.dropCase(name);
            this.addGetMethod(name, method);
        }
    }

    private void addGetMethod(String name, Method method) {
        this.getMethods.put(name, new MethodInvoker(method));
        this.getTypes.put(name, method.getReturnType());
    }

    private void addSetMethods(Class cls) {
        HashMap conflictingSetters = new HashMap();
        Method[] methods = this.getClassMethods(cls);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            if (!name.startsWith("set") || name.length() <= 3 || method.getParameterTypes().length != 1) continue;
            name = ClassInfo.dropCase(name);
            this.addSetterConflict(conflictingSetters, name, method);
        }
        this.resolveSetterConflicts(conflictingSetters);
    }

    private void addSetterConflict(Map conflictingSetters, String name, Method method) {
        ArrayList<Method> list = (ArrayList<Method>)conflictingSetters.get(name);
        if (list == null) {
            list = new ArrayList<Method>();
            conflictingSetters.put(name, list);
        }
        list.add(method);
    }

    private void resolveSetterConflicts(Map conflictingSetters) {
        for (String propName : conflictingSetters.keySet()) {
            List setters = (List)conflictingSetters.get(propName);
            Method firstMethod = (Method)setters.get(0);
            if (setters.size() == 1) {
                this.addSetMethod(propName, firstMethod);
                continue;
            }
            Class expectedType = (Class)this.getTypes.get(propName);
            if (expectedType == null) {
                throw new RuntimeException("Illegal overloaded setter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans " + "specification and can cause unpredicatble results.");
            }
            Iterator methods = setters.iterator();
            Method setter = null;
            while (methods.hasNext()) {
                Method method = (Method)methods.next();
                if (method.getParameterTypes().length != 1 || !expectedType.equals(method.getParameterTypes()[0])) continue;
                setter = method;
                break;
            }
            if (setter == null) {
                throw new RuntimeException("Illegal overloaded setter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans " + "specification and can cause unpredicatble results.");
            }
            this.addSetMethod(propName, setter);
        }
    }

    private void addSetMethod(String name, Method method) {
        this.setMethods.put(name, new MethodInvoker(method));
        this.setTypes.put(name, method.getParameterTypes()[0]);
    }

    private void addFields(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (ClassInfo.canAccessPrivateMethods()) {
                try {
                    field.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!field.isAccessible()) continue;
            if (!this.setMethods.containsKey(field.getName())) {
                this.addSetField(field);
            }
            if (this.getMethods.containsKey(field.getName())) continue;
            this.addGetField(field);
        }
        if (clazz.getSuperclass() != null) {
            this.addFields(clazz.getSuperclass());
        }
    }

    private void addSetField(Field field) {
        this.setMethods.put(field.getName(), new SetFieldInvoker(field));
        this.setTypes.put(field.getName(), field.getType());
    }

    private void addGetField(Field field) {
        this.getMethods.put(field.getName(), new GetFieldInvoker(field));
        this.getTypes.put(field.getName(), field.getType());
    }

    private Method[] getClassMethods(Class cls) {
        HashMap uniqueMethods = new HashMap();
        for (Class currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            this.addUniqueMethods(uniqueMethods, currentClass.getDeclaredMethods());
            Class<?>[] interfaces = currentClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.addUniqueMethods(uniqueMethods, interfaces[i].getMethods());
            }
        }
        Collection methods = uniqueMethods.values();
        return methods.toArray(new Method[methods.size()]);
    }

    private void addUniqueMethods(HashMap uniqueMethods, Method[] methods) {
        for (Method currentMethod : methods) {
            String signature;
            if (currentMethod.isBridge() || uniqueMethods.containsKey(signature = this.getSignature(currentMethod))) continue;
            if (ClassInfo.canAccessPrivateMethods()) {
                try {
                    currentMethod.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            uniqueMethods.put(signature, currentMethod);
        }
    }

    private String getSignature(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private static String dropCase(String name) {
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("get") || name.startsWith("set")) {
            name = name.substring(3);
        } else {
            throw new ProbeException("Error parsing property name '" + name + "'.  Didn't start with 'is', 'get' or 'set'.");
        }
        if (name.length() == 1 || name.length() > 1 && !Character.isUpperCase(name.charAt(1))) {
            name = name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
        }
        return name;
    }

    private static boolean canAccessPrivateMethods() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (null != securityManager) {
                securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public String getClassName() {
        return this.className;
    }

    public Object instantiateClass() {
        if (this.defaultConstructor != null) {
            try {
                return this.defaultConstructor.newInstance(null);
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating class. Cause: " + e, e);
            }
        }
        throw new RuntimeException("Error instantiating class.  There is no default constructor for class " + this.className);
    }

    public Method getSetter(String propertyName) {
        Invoker method = (Invoker)this.setMethods.get(propertyName);
        if (method == null) {
            throw new ProbeException("There is no WRITEABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        if (!(method instanceof MethodInvoker)) {
            throw new ProbeException("Can't get setter method because '" + propertyName + "' is a field in class '" + this.className + "'");
        }
        return ((MethodInvoker)method).getMethod();
    }

    public Method getGetter(String propertyName) {
        Invoker method = (Invoker)this.getMethods.get(propertyName);
        if (method == null) {
            throw new ProbeException("There is no READABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        if (!(method instanceof MethodInvoker)) {
            throw new ProbeException("Can't get getter method because '" + propertyName + "' is a field in class '" + this.className + "'");
        }
        return ((MethodInvoker)method).getMethod();
    }

    public Invoker getSetInvoker(String propertyName) {
        Invoker method = (Invoker)this.setMethods.get(propertyName);
        if (method == null) {
            throw new ProbeException("There is no WRITEABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Invoker getGetInvoker(String propertyName) {
        Invoker method = (Invoker)this.getMethods.get(propertyName);
        if (method == null) {
            throw new ProbeException("There is no READABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Class getSetterType(String propertyName) {
        Class clazz = (Class)this.setTypes.get(propertyName);
        if (clazz == null) {
            throw new ProbeException("There is no WRITEABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return clazz;
    }

    public Class getGetterType(String propertyName) {
        Class clazz = (Class)this.getTypes.get(propertyName);
        if (clazz == null) {
            throw new ProbeException("There is no READABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return clazz;
    }

    public String[] getReadablePropertyNames() {
        return this.readablePropertyNames;
    }

    public String[] getWriteablePropertyNames() {
        return this.writeablePropertyNames;
    }

    public boolean hasWritableProperty(String propertyName) {
        return this.setMethods.keySet().contains(propertyName);
    }

    public boolean hasReadableProperty(String propertyName) {
        return this.getMethods.keySet().contains(propertyName);
    }

    public static boolean isKnownType(Class clazz) {
        if (SIMPLE_TYPE_SET.contains(clazz)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Iterator.class.isAssignableFrom(clazz);
    }

    public static ClassInfo getInstance(Class clazz) {
        if (cacheEnabled) {
            ClassInfo cached = CLASS_INFO_MAP.get(clazz);
            if (cached == null) {
                cached = new ClassInfo(clazz);
                CLASS_INFO_MAP.put(clazz, cached);
            }
            return cached;
        }
        return new ClassInfo(clazz);
    }

    public static void setCacheEnabled(boolean cacheEnabled) {
        ClassInfo.cacheEnabled = cacheEnabled;
    }

    public static Throwable unwrapThrowable(Throwable t) {
        Throwable t2 = t;
        while (true) {
            if (t2 instanceof InvocationTargetException) {
                t2 = ((InvocationTargetException)t).getTargetException();
                continue;
            }
            if (!(t instanceof UndeclaredThrowableException)) break;
            t2 = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
        }
        return t2;
    }

    static {
        SIMPLE_TYPE_SET.add(String.class);
        SIMPLE_TYPE_SET.add(Byte.class);
        SIMPLE_TYPE_SET.add(Short.class);
        SIMPLE_TYPE_SET.add(Character.class);
        SIMPLE_TYPE_SET.add(Integer.class);
        SIMPLE_TYPE_SET.add(Long.class);
        SIMPLE_TYPE_SET.add(Float.class);
        SIMPLE_TYPE_SET.add(Double.class);
        SIMPLE_TYPE_SET.add(Boolean.class);
        SIMPLE_TYPE_SET.add(Date.class);
        SIMPLE_TYPE_SET.add(Class.class);
        SIMPLE_TYPE_SET.add(BigInteger.class);
        SIMPLE_TYPE_SET.add(BigDecimal.class);
        SIMPLE_TYPE_SET.add(Collection.class);
        SIMPLE_TYPE_SET.add(Set.class);
        SIMPLE_TYPE_SET.add(Map.class);
        SIMPLE_TYPE_SET.add(List.class);
        SIMPLE_TYPE_SET.add(HashMap.class);
        SIMPLE_TYPE_SET.add(TreeMap.class);
        SIMPLE_TYPE_SET.add(ArrayList.class);
        SIMPLE_TYPE_SET.add(LinkedList.class);
        SIMPLE_TYPE_SET.add(HashSet.class);
        SIMPLE_TYPE_SET.add(TreeSet.class);
        SIMPLE_TYPE_SET.add(Vector.class);
        SIMPLE_TYPE_SET.add(Hashtable.class);
        SIMPLE_TYPE_SET.add(Enumeration.class);
    }
}

