/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools;

import org.jooq.tools.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JooqLogger {
    private static volatile Level globalThreshold = Level.TRACE;
    private Logger slf4j;
    private org.apache.log4j.Logger log4j;
    private java.util.logging.Logger util;
    private boolean supportsTrace = true;
    private boolean supportsDebug = true;
    private boolean supportsInfo = true;

    public static JooqLogger getLogger(Class<?> clazz) {
        JooqLogger result = new JooqLogger();
        try {
            result.slf4j = LoggerFactory.getLogger(clazz);
        }
        catch (Throwable e1) {
            try {
                result.log4j = org.apache.log4j.Logger.getLogger(clazz);
            }
            catch (Throwable e2) {
                result.util = java.util.logging.Logger.getLogger(clazz.getName());
            }
        }
        try {
            result.isInfoEnabled();
        }
        catch (Throwable e) {
            result.supportsInfo = false;
        }
        try {
            result.isDebugEnabled();
        }
        catch (Throwable e) {
            result.supportsDebug = false;
        }
        try {
            result.isTraceEnabled();
        }
        catch (Throwable e) {
            result.supportsTrace = false;
        }
        return result;
    }

    public boolean isTraceEnabled() {
        if (!globalThreshold.supports(Level.TRACE)) {
            return false;
        }
        if (!this.supportsTrace) {
            return false;
        }
        if (this.slf4j != null) {
            return this.slf4j.isTraceEnabled();
        }
        if (this.log4j != null) {
            return this.log4j.isTraceEnabled();
        }
        return this.util.isLoggable(java.util.logging.Level.FINER);
    }

    public void trace(Object message) {
        this.trace(message, (Object)null);
    }

    public void trace(Object message, Object details) {
        if (!globalThreshold.supports(Level.TRACE)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.trace(this.getMessage(message, details));
        } else if (this.log4j != null) {
            this.log4j.trace((Object)this.getMessage(message, details));
        } else {
            this.util.finer("" + this.getMessage(message, details));
        }
    }

    public void trace(Object message, Throwable throwable) {
        this.trace(message, null, throwable);
    }

    public void trace(Object message, Object details, Throwable throwable) {
        if (!globalThreshold.supports(Level.TRACE)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.trace(this.getMessage(message, details), throwable);
        } else if (this.log4j != null) {
            this.log4j.trace((Object)this.getMessage(message, details), throwable);
        } else {
            this.util.log(java.util.logging.Level.FINER, "" + this.getMessage(message, details), throwable);
        }
    }

    public boolean isDebugEnabled() {
        if (!globalThreshold.supports(Level.DEBUG)) {
            return false;
        }
        if (!this.supportsDebug) {
            return false;
        }
        if (this.slf4j != null) {
            return this.slf4j.isDebugEnabled();
        }
        if (this.log4j != null) {
            return this.log4j.isDebugEnabled();
        }
        return this.util.isLoggable(java.util.logging.Level.FINE);
    }

    public void debug(Object message) {
        this.debug(message, (Object)null);
    }

    public void debug(Object message, Object details) {
        if (!globalThreshold.supports(Level.DEBUG)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.debug(this.getMessage(message, details));
        } else if (this.log4j != null) {
            this.log4j.debug((Object)this.getMessage(message, details));
        } else {
            this.util.fine("" + this.getMessage(message, details));
        }
    }

    public void debug(Object message, Throwable throwable) {
        this.debug(message, null, throwable);
    }

    public void debug(Object message, Object details, Throwable throwable) {
        if (!globalThreshold.supports(Level.DEBUG)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.debug(this.getMessage(message, details), throwable);
        } else if (this.log4j != null) {
            this.log4j.debug((Object)this.getMessage(message, details), throwable);
        } else {
            this.util.log(java.util.logging.Level.FINE, "" + this.getMessage(message, details), throwable);
        }
    }

    public boolean isInfoEnabled() {
        if (!globalThreshold.supports(Level.INFO)) {
            return false;
        }
        if (!this.supportsInfo) {
            return false;
        }
        if (this.slf4j != null) {
            return this.slf4j.isInfoEnabled();
        }
        if (this.log4j != null) {
            return this.log4j.isInfoEnabled();
        }
        return this.util.isLoggable(java.util.logging.Level.INFO);
    }

    public void info(Object message) {
        this.info(message, (Object)null);
    }

    public void info(Object message, Object details) {
        if (!globalThreshold.supports(Level.INFO)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.info(this.getMessage(message, details));
        } else if (this.log4j != null) {
            this.log4j.info((Object)this.getMessage(message, details));
        } else {
            this.util.info("" + this.getMessage(message, details));
        }
    }

    public void info(Object message, Throwable throwable) {
        this.info(message, null, throwable);
    }

    public void info(Object message, Object details, Throwable throwable) {
        if (!globalThreshold.supports(Level.INFO)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.info(this.getMessage(message, details), throwable);
        } else if (this.log4j != null) {
            this.log4j.info((Object)this.getMessage(message, details), throwable);
        } else {
            this.util.log(java.util.logging.Level.INFO, "" + this.getMessage(message, details), throwable);
        }
    }

    public void warn(Object message) {
        this.warn(message, (Object)null);
    }

    public void warn(Object message, Object details) {
        if (!globalThreshold.supports(Level.WARN)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.warn(this.getMessage(message, details));
        } else if (this.log4j != null) {
            this.log4j.warn((Object)this.getMessage(message, details));
        } else {
            this.util.warning("" + this.getMessage(message, details));
        }
    }

    public void warn(Object message, Throwable throwable) {
        this.warn(message, null, throwable);
    }

    public void warn(Object message, Object details, Throwable throwable) {
        if (!globalThreshold.supports(Level.WARN)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.warn(this.getMessage(message, details), throwable);
        } else if (this.log4j != null) {
            this.log4j.warn((Object)this.getMessage(message, details), throwable);
        } else {
            this.util.log(java.util.logging.Level.WARNING, "" + this.getMessage(message, details), throwable);
        }
    }

    public void error(Object message) {
        this.error(message, (Object)null);
    }

    public void error(Object message, Object details) {
        if (!globalThreshold.supports(Level.ERROR)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.error(this.getMessage(message, details));
        } else if (this.log4j != null) {
            this.log4j.error((Object)this.getMessage(message, details));
        } else {
            this.util.severe("" + this.getMessage(message, details));
        }
    }

    public void error(Object message, Throwable throwable) {
        this.error(message, null, throwable);
    }

    public void error(Object message, Object details, Throwable throwable) {
        if (!globalThreshold.supports(Level.ERROR)) {
            return;
        }
        if (this.slf4j != null) {
            this.slf4j.error(this.getMessage(message, details), throwable);
        } else if (this.log4j != null) {
            this.log4j.error((Object)this.getMessage(message, details), throwable);
        } else {
            this.util.log(java.util.logging.Level.SEVERE, "" + this.getMessage(message, details), throwable);
        }
    }

    private String getMessage(Object message, Object details) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.rightPad("" + message, 25));
        if (details != null) {
            sb.append(": ");
            sb.append(details);
        }
        return sb.toString();
    }

    public static void globalThreshold(Level level) {
        globalThreshold = level;
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;


        public boolean supports(Level level) {
            return this.ordinal() <= level.ordinal();
        }
    }
}

