/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.ReferenceImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.TableImpl;

final class MetaImpl
implements Meta,
Serializable {
    private static final long serialVersionUID = 3582980783173033809L;
    private final DSLContext create;
    private final Configuration configuration;
    private final boolean inverseSchemaCatalog;

    MetaImpl(Configuration configuration) {
        this.create = DSL.using(configuration);
        this.configuration = configuration;
        this.inverseSchemaCatalog = Arrays.asList(SQLDialect.MYSQL, SQLDialect.MARIADB).contains((Object)configuration.family());
    }

    private final Result<Record> meta(MetaFunction consumer) {
        ConnectionProvider provider = this.configuration.connectionProvider();
        Connection connection = null;
        try {
            connection = provider.acquire();
            Result<Record> result = consumer.run(connection.getMetaData());
            return result;
        }
        catch (SQLException e) {
            throw new DataAccessException("Error while accessing DatabaseMetaData", e);
        }
        finally {
            if (connection != null) {
                provider.release(connection);
            }
        }
    }

    @Override
    public final List<Catalog> getCatalogs() {
        ArrayList<Catalog> result = new ArrayList<Catalog>();
        if (!this.inverseSchemaCatalog) {
            Result<Record> catalogs = this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    return MetaImpl.this.create.fetch(meta.getCatalogs(), SQLDataType.VARCHAR);
                }
            });
            for (String name : catalogs.getValues(0, String.class)) {
                result.add(new MetaCatalog(name));
            }
        }
        if (result.isEmpty()) {
            result.add(new MetaCatalog(""));
        }
        return result;
    }

    @Override
    public final List<Schema> getSchemas() {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Catalog catalog : this.getCatalogs()) {
            result.addAll(catalog.getSchemas());
        }
        return result;
    }

    @Override
    public final List<Table<?>> getTables() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.getSchemas()) {
            result.addAll(schema.getTables());
        }
        return result;
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.getTables()) {
            UniqueKey<?> pk = table.getPrimaryKey();
            if (pk == null) continue;
            result.add(pk);
        }
        return result;
    }

    private class MetaPrimaryKey
    implements UniqueKey<Record> {
        private static final long serialVersionUID = 6997258619475953490L;
        private final String pkName;
        private final Table<Record> pkTable;
        private final TableField<Record, ?>[] pkFields;

        MetaPrimaryKey(Table<Record> table, String pkName, TableField<Record, ?>[] fields) {
            this.pkName = pkName;
            this.pkTable = table;
            this.pkFields = fields;
        }

        @Override
        public final String getName() {
            return this.pkName;
        }

        @Override
        public final Table<Record> getTable() {
            return this.pkTable;
        }

        @Override
        public final List<TableField<Record, ?>> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.pkFields));
        }

        @Override
        public final TableField<Record, ?>[] getFieldsArray() {
            return (TableField[])this.pkFields.clone();
        }

        @Override
        public final boolean isPrimary() {
            return true;
        }

        @Override
        public final List<ForeignKey<?, Record>> getReferences() {
            ArrayList references = new ArrayList();
            Result result = MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    ResultSet rs = meta.getExportedKeys(null, MetaPrimaryKey.this.pkTable.getSchema().getName(), MetaPrimaryKey.this.pkTable.getName());
                    return MetaImpl.this.create.fetch(rs, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Short.class, Short.class, Short.class, String.class, String.class);
                }
            });
            Map groups = result.intoGroups(new Field[]{result.field(MetaImpl.this.inverseSchemaCatalog ? 5 : 4), result.field(MetaImpl.this.inverseSchemaCatalog ? 4 : 5), result.field(6), result.field(11), result.field(12)});
            HashMap<String, Schema> schemas = new HashMap<String, Schema>();
            for (Schema schema : MetaImpl.this.getSchemas()) {
                schemas.put(schema.getName(), schema);
            }
            for (Map.Entry entry : groups.entrySet()) {
                Schema schema = (Schema)schemas.get(((Record)entry.getKey()).get(1));
                Table<?> fkTable = schema.getTable(((Record)entry.getKey()).get(2, String.class));
                TableField[] fkFields = new TableField[((Result)entry.getValue()).size()];
                for (int i = 0; i < ((Result)entry.getValue()).size(); ++i) {
                    Record record = (Record)((Result)entry.getValue()).get(i);
                    fkFields[i] = (TableField)fkTable.field(record.get(7, String.class));
                }
                references.add(new ReferenceImpl(this, fkTable, fkFields));
            }
            return references;
        }

        @Override
        public final Constraint constraint() {
            if (this.isPrimary()) {
                return DSL.constraint(this.getName()).primaryKey(this.getFieldsArray());
            }
            return DSL.constraint(this.getName()).unique(this.getFieldsArray());
        }
    }

    private class MetaTable
    extends TableImpl<Record> {
        private static final long serialVersionUID = 4843841667753000233L;

        MetaTable(String name, Schema schema, Result<Record> columns) {
            super(name, schema);
            if (columns != null) {
                this.init(columns);
            }
        }

        @Override
        public final List<UniqueKey<Record>> getKeys() {
            UniqueKey<Record> pk = this.getPrimaryKey();
            return pk == null ? Collections.emptyList() : Collections.singletonList(pk);
        }

        @Override
        public final UniqueKey<Record> getPrimaryKey() {
            SQLDialect family = MetaImpl.this.configuration.family();
            final String schema = this.getSchema() == null ? null : this.getSchema().getName();
            Result result = MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    ResultSet rs = !MetaImpl.this.inverseSchemaCatalog ? meta.getPrimaryKeys(null, schema, MetaTable.this.getName()) : meta.getPrimaryKeys(schema, null, MetaTable.this.getName());
                    return MetaImpl.this.create.fetch(rs, String.class, String.class, String.class, String.class, Integer.TYPE, String.class);
                }
            });
            result.sortAsc(4);
            return this.createPrimaryKey(result, 3);
        }

        @Override
        public List<ForeignKey<Record, ?>> getReferences() {
            ArrayList references = new ArrayList();
            Result result = MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    ResultSet rs = meta.getImportedKeys(null, MetaTable.this.getSchema().getName(), MetaTable.this.getName());
                    return MetaImpl.this.create.fetch(rs, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Short.class, Short.class, Short.class, String.class, String.class);
                }
            });
            Map groups = result.intoGroups(new Field[]{result.field(MetaImpl.this.inverseSchemaCatalog ? 1 : 0), result.field(MetaImpl.this.inverseSchemaCatalog ? 0 : 1), result.field(2), result.field(11), result.field(12)});
            HashMap<String, Schema> schemas = new HashMap<String, Schema>();
            for (Schema schema : MetaImpl.this.getSchemas()) {
                schemas.put(schema.getName(), schema);
            }
            for (Map.Entry entry : groups.entrySet()) {
                Schema schema = (Schema)schemas.get(((Record)entry.getKey()).get(1));
                String pkName = ((Record)entry.getKey()).get(4, String.class);
                Table<Record> pkTable = schema.getTable(((Record)entry.getKey()).get(2, String.class));
                TableField[] pkFields = new TableField[((Result)entry.getValue()).size()];
                TableField[] fkFields = new TableField[((Result)entry.getValue()).size()];
                for (int i = 0; i < ((Result)entry.getValue()).size(); ++i) {
                    Record record = (Record)((Result)entry.getValue()).get(i);
                    pkFields[i] = (TableField)pkTable.field(record.get(3, String.class));
                    fkFields[i] = (TableField)this.field(record.get(7, String.class));
                }
                references.add(new ReferenceImpl<Record, Record>(new MetaPrimaryKey(pkTable, pkName, pkFields), this, fkFields));
            }
            return references;
        }

        private final UniqueKey<Record> createPrimaryKey(Result<Record> result, int columnName) {
            if (result.size() > 0) {
                TableField[] f = new TableField[result.size()];
                for (int i = 0; i < f.length; ++i) {
                    String name = ((Record)result.get(i)).get(columnName, String.class);
                    f[i] = (TableField)this.field(name);
                    if (f[i] != null || MetaImpl.this.configuration.family() != SQLDialect.SQLITE) continue;
                    for (Field<?> field : this.fields()) {
                        if (!field.getName().equalsIgnoreCase(name)) continue;
                        f[i] = (TableField)field;
                    }
                }
                String indexName = ((Record)result.get(0)).get(5, String.class);
                return new MetaPrimaryKey(this, indexName, f);
            }
            return null;
        }

        private final void init(Result<Record> columns) {
            for (Record column : columns) {
                String columnName = column.getValue(3, String.class);
                String typeName = column.getValue(5, String.class);
                int precision = column.getValue(6, Integer.TYPE);
                int scale = column.getValue(8, Integer.TYPE);
                int nullable = column.getValue(10, Integer.TYPE);
                DataType<Object> type = null;
                try {
                    type = DefaultDataType.getDataType(MetaImpl.this.configuration.family(), typeName, precision, scale);
                    type = type.precision(precision, scale);
                    type = type.length(precision);
                    if (nullable == 0) {
                        type = type.nullable(false);
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    type = SQLDataType.OTHER;
                }
                MetaTable.createField(columnName, type, this);
            }
        }
    }

    private class MetaSchema
    extends SchemaImpl {
        private static final long serialVersionUID = -2621899850912554198L;
        private volatile transient Map<Name, Result<Record>> columnCache;

        MetaSchema(String name, Catalog catalog) {
            super(name, catalog);
        }

        @Override
        public final synchronized List<Table<?>> getTables() {
            Result tables = MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    String[] types = null;
                    switch (MetaImpl.this.configuration.family()) {
                        case POSTGRES: {
                            types = new String[]{"TABLE", "VIEW", "SYSTEM_TABLE", "SYSTEM_VIEW", "MATERIALIZED VIEW"};
                            break;
                        }
                        case SQLITE: {
                            types = new String[]{"TABLE", "VIEW"};
                        }
                    }
                    ResultSet rs = !MetaImpl.this.inverseSchemaCatalog ? meta.getTables(null, MetaSchema.this.getName(), "%", types) : meta.getTables(MetaSchema.this.getName(), null, "%", types);
                    return MetaImpl.this.create.fetch(rs, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR);
                }
            });
            ArrayList result = new ArrayList();
            for (Record table : tables) {
                String catalog = table.get(0, String.class);
                String schema = table.get(1, String.class);
                String name = table.get(2, String.class);
                result.add(new MetaTable(name, this, this.getColumns(MetaImpl.this.inverseSchemaCatalog ? catalog : schema, name)));
            }
            return result;
        }

        private final Result<Record> getColumns(String schema, String table) {
            if (this.columnCache == null && MetaImpl.this.configuration.dialect() != SQLDialect.SQLITE) {
                Result<Record> columns = this.getColumns0(schema, "%");
                Field<?> tableCat = columns.field(0);
                Field<?> tableSchem = columns.field(1);
                Field<?> tableName = columns.field(2);
                Map<Record, Result<Record>> groups = columns.intoGroups(new Field[]{MetaImpl.this.inverseSchemaCatalog ? tableCat : tableSchem, tableName});
                this.columnCache = new LinkedHashMap<Name, Result<Record>>();
                for (Map.Entry<Record, Result<Record>> entry : groups.entrySet()) {
                    Record key = entry.getKey();
                    Result<Record> value = entry.getValue();
                    this.columnCache.put(DSL.name((String)key.get(MetaImpl.this.inverseSchemaCatalog ? tableCat : tableSchem), (String)key.get(tableName)), value);
                }
            }
            if (this.columnCache != null) {
                return this.columnCache.get(DSL.name(schema, table));
            }
            return this.getColumns0(schema, table);
        }

        private final Result<Record> getColumns0(final String schema, final String table) {
            return MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    ResultSet rs = !MetaImpl.this.inverseSchemaCatalog ? meta.getColumns(null, schema, table, "%") : meta.getColumns(schema, null, table, "%");
                    return MetaImpl.this.create.fetch(rs, String.class, String.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
            });
        }
    }

    private class MetaCatalog
    extends CatalogImpl {
        private static final long serialVersionUID = -2821093577201327275L;

        MetaCatalog(String name) {
            super(name);
        }

        @Override
        public final List<Schema> getSchemas() {
            ArrayList<Schema> result = new ArrayList<Schema>();
            if (!MetaImpl.this.inverseSchemaCatalog) {
                Result schemas = MetaImpl.this.meta(new MetaFunction(){

                    @Override
                    public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                        return MetaImpl.this.create.fetch(meta.getSchemas(), SQLDataType.VARCHAR);
                    }
                });
                for (String name : schemas.getValues(0, String.class)) {
                    result.add(new MetaSchema(name, this));
                }
            } else {
                Result schemas = MetaImpl.this.meta(new MetaFunction(){

                    @Override
                    public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                        return MetaImpl.this.create.fetch(meta.getCatalogs(), SQLDataType.VARCHAR);
                    }
                });
                for (String name : schemas.getValues(0, String.class)) {
                    result.add(new MetaSchema(name, this));
                }
            }
            if (result.isEmpty()) {
                result.add(new MetaSchema("", this));
            }
            return result;
        }
    }

    private static interface MetaFunction {
        public Result<Record> run(DatabaseMetaData var1) throws SQLException;
    }
}

