/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.SQLWarning;
import java.util.Collection;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;

final class Fields<R extends Record>
extends AbstractQueryPart
implements RecordType<R> {
    private static final long serialVersionUID = -6911012275707591576L;
    private static final JooqLogger log = JooqLogger.getLogger(Fields.class);
    Field<?>[] fields;

    Fields(Field<?> ... fields) {
        this.fields = fields;
    }

    Fields(Collection<? extends Field<?>> fields) {
        this.fields = fields.toArray(new Field[0]);
    }

    @Override
    public final int size() {
        return this.fields.length;
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        if (field == null) {
            return null;
        }
        for (Field<?> f : this.fields) {
            if (f != field) continue;
            return f;
        }
        for (Field<?> f : this.fields) {
            if (!f.equals(field)) continue;
            return f;
        }
        Field<?> columnMatch = null;
        String tableName = this.tableName(field);
        String fieldName = field.getName();
        for (Field<?> f : this.fields) {
            String tName;
            if (tableName != null && (tName = this.tableName(f)) != null && tableName.equals(tName) && f.getName().equals(fieldName)) {
                return f;
            }
            if (!f.getName().equals(fieldName)) continue;
            if (columnMatch == null) {
                columnMatch = f;
                continue;
            }
            log.info((Object)("Ambiguous match found for " + fieldName + ". Both " + columnMatch + " and " + f + " match."), new SQLWarning());
        }
        return columnMatch;
    }

    private final String tableName(Field<?> field) {
        Table table;
        if (field instanceof TableField && (table = ((TableField)field).getTable()) != null) {
            return table.getName();
        }
        return null;
    }

    @Override
    public final Field<?> field(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        Field<?> columnMatch = null;
        for (Field<?> f : this.fields) {
            if (!f.getName().equals(fieldName)) continue;
            if (columnMatch == null) {
                columnMatch = f;
                continue;
            }
            log.info((Object)("Ambiguous match found for " + fieldName + ". Both " + columnMatch + " and " + f + " match."), new SQLWarning());
        }
        return columnMatch;
    }

    @Override
    public final <T> Field<T> field(String fieldName, Class<T> type) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(type);
    }

    @Override
    public final <T> Field<T> field(String fieldName, DataType<T> dataType) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(dataType);
    }

    @Override
    public final Field<?> field(Name name) {
        if (name == null) {
            return null;
        }
        return this.field(DSL.field(name));
    }

    @Override
    public final <T> Field<T> field(Name fieldName, Class<T> type) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(type);
    }

    @Override
    public final <T> Field<T> field(Name fieldName, DataType<T> dataType) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(dataType);
    }

    @Override
    public final Field<?> field(int index) {
        if (index >= 0 && index < this.fields.length) {
            return this.fields[index];
        }
        return null;
    }

    @Override
    public final <T> Field<T> field(int fieldIndex, Class<T> type) {
        Field<?> result = this.field(fieldIndex);
        return result == null ? null : result.coerce(type);
    }

    @Override
    public final <T> Field<T> field(int fieldIndex, DataType<T> dataType) {
        Field<?> result = this.field(fieldIndex);
        return result == null ? null : result.coerce(dataType);
    }

    @Override
    public final Field<?>[] fields() {
        return this.fields;
    }

    @Override
    public final Field<?>[] fields(Field<?> ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final Field<?>[] fields(String ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final Field<?>[] fields(Name ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final Field<?>[] fields(int ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final int indexOf(Field<?> field) {
        Field<?> compareWith = this.field(field);
        if (compareWith != null) {
            int i;
            int size = this.fields.length;
            for (i = 0; i < size; ++i) {
                if (this.fields[i] != compareWith) continue;
                return i;
            }
            for (i = 0; i < size; ++i) {
                if (!this.fields[i].equals(compareWith)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final int indexOf(String fieldName) {
        return this.indexOf(this.field(fieldName));
    }

    @Override
    public final int indexOf(Name fieldName) {
        return this.indexOf(this.field(fieldName));
    }

    @Override
    public final Class<?>[] types() {
        int size = this.fields.length;
        Class[] result = new Class[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.field(i).getType();
        }
        return result;
    }

    @Override
    public final Class<?> type(int fieldIndex) {
        return fieldIndex >= 0 && fieldIndex < this.size() ? this.field(fieldIndex).getType() : null;
    }

    @Override
    public final Class<?> type(String fieldName) {
        return this.type(Tools.indexOrFail(this, fieldName));
    }

    @Override
    public final Class<?> type(Name fieldName) {
        return this.type(Tools.indexOrFail(this, fieldName));
    }

    @Override
    public final DataType<?>[] dataTypes() {
        int size = this.fields.length;
        DataType[] result = new DataType[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.field(i).getDataType();
        }
        return result;
    }

    @Override
    public final DataType<?> dataType(int fieldIndex) {
        return fieldIndex >= 0 && fieldIndex < this.size() ? this.field(fieldIndex).getDataType() : null;
    }

    @Override
    public final DataType<?> dataType(String fieldName) {
        return this.dataType(Tools.indexOrFail(this, fieldName));
    }

    @Override
    public final DataType<?> dataType(Name fieldName) {
        return this.dataType(Tools.indexOrFail(this, fieldName));
    }

    final int[] indexesOf(Field<?> ... f) {
        int[] result = new int[f.length];
        for (int i = 0; i < f.length; ++i) {
            result[i] = Tools.indexOrFail(this, f[i]);
        }
        return result;
    }

    final int[] indexesOf(String ... fieldNames) {
        int[] result = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = Tools.indexOrFail(this, fieldNames[i]);
        }
        return result;
    }

    final int[] indexesOf(Name ... fieldNames) {
        int[] result = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = Tools.indexOrFail(this, fieldNames[i]);
        }
        return result;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(new QueryPartList((QueryPart[])this.fields));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    final void add(Field<?> f) {
        Field[] result = new Field[this.fields.length + 1];
        System.arraycopy(this.fields, 0, result, 0, this.fields.length);
        result[this.fields.length] = f;
        this.fields = result;
    }
}

