/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jooq.Binding;
import org.jooq.Configuration;
import org.jooq.Converter;
import org.jooq.Converters;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.UDTRecord;
import org.jooq.exception.MappingException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.ArrayDataType;
import org.jooq.impl.ConvertedDataType;
import org.jooq.impl.DefaultBinding;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.Convert;
import org.jooq.tools.reflect.Reflect;
import org.jooq.types.Interval;
import org.jooq.types.UByte;
import org.jooq.types.UInteger;
import org.jooq.types.ULong;
import org.jooq.types.UShort;

public class DefaultDataType<T>
implements DataType<T> {
    private static final long serialVersionUID = 4155588654449505119L;
    private static final Pattern NORMALISE_PATTERN = Pattern.compile("\"|\\.|\\s|\\(\\w+(\\s*,\\s*\\w+)*\\)|(NOT\\s*NULL)?");
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("\\([^\\)]*\\)");
    private static final Map<String, DataType<?>>[] TYPES_BY_NAME;
    private static final Map<Class<?>, DataType<?>>[] TYPES_BY_TYPE;
    private static final Map<DataType<?>, DataType<?>>[] TYPES_BY_SQL_DATATYPE;
    private static final Map<Class<?>, DataType<?>> SQL_DATATYPES_BY_TYPE;
    private static final int LONG_PRECISION;
    private static final int INTEGER_PRECISION;
    private static final int SHORT_PRECISION;
    private static final int BYTE_PRECISION;
    private final SQLDialect dialect;
    private final DataType<T> sqlDataType;
    private final Class<T> type;
    private final Binding<?, T> binding;
    private final Class<T[]> arrayType;
    private final String castTypeName;
    private final String castTypeBase;
    private final String typeName;
    private final boolean nullable;
    private final Field<T> defaultValue;
    private final int precision;
    private final int scale;
    private final int length;

    public DefaultDataType(SQLDialect dialect, DataType<T> sqlDataType, String typeName) {
        this(dialect, sqlDataType, sqlDataType.getType(), typeName, typeName, sqlDataType.precision(), sqlDataType.scale(), sqlDataType.length(), sqlDataType.nullable(), sqlDataType.defaultValue());
    }

    public DefaultDataType(SQLDialect dialect, DataType<T> sqlDataType, String typeName, String castTypeName) {
        this(dialect, sqlDataType, sqlDataType.getType(), typeName, castTypeName, sqlDataType.precision(), sqlDataType.scale(), sqlDataType.length(), sqlDataType.nullable(), sqlDataType.defaultValue());
    }

    public DefaultDataType(SQLDialect dialect, Class<T> type, String typeName) {
        this(dialect, null, type, typeName, typeName, 0, 0, 0, true, null);
    }

    public DefaultDataType(SQLDialect dialect, Class<T> type, String typeName, String castTypeName) {
        this(dialect, null, type, typeName, castTypeName, 0, 0, 0, true, null);
    }

    DefaultDataType(SQLDialect dialect, Class<T> type, String typeName, String castTypeName, int precision, int scale, int length, boolean nullable, Field<T> defaultValue) {
        this(dialect, null, type, typeName, castTypeName, precision, scale, length, nullable, defaultValue);
    }

    DefaultDataType(SQLDialect dialect, Class<T> type, Binding<?, T> binding, String typeName, String castTypeName, int precision, int scale, int length, boolean nullable, Field<T> defaultValue) {
        this(dialect, null, type, binding, typeName, castTypeName, precision, scale, length, nullable, defaultValue);
    }

    DefaultDataType(SQLDialect dialect, DataType<T> sqlDataType, Class<T> type, String typeName, String castTypeName, int precision, int scale, int length, boolean nullable, Field<T> defaultValue) {
        this(dialect, sqlDataType, type, null, typeName, castTypeName, precision, scale, length, nullable, defaultValue);
    }

    DefaultDataType(SQLDialect dialect, DataType<T> sqlDataType, Class<T> type, Binding<?, T> binding, String typeName, String castTypeName, int precision, int scale, int length, boolean nullable, Field<T> defaultValue) {
        String normalised;
        int ordinal;
        this.dialect = dialect;
        this.sqlDataType = dialect == null ? this : sqlDataType;
        this.type = type;
        this.typeName = typeName;
        this.castTypeName = castTypeName;
        this.castTypeBase = TYPE_NAME_PATTERN.matcher(castTypeName).replaceAll("").trim();
        this.arrayType = Array.newInstance(type, 0).getClass();
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.precision = DefaultDataType.precision0(type, precision);
        this.scale = scale;
        this.length = length;
        int n = ordinal = dialect == null ? SQLDialect.DEFAULT.ordinal() : dialect.family().ordinal();
        if (!TYPES_BY_NAME[ordinal].containsKey(typeName.toUpperCase()) && TYPES_BY_NAME[ordinal].get(normalised = DefaultDataType.normalise(typeName)) == null) {
            TYPES_BY_NAME[ordinal].put(normalised, this);
        }
        if (TYPES_BY_TYPE[ordinal].get(type) == null) {
            TYPES_BY_TYPE[ordinal].put(type, this);
        }
        if (TYPES_BY_SQL_DATATYPE[ordinal].get(sqlDataType) == null) {
            TYPES_BY_SQL_DATATYPE[ordinal].put(sqlDataType, this);
        }
        if (dialect == null && SQL_DATATYPES_BY_TYPE.get(type) == null) {
            SQL_DATATYPES_BY_TYPE.put(type, this);
        }
        this.binding = binding != null ? binding : new DefaultBinding<T, T>(Converters.identity(type), this.isLob());
    }

    private DefaultDataType(DefaultDataType<T> t, int precision, int scale, int length, boolean nullable, Field<T> defaultValue) {
        this.dialect = t.dialect;
        this.sqlDataType = t.sqlDataType;
        this.type = t.type;
        this.typeName = t.typeName;
        this.castTypeName = t.castTypeName;
        this.castTypeBase = t.castTypeBase;
        this.arrayType = t.arrayType;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.precision = DefaultDataType.precision0(this.type, precision);
        this.scale = scale;
        this.length = length;
        this.binding = t.binding;
    }

    private static final int precision0(Class<?> type, int precision) {
        if (precision == 0) {
            if (type == Long.class || type == ULong.class) {
                precision = LONG_PRECISION;
            } else if (type == Integer.class || type == UInteger.class) {
                precision = INTEGER_PRECISION;
            } else if (type == Short.class || type == UShort.class) {
                precision = SHORT_PRECISION;
            } else if (type == Byte.class || type == UByte.class) {
                precision = BYTE_PRECISION;
            }
        }
        return precision;
    }

    @Override
    public final DataType<T> nullable(boolean n) {
        return new DefaultDataType<T>(this, this.precision, this.scale, this.length, n, this.defaultValue);
    }

    @Override
    public final boolean nullable() {
        return this.nullable;
    }

    @Override
    public final DataType<T> defaultValue(T d) {
        return this.defaultValue(Tools.field(d, this));
    }

    @Override
    public final DataType<T> defaultValue(Field<T> d) {
        return new DefaultDataType<T>(this, this.precision, this.scale, this.length, this.nullable, d);
    }

    @Override
    public final Field<T> defaultValue() {
        return this.defaultValue;
    }

    @Override
    @Deprecated
    public final DataType<T> defaulted(boolean d) {
        return this.defaultValue(d ? Tools.field(null, this) : null);
    }

    @Override
    public final boolean defaulted() {
        return this.defaultValue != null;
    }

    @Override
    public final DataType<T> precision(int p) {
        return this.precision(p, this.scale);
    }

    @Override
    public final DataType<T> precision(int p, int s) {
        if (this.precision == p && this.scale == s) {
            return this;
        }
        if (this.isLob()) {
            return this;
        }
        return new DefaultDataType<T>(this, p, s, this.length, this.nullable, this.defaultValue);
    }

    @Override
    public final int precision() {
        return this.precision;
    }

    @Override
    public final boolean hasPrecision() {
        return this.type == BigInteger.class || this.type == BigDecimal.class;
    }

    @Override
    public final DataType<T> scale(int s) {
        if (this.scale == s) {
            return this;
        }
        if (this.isLob()) {
            return this;
        }
        return new DefaultDataType<T>(this, this.precision, s, this.length, this.nullable, this.defaultValue);
    }

    @Override
    public final int scale() {
        return this.scale;
    }

    @Override
    public final boolean hasScale() {
        return this.type == BigDecimal.class;
    }

    @Override
    public final DataType<T> length(int l) {
        if (this.length == l) {
            return this;
        }
        if (this.isLob()) {
            return this;
        }
        return new DefaultDataType<T>(this, this.precision, this.scale, l, this.nullable, this.defaultValue);
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final boolean hasLength() {
        return (this.type == byte[].class || this.type == String.class) && !this.isLob();
    }

    @Override
    public final DataType<T> getSQLDataType() {
        return this.sqlDataType;
    }

    @Override
    public final DataType<T> getDataType(Configuration configuration) {
        if (this.getDialect() == null) {
            DataType<?> dataType = TYPES_BY_SQL_DATATYPE[configuration.dialect().family().ordinal()].get(this.length(0).precision(0, 0));
            if (dataType != null) {
                return dataType.length(this.length).precision(this.precision, this.scale);
            }
        } else {
            if (this.getDialect().family() == configuration.dialect().family()) {
                return this;
            }
            if (this.getSQLDataType() == null) {
                return this;
            }
            this.getSQLDataType().getDataType(configuration);
        }
        return this;
    }

    @Override
    public int getSQLType() {
        if (this.type == Blob.class) {
            return 2004;
        }
        if (this.type == Boolean.class) {
            return 16;
        }
        if (this.type == BigInteger.class) {
            return -5;
        }
        if (this.type == BigDecimal.class) {
            return 3;
        }
        if (this.type == Byte.class) {
            return -6;
        }
        if (this.type == byte[].class) {
            return 2004;
        }
        if (this.type == Clob.class) {
            return 2005;
        }
        if (this.type == Date.class) {
            return 91;
        }
        if (this.type == Double.class) {
            return 8;
        }
        if (this.type == Float.class) {
            return 6;
        }
        if (this.type == Integer.class) {
            return 4;
        }
        if (this.type == Long.class) {
            return -5;
        }
        if (this.type == Short.class) {
            return 5;
        }
        if (this.type == String.class) {
            return 12;
        }
        if (this.type == Time.class) {
            return 92;
        }
        if (this.type == Timestamp.class) {
            return 93;
        }
        if (this.type.isArray()) {
            return 2003;
        }
        if (EnumType.class.isAssignableFrom(this.type)) {
            return 12;
        }
        if (UDTRecord.class.isAssignableFrom(this.type)) {
            return 2002;
        }
        if (Result.class.isAssignableFrom(this.type)) {
            switch (this.dialect.family()) {
                case H2: {
                    return -10;
                }
            }
            return 1111;
        }
        return 1111;
    }

    @Override
    public final Class<T> getType() {
        return this.type;
    }

    @Override
    public final Binding<?, T> getBinding() {
        return this.binding;
    }

    @Override
    public final Converter<?, T> getConverter() {
        return this.binding.converter();
    }

    @Override
    public final Class<T[]> getArrayType() {
        return this.arrayType;
    }

    @Override
    public final String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getTypeName(Configuration configuration) {
        return this.getDataType(configuration).getTypeName();
    }

    @Override
    public final String getCastTypeName() {
        if (this.length != 0 && this.hasLength()) {
            return this.castTypeBase + "(" + this.length + ")";
        }
        if (this.precision != 0 && this.hasPrecision()) {
            if (this.scale != 0 && this.hasScale()) {
                return this.castTypeBase + "(" + this.precision + ", " + this.scale + ")";
            }
            return this.castTypeBase + "(" + this.precision + ")";
        }
        return this.castTypeName;
    }

    @Override
    public String getCastTypeName(Configuration configuration) {
        return this.getDataType(configuration).getCastTypeName();
    }

    @Override
    public final DataType<T[]> getArrayDataType() {
        return new ArrayDataType(this);
    }

    @Override
    public final <E extends EnumType> DataType<E> asEnumDataType(Class<E> enumDataType) {
        String enumTypeName = Tools.enums(enumDataType)[0].getName();
        return new DefaultDataType<E>(this.dialect, enumDataType, enumTypeName, enumTypeName);
    }

    @Override
    public final <U> DataType<U> asConvertedDataType(Converter<? super T, U> converter) {
        return this.asConvertedDataType(DefaultBinding.newBinding(converter, this, null));
    }

    @Override
    public final <U> DataType<U> asConvertedDataType(Binding<? super T, U> newBinding) {
        if (this.binding == newBinding) {
            return this;
        }
        if (newBinding == null) {
            newBinding = new DefaultBinding<T, T>(Converters.identity(this.getType()), this.isLob());
        }
        return new ConvertedDataType<T, U>(this, newBinding);
    }

    @Override
    public final SQLDialect getDialect() {
        return this.dialect;
    }

    @Override
    public T convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass() == this.type) {
            return (T)object;
        }
        return Convert.convert(object, this.type);
    }

    @Override
    public final T[] convert(Object ... objects) {
        return Convert.convertArray(objects, this.type);
    }

    @Override
    public final List<T> convert(Collection<?> objects) {
        return Convert.convert(objects, this.type);
    }

    public static DataType<Object> getDefaultDataType(String typeName) {
        return new DefaultDataType<Object>(SQLDialect.DEFAULT, Object.class, typeName, typeName);
    }

    public static DataType<Object> getDefaultDataType(SQLDialect dialect, String typeName) {
        return new DefaultDataType<Object>(dialect, Object.class, typeName, typeName);
    }

    public static DataType<?> getDataType(SQLDialect dialect, String typeName) {
        int ordinal = dialect.ordinal();
        DataType<Object> result = TYPES_BY_NAME[ordinal].get(typeName.toUpperCase());
        if (result == null) {
            typeName = DefaultDataType.normalise(typeName);
            result = TYPES_BY_NAME[ordinal].get(typeName);
        }
        if (result == null) {
            result = TYPES_BY_NAME[SQLDialect.DEFAULT.ordinal()].get(typeName);
        }
        if (result == null && dialect.family() == SQLDialect.POSTGRES && typeName.charAt(0) == '_') {
            result = DefaultDataType.getDataType(dialect, typeName.substring(1)).getArrayDataType();
        }
        if (result == null) {
            throw new SQLDialectNotSupportedException("Type " + typeName + " is not supported in dialect " + (Object)((Object)dialect), false);
        }
        return result;
    }

    public static <T> DataType<T> getDataType(SQLDialect dialect, Class<T> type) {
        return DefaultDataType.getDataType(dialect, type, null);
    }

    public static <T> DataType<T> getDataType(SQLDialect dialect, Class<T> type, DataType<T> fallbackDataType) {
        if (byte[].class != (type = Reflect.wrapper(type)) && type.isArray()) {
            return DefaultDataType.getDataType(dialect, type.getComponentType()).getArrayDataType();
        }
        DataType<?> result = null;
        if (dialect != null) {
            result = TYPES_BY_TYPE[dialect.family().ordinal()].get(type);
        }
        if (result == null) {
            try {
                if (UDTRecord.class.isAssignableFrom(type)) {
                    return ((UDTRecord)type.newInstance()).getUDT().getDataType();
                }
                if (EnumType.class.isAssignableFrom(type)) {
                    return SQLDataType.VARCHAR.asEnumDataType(type);
                }
            }
            catch (Exception e) {
                throw new MappingException("Cannot create instance of " + type, e);
            }
        }
        if (result == null) {
            if (SQL_DATATYPES_BY_TYPE.get(type) != null) {
                return SQL_DATATYPES_BY_TYPE.get(type);
            }
            if (fallbackDataType != null) {
                return fallbackDataType;
            }
            throw new SQLDialectNotSupportedException("Type " + type + " is not supported in dialect " + (Object)((Object)dialect));
        }
        return result;
    }

    @Override
    public final boolean isNumeric() {
        return Number.class.isAssignableFrom(this.type) && !this.isInterval();
    }

    @Override
    public final boolean isString() {
        return this.type == String.class;
    }

    @Override
    public final boolean isDateTime() {
        return java.util.Date.class.isAssignableFrom(this.type) || Temporal.class.isAssignableFrom(this.type);
    }

    @Override
    public final boolean isTemporal() {
        return this.isDateTime() || this.isInterval();
    }

    @Override
    public final boolean isInterval() {
        return Interval.class.isAssignableFrom(this.type);
    }

    @Override
    public final boolean isLob() {
        DataType<T> t = this.getSQLDataType();
        if (t == this) {
            return this.getTypeName().endsWith("lob");
        }
        return t == SQLDataType.BLOB || t == SQLDataType.CLOB || t == SQLDataType.NCLOB;
    }

    @Override
    public final boolean isBinary() {
        return this.type == byte[].class;
    }

    @Override
    public final boolean isArray() {
        return !this.isBinary() && this.type.isArray();
    }

    public String toString() {
        return this.getCastTypeName() + " (" + this.type.getName() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dialect == null ? 0 : this.dialect.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultDataType other = (DefaultDataType)obj;
        if (this.dialect != other.dialect) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.precision != other.precision) {
            return false;
        }
        if (this.scale != other.scale) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
    }

    public static String normalise(String typeName) {
        return NORMALISE_PATTERN.matcher(typeName.toUpperCase()).replaceAll("");
    }

    public static DataType<?> getDataType(SQLDialect dialect, String t, int p, int s) throws SQLDialectNotSupportedException {
        DataType<?> result = DefaultDataType.getDataType(dialect, t);
        if (result.getType() == BigDecimal.class) {
            result = DefaultDataType.getDataType(dialect, DefaultDataType.getNumericClass(p, s));
        }
        return result;
    }

    public static Class<?> getType(SQLDialect dialect, String t, int p, int s) throws SQLDialectNotSupportedException {
        return DefaultDataType.getDataType(dialect, t, p, s).getType();
    }

    private static Class<?> getNumericClass(int precision, int scale) {
        if (scale == 0 && precision != 0) {
            if (precision < BYTE_PRECISION) {
                return Byte.class;
            }
            if (precision < SHORT_PRECISION) {
                return Short.class;
            }
            if (precision < INTEGER_PRECISION) {
                return Integer.class;
            }
            if (precision < LONG_PRECISION) {
                return Long.class;
            }
            return BigInteger.class;
        }
        return BigDecimal.class;
    }

    static Collection<Class<?>> types() {
        return Collections.unmodifiableCollection(SQL_DATATYPES_BY_TYPE.keySet());
    }

    static Collection<DataType<?>> dataTypes() {
        return Collections.unmodifiableCollection(SQL_DATATYPES_BY_TYPE.values());
    }

    static {
        LONG_PRECISION = String.valueOf(Long.MAX_VALUE).length();
        INTEGER_PRECISION = String.valueOf(Integer.MAX_VALUE).length();
        SHORT_PRECISION = String.valueOf(Short.MAX_VALUE).length();
        BYTE_PRECISION = String.valueOf(127).length();
        TYPES_BY_SQL_DATATYPE = new Map[SQLDialect.values().length];
        TYPES_BY_NAME = new Map[SQLDialect.values().length];
        TYPES_BY_TYPE = new Map[SQLDialect.values().length];
        for (SQLDialect dialect : SQLDialect.values()) {
            DefaultDataType.TYPES_BY_SQL_DATATYPE[dialect.ordinal()] = new LinkedHashMap();
            DefaultDataType.TYPES_BY_NAME[dialect.ordinal()] = new LinkedHashMap();
            DefaultDataType.TYPES_BY_TYPE[dialect.ordinal()] = new LinkedHashMap();
        }
        SQL_DATATYPES_BY_TYPE = new LinkedHashMap();
        try {
            Class.forName(SQLDataType.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

