/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Time;
import java.util.Date;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.impl.AbstractFunction;
import org.jooq.impl.DSL;

final class DateOrTime<T extends Date>
extends AbstractFunction<T> {
    private static final long serialVersionUID = -6729613078727690134L;
    private final Field<?> field;

    DateOrTime(Field<?> field, DataType<T> dataType) {
        super(DateOrTime.name(dataType), dataType, field);
        this.field = field;
    }

    private static String name(DataType<?> dataType) {
        return dataType.getType() == java.sql.Date.class ? "date" : (dataType.getType() == Time.class ? "time" : "timestamp");
    }

    @Override
    final QueryPart getFunction0(Configuration configuration) {
        switch (configuration.family()) {
            case MYSQL: 
            case MARIADB: {
                return DSL.field("{" + DateOrTime.name(this.getDataType()) + "}({0})", this.getDataType(), this.field);
            }
            case SQLITE: {
                String name = this.getDataType().getType() == java.sql.Date.class ? "date" : (this.getDataType().getType() == Time.class ? "time" : "datetime");
                return DSL.field("{0}({1})", this.getDataType(), DSL.keyword(name), this.field);
            }
        }
        return this.field.cast(this.getDataType());
    }
}

