/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateViewAsStep;
import org.jooq.CreateViewFinalStep;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Tools;

final class CreateViewImpl<R extends Record>
extends AbstractQuery
implements CreateViewAsStep<R>,
CreateViewFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_VIEW};
    private final boolean ifNotExists;
    private final Table<?> view;
    private final Field<?>[] fields;
    private Select<?> select;

    CreateViewImpl(Configuration configuration, Table<?> view, Field<?>[] fields, boolean ifNotExists) {
        super(configuration);
        this.view = view;
        this.fields = fields;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public final CreateViewFinalStep as(Select<? extends R> s) {
        this.select = s;
        return this;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.executeImmediateBegin(ctx, DDLStatementType.CREATE_VIEW);
            this.accept0(ctx);
            Tools.executeImmediateEnd(ctx, DDLStatementType.CREATE_VIEW);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean rename = this.fields != null && this.fields.length > 0;
        boolean renameSupported = ctx.family() != SQLDialect.SQLITE;
        ParamType paramType = ctx.paramType();
        ctx.start(Clause.CREATE_VIEW_NAME).keyword("create view").sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.keyword("if not exists").sql(' ');
        }
        ctx.visit(this.view);
        if (rename && renameSupported) {
            boolean qualify = ctx.qualify();
            ctx.sql('(').qualify(false).visit(new QueryPartList((QueryPart[])this.fields)).qualify(qualify).sql(')');
        }
        ctx.end(Clause.CREATE_VIEW_NAME).formatSeparator().keyword("as").formatSeparator().start(Clause.CREATE_VIEW_AS).paramType(ParamType.INLINED).visit(rename && !renameSupported ? DSL.selectFrom(DSL.table(this.select).as("t", Tools.fieldNames(this.fields))) : this.select).paramType(paramType).end(Clause.CREATE_VIEW_AS);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

