/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.AggregateFunction;
import org.jooq.AttachableInternal;
import org.jooq.BindContext;
import org.jooq.Binding;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Package;
import org.jooq.Parameter;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.Results;
import org.jooq.Routine;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBinding;
import org.jooq.impl.DefaultBindingGetStatementContext;
import org.jooq.impl.DefaultBindingRegisterContext;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.ParameterImpl;
import org.jooq.impl.ResultsImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.Convert;

public abstract class AbstractRoutine<T>
extends AbstractQueryPart
implements Routine<T>,
AttachableInternal {
    private static final long serialVersionUID = 6330037113167106443L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD, Clause.FIELD_FUNCTION};
    private final Schema schema;
    private final Package pkg;
    private final String name;
    private final List<Parameter<?>> allParameters;
    private final List<Parameter<?>> inParameters;
    private final List<Parameter<?>> outParameters;
    private final DataType<T> type;
    private Parameter<T> returnParameter;
    private ResultsImpl results;
    private boolean overloaded;
    private boolean hasUnnamedParameters;
    private final Map<Parameter<?>, Field<?>> inValues;
    private final Set<Parameter<?>> inValuesDefaulted;
    private final Set<Parameter<?>> inValuesNonDefaulted;
    private transient Field<T> function;
    private Configuration configuration;
    private final Map<Parameter<?>, Object> outValues;
    private final Map<Parameter<?>, Integer> resultIndexes = new HashMap();

    protected AbstractRoutine(String name, Schema schema) {
        this(name, schema, null, null, null, null);
    }

    protected AbstractRoutine(String name, Schema schema, Package pkg) {
        this(name, schema, pkg, null, null, null);
    }

    protected AbstractRoutine(String name, Schema schema, DataType<T> type) {
        this(name, schema, null, type, null, null);
    }

    protected <X> AbstractRoutine(String name, Schema schema, DataType<X> type, Converter<X, T> converter) {
        this(name, schema, null, type, converter, null);
    }

    protected <X> AbstractRoutine(String name, Schema schema, DataType<X> type, Binding<X, T> binding) {
        this(name, schema, null, type, null, binding);
    }

    protected <X, Y> AbstractRoutine(String name, Schema schema, DataType<X> type, Converter<Y, T> converter, Binding<X, Y> binding) {
        this(name, schema, null, type, converter, binding);
    }

    protected AbstractRoutine(String name, Schema schema, Package pkg, DataType<T> type) {
        this(name, schema, pkg, type, null, null);
    }

    protected <X> AbstractRoutine(String name, Schema schema, Package pkg, DataType<X> type, Converter<X, T> converter) {
        this(name, schema, pkg, type, converter, null);
    }

    protected <X> AbstractRoutine(String name, Schema schema, Package pkg, DataType<X> type, Binding<X, T> binding) {
        this(name, schema, pkg, type, null, binding);
    }

    protected <X, Y> AbstractRoutine(String name, Schema schema, Package pkg, DataType<X> type, Converter<Y, T> converter, Binding<X, Y> binding) {
        this.schema = schema;
        this.pkg = pkg;
        this.name = name;
        this.allParameters = new ArrayList();
        this.inParameters = new ArrayList();
        this.outParameters = new ArrayList();
        this.results = new ResultsImpl(null);
        this.inValues = new HashMap();
        this.inValuesDefaulted = new HashSet();
        this.inValuesNonDefaulted = new HashSet();
        this.outValues = new HashMap();
        this.type = converter == null && binding == null ? type : type.asConvertedDataType(DefaultBinding.newBinding(converter, type, binding));
    }

    protected final <N extends Number> void setNumber(Parameter<N> parameter, Number value) {
        this.setValue(parameter, Convert.convert((Object)value, parameter.getType()));
    }

    protected final void setNumber(Parameter<? extends Number> parameter, Field<? extends Number> value) {
        this.setField(parameter, value);
    }

    @Override
    public final <Z> void setValue(Parameter<Z> parameter, Z value) {
        this.set(parameter, value);
    }

    @Override
    public final <Z> void set(Parameter<Z> parameter, Z value) {
        this.setField(parameter, DSL.val(value, parameter.getDataType()));
    }

    protected final void setField(Parameter<?> parameter, Field<?> value) {
        if (value == null) {
            this.setField(parameter, DSL.val(null, parameter.getDataType()));
        } else {
            this.inValues.put(parameter, value);
            this.inValuesDefaulted.remove(parameter);
            this.inValuesNonDefaulted.add(parameter);
        }
    }

    @Override
    public final void attach(Configuration c) {
        this.configuration = c;
    }

    @Override
    public final void detach() {
        this.attach(null);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int execute(Configuration c) {
        Configuration previous = this.configuration();
        try {
            this.attach(c);
            int n = this.execute();
            return n;
        }
        finally {
            this.attach(previous);
        }
    }

    @Override
    public final int execute() {
        SQLDialect family = this.configuration.family();
        this.results.clear();
        this.outValues.clear();
        if (family == SQLDialect.POSTGRES) {
            return this.executeSelectFromPOSTGRES();
        }
        if (this.type == null) {
            return this.executeCallableStatement();
        }
        switch (family) {
            case HSQLDB: {
                if (SQLDataType.RESULT.equals(this.type.getSQLDataType())) {
                    return this.executeSelectFromHSQLDB();
                }
            }
            case H2: {
                return this.executeSelect();
            }
        }
        return this.executeCallableStatement();
    }

    private final int executeSelectFromHSQLDB() {
        DSLContext create = this.create(this.configuration);
        Result result = create.selectFrom(DSL.table(this.asField())).fetch();
        this.outValues.put(this.returnParameter, result);
        return 0;
    }

    private final int executeSelectFromPOSTGRES() {
        DSLContext create = this.create(this.configuration);
        ArrayList fields = new ArrayList();
        if (this.returnParameter != null) {
            fields.add(DSL.field(DSL.name(this.getName()), this.returnParameter.getDataType()));
        }
        for (Parameter<?> p : this.outParameters) {
            fields.add(DSL.field(DSL.name(p.getName()), p.getDataType()));
        }
        Result result = create.select(fields).from("{0}", this.asField()).fetch();
        int i = 0;
        if (this.returnParameter != null) {
            this.outValues.put(this.returnParameter, this.returnParameter.getDataType().convert(result.getValue(0, i++)));
        }
        for (Parameter<?> p : this.outParameters) {
            this.outValues.put(p, p.getDataType().convert(result.getValue(0, i++)));
        }
        return 0;
    }

    private final int executeSelect() {
        Field<T> field = this.asField();
        this.outValues.put(this.returnParameter, this.create(this.configuration).select(field).fetchOne(field));
        return 0;
    }

    private final int executeCallableStatement() {
        DefaultExecuteContext ctx = new DefaultExecuteContext(this.configuration, this);
        ExecuteListeners listener = new ExecuteListeners(ctx);
        try {
            Connection connection = ctx.connection();
            listener.renderStart(ctx);
            ctx.sql(this.create(this.configuration).render(this));
            listener.renderEnd(ctx);
            listener.prepareStart(ctx);
            ctx.statement(connection.prepareCall(ctx.sql()));
            listener.prepareEnd(ctx);
            listener.bindStart(ctx);
            DSL.using(this.configuration).bindContext(ctx.statement()).visit(this);
            this.registerOutParameters(ctx);
            listener.bindEnd(ctx);
            this.execute0(ctx, listener);
            if (ctx.family() != SQLDialect.FIREBIRD) {
                Tools.consumeResultSets(ctx, listener, this.results, null);
            }
            listener.outStart(ctx);
            this.fetchOutParameters(ctx);
            listener.outEnd(ctx);
            int n = 0;
            return n;
        }
        catch (ControlFlowSignal e) {
            throw e;
        }
        catch (RuntimeException e) {
            ctx.exception(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException e) {
            ctx.sqlException(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Tools.safeClose(listener, ctx);
        }
    }

    private final void execute0(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        try {
            listener.executeStart(ctx);
            if (ctx.statement().execute()) {
                ctx.resultSet(ctx.statement().getResultSet());
            }
            listener.executeEnd(ctx);
        }
        catch (SQLException e) {
            Tools.consumeExceptions(ctx.configuration(), ctx.statement(), e);
            throw e;
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public void accept(Context<?> ctx) {
        if (ctx instanceof RenderContext) {
            this.toSQL0((RenderContext)ctx);
        } else {
            this.bind0((BindContext)ctx);
        }
    }

    final void bind0(BindContext context) {
        for (Parameter<?> parameter : this.getParameters()) {
            if (this.getInParameters().contains(parameter) && this.inValuesDefaulted.contains(parameter)) continue;
            this.bind1(context, parameter, this.getInValues().get(parameter) != null, this.resultParameter(parameter));
        }
    }

    private final void bind1(BindContext context, Parameter<?> parameter, boolean bindAsIn, boolean bindAsOut) {
        int index = context.peekIndex();
        if (bindAsOut) {
            this.resultIndexes.put(parameter, index);
        }
        if (bindAsIn) {
            context.visit(this.getInValues().get(parameter));
            if (index == context.peekIndex() && bindAsOut) {
                context.nextIndex();
            }
        } else {
            context.nextIndex();
        }
    }

    final void toSQL0(RenderContext context) {
        this.toSQLDeclare(context);
        this.toSQLBegin(context);
        if (this.getReturnParameter() != null) {
            this.toSQLAssign(context);
        }
        this.toSQLCall(context);
        context.sql('(');
        String separator = "";
        List<Parameter<?>> parameters = this.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter<?> parameter = parameters.get(i);
            if (parameter.equals(this.getReturnParameter())) continue;
            if (this.getOutParameters().contains(parameter)) {
                context.sql(separator);
                this.toSQLOutParam(context, parameter, i);
            } else {
                if (this.inValuesDefaulted.contains(parameter)) continue;
                context.sql(separator);
                this.toSQLInParam(context, parameter, i, this.getInValues().get(parameter));
            }
            separator = ", ";
        }
        context.sql(')');
        this.toSQLEnd(context);
    }

    private final void toSQLEnd(RenderContext context) {
        context.sql(" }");
    }

    private final void toSQLDeclare(RenderContext context) {
    }

    private final void toSQLBegin(RenderContext context) {
        context.sql("{ ");
    }

    private final void toSQLAssign(RenderContext context) {
        context.sql("? = ");
    }

    private final void toSQLCall(RenderContext context) {
        context.sql("call ");
        this.toSQLQualifiedName(context);
    }

    private final void toSQLOutParam(RenderContext context, Parameter<?> parameter, int index) {
        context.sql('?');
    }

    private final void toSQLInParam(RenderContext context, Parameter<?> parameter, int index, Field<?> value) {
        context.visit(value);
    }

    private final void toSQLQualifiedName(RenderContext context) {
        Schema mappedSchema = Tools.getMappedSchema(context.configuration(), this.getSchema());
        if (context.qualify()) {
            if (mappedSchema != null) {
                context.visit(mappedSchema);
                context.sql('.');
            }
            if (this.getPackage() != null) {
                context.visit(DSL.name(this.getPackage().getName()));
                context.sql('.');
            }
        }
        context.literal(this.getName());
    }

    private final void fetchOutParameters(ExecuteContext ctx) throws SQLException {
        for (Parameter<?> parameter : this.getParameters()) {
            if (!this.resultParameter(parameter)) continue;
            this.fetchOutParameter(ctx, parameter);
        }
    }

    private final <U> void fetchOutParameter(ExecuteContext ctx, Parameter<U> parameter) throws SQLException {
        DefaultBindingGetStatementContext out = new DefaultBindingGetStatementContext(ctx.configuration(), ctx.data(), (CallableStatement)ctx.statement(), this.resultIndexes.get(parameter));
        parameter.getBinding().get(out);
        this.outValues.put(parameter, out.value());
    }

    private final void registerOutParameters(ExecuteContext ctx) throws SQLException {
        Configuration c = ctx.configuration();
        Map<Object, Object> data = ctx.data();
        CallableStatement statement = (CallableStatement)ctx.statement();
        for (Parameter<?> parameter : this.getParameters()) {
            if (!this.resultParameter(parameter)) continue;
            this.registerOutParameter(c, data, statement, parameter);
        }
    }

    private final <U> void registerOutParameter(Configuration c, Map<Object, Object> data, CallableStatement statement, Parameter<U> parameter) throws SQLException {
        parameter.getBinding().register(new DefaultBindingRegisterContext(c, data, statement, this.resultIndexes.get(parameter)));
    }

    @Override
    public final T getReturnValue() {
        if (this.returnParameter != null) {
            return this.getValue(this.returnParameter);
        }
        return null;
    }

    @Override
    public final Results getResults() {
        return this.results;
    }

    @Override
    public final <Z> Z getValue(Parameter<Z> parameter) {
        return this.get(parameter);
    }

    @Override
    public final <Z> Z get(Parameter<Z> parameter) {
        return (Z)this.outValues.get(parameter);
    }

    protected final Map<Parameter<?>, Field<?>> getInValues() {
        return this.inValues;
    }

    @Override
    public final List<Parameter<?>> getOutParameters() {
        return Collections.unmodifiableList(this.outParameters);
    }

    @Override
    public final List<Parameter<?>> getInParameters() {
        return Collections.unmodifiableList(this.inParameters);
    }

    @Override
    public final List<Parameter<?>> getParameters() {
        return Collections.unmodifiableList(this.allParameters);
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public final Package getPackage() {
        return this.pkg;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Parameter<T> getReturnParameter() {
        return this.returnParameter;
    }

    protected final void setOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
    }

    protected final boolean isOverloaded() {
        return this.overloaded;
    }

    private final boolean hasUnnamedParameters() {
        return this.hasUnnamedParameters;
    }

    private final void addParameter(Parameter<?> parameter) {
        this.allParameters.add(parameter);
        this.hasUnnamedParameters |= parameter.isUnnamed();
    }

    private final boolean resultParameter(Parameter<?> parameter) {
        return parameter.equals(this.getReturnParameter()) || this.getOutParameters().contains(parameter);
    }

    protected final void addInParameter(Parameter<?> parameter) {
        this.addParameter(parameter);
        this.inParameters.add(parameter);
        this.inValues.put(parameter, DSL.val(null, parameter.getDataType()));
        if (parameter.isDefaulted()) {
            this.inValuesDefaulted.add(parameter);
        } else {
            this.inValuesNonDefaulted.add(parameter);
        }
    }

    protected final void addInOutParameter(Parameter<?> parameter) {
        this.addInParameter(parameter);
        this.outParameters.add(parameter);
    }

    protected final void addOutParameter(Parameter<?> parameter) {
        this.addParameter(parameter);
        this.outParameters.add(parameter);
    }

    protected final void setReturnParameter(Parameter<T> parameter) {
        this.addParameter(parameter);
        this.returnParameter = parameter;
    }

    public final Field<T> asField() {
        if (this.function == null) {
            this.function = new RoutineField();
        }
        return this.function;
    }

    public final Field<T> asField(String alias) {
        return this.asField().as(alias);
    }

    public final AggregateFunction<T> asAggregateFunction() {
        Field[] array = new Field[this.getInParameters().size()];
        int i = 0;
        for (Parameter<?> p : this.getInParameters()) {
            array[i] = this.getInValues().get(p);
            ++i;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.schema != null) {
            names.add(this.schema.getName());
        }
        if (this.pkg != null) {
            names.add(this.pkg.getName());
        }
        names.add(this.name);
        return (AggregateFunction)DSL.function(DSL.name(names.toArray(new String[0])), this.type, array);
    }

    @Deprecated
    protected static final <T> Parameter<T> createParameter(String name, DataType<T> type) {
        return AbstractRoutine.createParameter(name, type, false, null, null);
    }

    @Deprecated
    protected static final <T> Parameter<T> createParameter(String name, DataType<T> type, boolean isDefaulted) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, null, null);
    }

    @Deprecated
    protected static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, Converter<T, U> converter) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, converter, null);
    }

    @Deprecated
    protected static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, Binding<T, U> binding) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, null, binding);
    }

    @Deprecated
    protected static final <T, X, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, Converter<X, U> converter, Binding<T, X> binding) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, false, converter, binding);
    }

    protected static final <T> Parameter<T> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, isUnnamed, null, null);
    }

    protected static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<T, U> converter) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, isUnnamed, converter, null);
    }

    protected static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Binding<T, U> binding) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, isUnnamed, null, binding);
    }

    protected static final <T, X, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<X, U> converter, Binding<T, X> binding) {
        Binding<T, U> actualBinding = DefaultBinding.newBinding(converter, type, binding);
        DataType<Object> actualType = converter == null && binding == null ? type : type.asConvertedDataType(actualBinding);
        return new ParameterImpl<T>(name, actualType, actualBinding, isDefaulted, isUnnamed);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    private class RoutineField
    extends AbstractField<T> {
        private static final long serialVersionUID = -5730297947647252624L;

        RoutineField() {
            super(AbstractRoutine.this.getName(), AbstractRoutine.this.type == null ? SQLDataType.RESULT : AbstractRoutine.this.type);
        }

        @Override
        public void accept(Context<?> ctx) {
            RenderContext local = this.create(ctx).renderContext();
            AbstractRoutine.this.toSQLQualifiedName(local);
            ArrayList fields = new ArrayList();
            for (Parameter<?> parameter : AbstractRoutine.this.getInParameters()) {
                if (AbstractRoutine.this.inValuesDefaulted.contains(parameter)) continue;
                if (ctx.family() == SQLDialect.POSTGRES) {
                    if (AbstractRoutine.this.hasUnnamedParameters()) {
                        if (AbstractRoutine.this.isOverloaded()) {
                            fields.add(AbstractRoutine.this.getInValues().get(parameter).cast(parameter.getType()));
                            continue;
                        }
                        fields.add(AbstractRoutine.this.getInValues().get(parameter));
                        continue;
                    }
                    if (AbstractRoutine.this.isOverloaded()) {
                        fields.add(DSL.field("{0} := {1}", DSL.name(parameter.getName()), AbstractRoutine.this.getInValues().get(parameter).cast(parameter.getType())));
                        continue;
                    }
                    fields.add(DSL.field("{0} := {1}", DSL.name(parameter.getName()), AbstractRoutine.this.getInValues().get(parameter)));
                    continue;
                }
                fields.add(AbstractRoutine.this.getInValues().get(parameter));
            }
            Field result = DSL.function(local.render(), this.getDataType(), fields.toArray(new Field[0]));
            if (Boolean.TRUE.equals(Tools.settings(ctx.configuration()).isRenderScalarSubqueriesForStoredFunctions())) {
                result = DSL.select(result).asField();
            }
            ctx.visit(result);
        }
    }
}

