/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.PreparedStatement;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.QueryPart;
import org.jooq.QueryPartInternal;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.VisitContext;
import org.jooq.VisitListener;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.ParamType;
import org.jooq.conf.Settings;
import org.jooq.impl.AbstractScope;
import org.jooq.impl.Tools;

abstract class AbstractContext<C extends Context<C>>
extends AbstractScope
implements Context<C> {
    final PreparedStatement stmt;
    boolean declareFields;
    boolean declareTables;
    boolean declareAliases;
    boolean declareWindows;
    boolean declareCTE;
    boolean subquery;
    int stringLiteral;
    String stringLiteralEscapedApos = "'";
    int index;
    final VisitListener[] visitListeners;
    private final Deque<Clause> visitClauses;
    private final DefaultVisitContext visitContext;
    private final Deque<QueryPart> visitParts;
    ParamType paramType = ParamType.INDEXED;
    boolean qualifySchema = true;
    boolean qualifyCatalog = true;
    RenderContext.CastMode castMode = RenderContext.CastMode.DEFAULT;

    AbstractContext(Configuration configuration, PreparedStatement stmt) {
        super(configuration);
        this.stmt = stmt;
        VisitListenerProvider[] providers = configuration.visitListenerProviders();
        boolean userInternalVisitListener = false;
        this.visitListeners = new VisitListener[providers.length + (userInternalVisitListener ? 1 : 0)];
        for (int i = 0; i < providers.length; ++i) {
            this.visitListeners[i] = providers[i].provide();
        }
        if (this.visitListeners.length > 0) {
            this.visitContext = new DefaultVisitContext();
            this.visitParts = new ArrayDeque<QueryPart>();
            this.visitClauses = new ArrayDeque<Clause>();
        } else {
            this.visitContext = null;
            this.visitParts = null;
            this.visitClauses = null;
        }
    }

    @Override
    public final C visit(QueryPart part) {
        if (part != null) {
            QueryPart replacement;
            QueryPart original;
            Clause[] clauses;
            Clause[] clauseArray = clauses = this.visitListeners.length > 0 ? this.clause(part) : null;
            if (clauses != null) {
                for (int i = 0; i < clauses.length; ++i) {
                    this.start(clauses[i]);
                }
            }
            if ((original = part) == (replacement = this.start(part))) {
                this.visit0(original);
            } else {
                this.visit0(replacement);
            }
            this.end(replacement);
            if (clauses != null) {
                for (int i = clauses.length - 1; i >= 0; --i) {
                    this.end(clauses[i]);
                }
            }
        }
        return (C)this;
    }

    private final Clause[] clause(QueryPart part) {
        if (part instanceof QueryPartInternal && this.data((Object)Tools.DataKey.DATA_OMIT_CLAUSE_EVENT_EMISSION) == null) {
            return ((QueryPartInternal)part).clauses(this);
        }
        return null;
    }

    @Override
    public final C start(Clause clause) {
        if (clause != null && this.visitClauses != null) {
            this.visitClauses.addLast(clause);
            for (VisitListener listener : this.visitListeners) {
                listener.clauseStart(this.visitContext);
            }
        }
        return (C)this;
    }

    @Override
    public final C end(Clause clause) {
        if (clause != null && this.visitClauses != null) {
            for (VisitListener listener : this.visitListeners) {
                listener.clauseEnd(this.visitContext);
            }
            if (this.visitClauses.removeLast() != clause) {
                throw new IllegalStateException("Mismatch between visited clauses!");
            }
        }
        return (C)this;
    }

    private final QueryPart start(QueryPart part) {
        if (this.visitParts != null) {
            this.visitParts.addLast(part);
            for (VisitListener listener : this.visitListeners) {
                listener.visitStart(this.visitContext);
            }
            return this.visitParts.peekLast();
        }
        return part;
    }

    private final void end(QueryPart part) {
        if (this.visitParts != null) {
            for (VisitListener listener : this.visitListeners) {
                listener.visitEnd(this.visitContext);
            }
            if (this.visitParts.removeLast() != part) {
                throw new RuntimeException("Mismatch between visited query parts");
            }
        }
    }

    private final C visit0(QueryPart part) {
        if (part != null) {
            QueryPartInternal internal = (QueryPartInternal)part;
            if (this.declareFields() && !internal.declaresFields()) {
                boolean aliases = this.declareAliases();
                this.declareFields(false);
                this.visit0(internal);
                this.declareFields(true);
                this.declareAliases(aliases);
            } else if (this.declareTables() && !internal.declaresTables()) {
                boolean aliases = this.declareAliases();
                this.declareTables(false);
                this.visit0(internal);
                this.declareTables(true);
                this.declareAliases(aliases);
            } else if (this.declareWindows() && !internal.declaresWindows()) {
                this.declareWindows(false);
                this.visit0(internal);
                this.declareWindows(true);
            } else if (this.declareCTE() && !internal.declaresCTE()) {
                this.declareCTE(false);
                this.visit0(internal);
                this.declareCTE(true);
            } else if (this.castMode() != RenderContext.CastMode.DEFAULT && !internal.generatesCast()) {
                RenderContext.CastMode previous = this.castMode();
                this.castMode(RenderContext.CastMode.DEFAULT);
                this.visit0(internal);
                this.castMode(previous);
            } else {
                this.visit0(internal);
            }
        }
        return (C)this;
    }

    protected abstract void visit0(QueryPartInternal var1);

    @Override
    public final boolean declareFields() {
        return this.declareFields;
    }

    @Override
    public final C declareFields(boolean d) {
        this.declareFields = d;
        this.declareAliases(d);
        return (C)this;
    }

    @Override
    public final boolean declareTables() {
        return this.declareTables;
    }

    @Override
    public final C declareTables(boolean d) {
        this.declareTables = d;
        this.declareAliases(d);
        return (C)this;
    }

    @Override
    public final boolean declareAliases() {
        return this.declareAliases;
    }

    @Override
    public final C declareAliases(boolean d) {
        this.declareAliases = d;
        return (C)this;
    }

    @Override
    public final boolean declareWindows() {
        return this.declareWindows;
    }

    @Override
    public final C declareWindows(boolean d) {
        this.declareWindows = d;
        return (C)this;
    }

    @Override
    public final boolean declareCTE() {
        return this.declareCTE;
    }

    @Override
    public final C declareCTE(boolean d) {
        this.declareCTE = d;
        return (C)this;
    }

    @Override
    public final boolean subquery() {
        return this.subquery;
    }

    @Override
    public final C subquery(boolean s) {
        this.subquery = s;
        return (C)this;
    }

    @Override
    public final boolean stringLiteral() {
        return this.stringLiteral > 0;
    }

    @Override
    public final C stringLiteral(boolean s) {
        if (s) {
            ++this.stringLiteral;
            this.stringLiteralEscapedApos = this.stringLiteralEscapedApos + this.stringLiteralEscapedApos;
        } else {
            --this.stringLiteral;
            this.stringLiteralEscapedApos = this.stringLiteralEscapedApos.substring(0, this.stringLiteralEscapedApos.length() / 2);
        }
        return (C)this;
    }

    @Override
    public final int nextIndex() {
        return ++this.index;
    }

    @Override
    public final int peekIndex() {
        return this.index + 1;
    }

    @Override
    public final ParamType paramType() {
        return this.paramType;
    }

    @Override
    public final C paramType(ParamType p) {
        this.paramType = p == null ? ParamType.INDEXED : p;
        return (C)this;
    }

    @Override
    public final boolean qualify() {
        return this.qualifySchema();
    }

    @Override
    public final C qualify(boolean q) {
        return this.qualifySchema(q);
    }

    @Override
    public final boolean qualifySchema() {
        return this.qualifySchema;
    }

    @Override
    public final C qualifySchema(boolean q) {
        this.qualifySchema = q;
        return (C)this;
    }

    @Override
    public final boolean qualifyCatalog() {
        return this.qualifyCatalog;
    }

    @Override
    public final C qualifyCatalog(boolean q) {
        this.qualifyCatalog = q;
        return (C)this;
    }

    @Override
    public final RenderContext.CastMode castMode() {
        return this.castMode;
    }

    @Override
    public final C castMode(RenderContext.CastMode mode) {
        this.castMode = mode;
        return (C)this;
    }

    @Override
    @Deprecated
    public final Boolean cast() {
        switch (this.castMode) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public final C castModeSome(SQLDialect ... dialects) {
        return (C)this;
    }

    @Override
    public final PreparedStatement statement() {
        return this.stmt;
    }

    void toString(StringBuilder sb) {
        sb.append("bind index   [");
        sb.append(this.index);
        sb.append("]");
        sb.append("\ndeclaring    [");
        if (this.declareFields) {
            sb.append("fields");
            if (this.declareAliases) {
                sb.append(" and aliases");
            }
        } else if (this.declareTables) {
            sb.append("tables");
            if (this.declareAliases) {
                sb.append(" and aliases");
            }
        } else if (this.declareWindows) {
            sb.append("windows");
        } else if (this.declareCTE) {
            sb.append("cte");
        } else {
            sb.append("-");
        }
        sb.append("]\nsubquery     [");
        sb.append(this.subquery);
        sb.append("]");
    }

    private class DefaultVisitContext
    implements VisitContext {
        private DefaultVisitContext() {
        }

        @Override
        public final Map<Object, Object> data() {
            return AbstractContext.this.data();
        }

        @Override
        public final Object data(Object key) {
            return AbstractContext.this.data(key);
        }

        @Override
        public final Object data(Object key, Object value) {
            return AbstractContext.this.data(key, value);
        }

        @Override
        public final Configuration configuration() {
            return AbstractContext.this.configuration();
        }

        @Override
        public final Settings settings() {
            return Tools.settings(this.configuration());
        }

        @Override
        public final SQLDialect dialect() {
            return Tools.configuration(this.configuration()).dialect();
        }

        @Override
        public final SQLDialect family() {
            return this.dialect().family();
        }

        @Override
        public final Clause clause() {
            return (Clause)((Object)AbstractContext.this.visitClauses.peekLast());
        }

        @Override
        public final Clause[] clauses() {
            return AbstractContext.this.visitClauses.toArray(new Clause[0]);
        }

        @Override
        public final int clausesLength() {
            return AbstractContext.this.visitClauses.size();
        }

        @Override
        public final QueryPart queryPart() {
            return (QueryPart)AbstractContext.this.visitParts.peekLast();
        }

        @Override
        public final void queryPart(QueryPart part) {
            AbstractContext.this.visitParts.pollLast();
            AbstractContext.this.visitParts.addLast(part);
        }

        @Override
        public final QueryPart[] queryParts() {
            return AbstractContext.this.visitParts.toArray(new QueryPart[0]);
        }

        @Override
        public final int queryPartsLength() {
            return AbstractContext.this.visitParts.size();
        }

        @Override
        public final Context<?> context() {
            return AbstractContext.this;
        }

        @Override
        public final RenderContext renderContext() {
            return this.context() instanceof RenderContext ? (RenderContext)this.context() : null;
        }

        @Override
        public final BindContext bindContext() {
            return this.context() instanceof BindContext ? (BindContext)this.context() : null;
        }
    }
}

