/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.keyvalue.mapping.config;

import org.grails.datastore.mapping.keyvalue.mapping.config.AnnotationKeyValueMappingFactory;
import org.grails.datastore.mapping.keyvalue.mapping.config.Family;
import org.grails.datastore.mapping.keyvalue.mapping.config.GormKeyValueMappingFactory;
import org.grails.datastore.mapping.keyvalue.mapping.config.KeyValue;
import org.grails.datastore.mapping.keyvalue.mapping.config.KeyValuePersistentEntity;
import org.grails.datastore.mapping.model.AbstractMappingContext;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.DefaultMappingConfigurationStrategy;
import org.grails.datastore.mapping.model.config.GormMappingConfigurationStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueMappingContext
extends AbstractMappingContext {
    protected MappingFactory<Family, KeyValue> mappingFactory;
    protected MappingConfigurationStrategy syntaxStrategy;
    private String keyspace;
    public static final String GROOVY_OBJECT_CLASS = "groovy.lang.GroovyObject";

    @Override
    public void setCanInitializeEntities(boolean canInitializeEntities) {
        super.setCanInitializeEntities(canInitializeEntities);
        this.syntaxStrategy.setCanExpandMappingContext(false);
    }

    public KeyValueMappingContext(String keyspace) {
        Assert.notNull((Object)keyspace, (String)"Argument [keyspace] cannot be null");
        this.keyspace = keyspace;
        this.initializeDefaultMappingFactory(keyspace);
        this.syntaxStrategy = ClassUtils.isPresent((String)GROOVY_OBJECT_CLASS, (ClassLoader)KeyValueMappingContext.class.getClassLoader()) ? new GormMappingConfigurationStrategy(this.mappingFactory) : new DefaultMappingConfigurationStrategy(this.mappingFactory);
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    protected void initializeDefaultMappingFactory(String keyspace) {
        this.mappingFactory = ClassUtils.isPresent((String)GROOVY_OBJECT_CLASS, (ClassLoader)KeyValueMappingContext.class.getClassLoader()) ? new GormKeyValueMappingFactory(keyspace) : new AnnotationKeyValueMappingFactory(keyspace);
    }

    public void setMappingFactory(MappingFactory<Family, KeyValue> mappingFactory) {
        this.mappingFactory = mappingFactory;
    }

    public void setSyntaxStrategy(MappingConfigurationStrategy syntaxStrategy) {
        this.syntaxStrategy = syntaxStrategy;
    }

    @Override
    public MappingConfigurationStrategy getMappingSyntaxStrategy() {
        return this.syntaxStrategy;
    }

    @Override
    public MappingFactory<Family, KeyValue> getMappingFactory() {
        return this.mappingFactory;
    }

    @Override
    protected PersistentEntity createPersistentEntity(Class javaClass) {
        return new KeyValuePersistentEntity(javaClass, this);
    }
}

