/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine.internal;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;

public class MappingUtils {
    public static String getTargetKey(PersistentProperty property) {
        String tmp;
        PropertyMapping mapping = property.getMapping();
        String targetName = mapping != null && mapping.getMappedForm() != null ? ((tmp = ((Property)mapping.getMappedForm()).getTargetName()) != null ? tmp : property.getName()) : property.getName();
        return targetName;
    }

    public static Collection createConcreteCollection(Class interfaceType) {
        AbstractCollection elements = interfaceType.equals(List.class) ? new ArrayList() : (interfaceType.equals(SortedSet.class) ? new TreeSet() : (interfaceType.equals(Queue.class) ? new ArrayDeque() : new LinkedHashSet()));
        return elements;
    }

    public static Field getDeclaredField(Class javaClass, String propertyName) {
        while (javaClass != null) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = javaClass.getDeclaredFields()) {
                if (!declaredField.getName().equals(propertyName)) continue;
                return declaredField;
            }
            javaClass = javaClass.getSuperclass();
        }
        return null;
    }

    public static Class getGenericTypeForProperty(Class javaClass, String propertyName) {
        Type[] typeArguments;
        Type genericType;
        Class genericClass = null;
        Field declaredField = MappingUtils.getDeclaredField(javaClass, propertyName);
        Type type = genericType = declaredField != null ? declaredField.getGenericType() : null;
        if (genericType instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
            genericClass = (Class)typeArguments[0];
        }
        return genericClass;
    }

    public static Class getGenericTypeForMapProperty(Class javaClass, String propertyName, boolean isKeyType) {
        Type[] typeArguments;
        Type genericType;
        Class genericClass = null;
        Field declaredField = MappingUtils.getDeclaredField(javaClass, propertyName);
        Type type = genericType = declaredField != null ? declaredField.getGenericType() : null;
        if (genericType instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
            genericClass = (Class)typeArguments[isKeyType ? 0 : 1];
        }
        return genericClass;
    }

    public static Class getGenericType(Class propertyType) {
        Type[] bounds;
        Class genericType = null;
        TypeVariable<Class<T>>[] typeParameters = propertyType.getTypeParameters();
        if (typeParameters != null && typeParameters.length > 0 && (bounds = typeParameters[0].getBounds()) != null && bounds.length > 0 && bounds[0] instanceof Class) {
            genericType = (Class)bounds[0];
        }
        return genericType;
    }
}

