/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.FlushModeType;
import org.grails.datastore.mapping.cache.TPCacheAdapter;
import org.grails.datastore.mapping.cache.TPCacheAdapterRepository;
import org.grails.datastore.mapping.collection.AbstractPersistentCollection;
import org.grails.datastore.mapping.collection.PersistentCollection;
import org.grails.datastore.mapping.collection.PersistentList;
import org.grails.datastore.mapping.collection.PersistentSet;
import org.grails.datastore.mapping.collection.PersistentSortedSet;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingInsertAdapter;
import org.grails.datastore.mapping.core.impl.PendingOperationAdapter;
import org.grails.datastore.mapping.core.impl.PendingOperationExecution;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.core.impl.PendingUpdateAdapter;
import org.grails.datastore.mapping.engine.AssociationIndexer;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.engine.LockableEntityPersister;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.engine.PropertyValueIndexer;
import org.grails.datastore.mapping.engine.event.PreDeleteEvent;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.query.Query;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.CannotAcquireLockException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeEntryEntityPersister<T, K>
extends LockableEntityPersister {
    protected ClassMapping classMapping;
    protected TPCacheAdapterRepository<T> cacheAdapterRepository;

    public NativeEntryEntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher) {
        super(mappingContext, entity, session, publisher);
        this.classMapping = entity.getMapping();
    }

    public NativeEntryEntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher, TPCacheAdapterRepository<T> cacheAdapterRepository) {
        super(mappingContext, entity, session, publisher);
        this.classMapping = entity.getMapping();
        this.cacheAdapterRepository = cacheAdapterRepository;
    }

    public abstract String getEntityFamily();

    public ClassMapping getClassMapping() {
        return this.classMapping;
    }

    protected boolean doesRequirePropertyIndexing() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteEntity(PersistentEntity persistentEntity, Object obj) {
        if (obj == null) {
            return;
        }
        EntityAccess entityAccess = this.createEntityAccess(persistentEntity, obj);
        PreDeleteEvent event = new PreDeleteEvent(this.session.getDatastore(), persistentEntity, entityAccess);
        this.publisher.publishEvent((ApplicationEvent)event);
        if (event.isCancelled()) {
            return;
        }
        K key = this.readIdentifierFromObject(obj);
        if (key == null) {
            return;
        }
        FlushModeType flushMode = this.session.getFlushMode();
        try {
            this.session.setFlushMode(FlushModeType.COMMIT);
            this.cascadeBeforeDelete(persistentEntity, entityAccess, key, obj);
            this.deleteEntry(this.getEntityFamily(), key, obj);
            this.cascadeAfterDelete(persistentEntity, entityAccess, key, obj);
        }
        finally {
            this.session.setFlushMode(flushMode);
        }
        this.firePostDeleteEvent(persistentEntity, entityAccess);
    }

    protected void cascadeDeleteCollection(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            this.deleteEntity(this.getMappingContext().getPersistentEntity(child.getClass().getName()), child);
            iter.remove();
        }
    }

    @Override
    protected EntityAccess createEntityAccess(PersistentEntity persistentEntity, Object obj) {
        EntityAccess entityAccess = new EntityAccess(persistentEntity, obj);
        entityAccess.setConversionService(this.getMappingContext().getConversionService());
        return entityAccess;
    }

    protected EntityAccess createEntityAccess(PersistentEntity persistentEntity, Object obj, T nativeEntry) {
        NativeEntryModifyingEntityAccess ea = new NativeEntryModifyingEntityAccess(persistentEntity, obj);
        ea.setConversionService(this.getMappingContext().getConversionService());
        ea.setNativeEntry(nativeEntry);
        return ea;
    }

    protected abstract void deleteEntry(String var1, K var2, Object var3);

    protected void cascadeBeforeDelete(PersistentEntity persistentEntity, EntityAccess entityAccess, K key, Object instance) {
        List<PersistentProperty> props = persistentEntity.getPersistentProperties();
        for (PersistentProperty prop : props) {
            ManyToMany manyToMany;
            Object propValue;
            String propertyKey = this.getPropertyKey(prop);
            if (prop instanceof OneToMany) {
                OneToMany oneToMany = (OneToMany)prop;
                if (!oneToMany.isOwningSide() || !oneToMany.doesCascade(CascadeType.REMOVE) || !((propValue = entityAccess.getProperty(oneToMany.getName())) instanceof Collection)) continue;
                this.cascadeDeleteCollection((Collection)propValue);
                continue;
            }
            if (!(prop instanceof ManyToMany) || !(manyToMany = (ManyToMany)prop).isOwningSide() || !manyToMany.doesCascade(CascadeType.REMOVE) || !((propValue = entityAccess.getProperty(manyToMany.getName())) instanceof Collection)) continue;
            this.cascadeDeleteCollection((Collection)propValue);
        }
    }

    protected void cascadeAfterDelete(PersistentEntity persistentEntity, EntityAccess entityAccess, K key, Object instance) {
        List<PersistentProperty> props = persistentEntity.getPersistentProperties();
        for (PersistentProperty prop : props) {
            Persister persister;
            Object value;
            String propertyKey = this.getPropertyKey(prop);
            if (prop instanceof Basic) {
                Object propValue = entityAccess.getProperty(prop.getName());
                continue;
            }
            if (prop instanceof OneToMany) {
                Object propValue;
                OneToMany oneToMany = (OneToMany)prop;
                if (!oneToMany.isOwningSide() || !oneToMany.doesCascade(CascadeType.REMOVE) || !((propValue = entityAccess.getProperty(oneToMany.getName())) instanceof Collection)) continue;
                this.cascadeDeleteCollection((Collection)propValue);
                continue;
            }
            if (!(prop instanceof ToOne)) continue;
            ToOne association = (ToOne)prop;
            if (prop instanceof Embedded || prop instanceof EmbeddedCollection || !association.doesCascade(CascadeType.REMOVE) || !association.isOwningSide() || (value = entityAccess.getProperty(association.getName())) == null || (persister = this.session.getPersister(value)) == null) continue;
            persister.delete(value);
        }
    }

    @Override
    protected final void deleteEntities(PersistentEntity persistentEntity, Iterable objects) {
        if (objects != null) {
            LinkedHashSet<K> keys = new LinkedHashSet<K>();
            ArrayList deleteList = new ArrayList();
            for (Object object : objects) {
                K key = this.readIdentifierFromObject(object);
                if (key == null || keys.contains(key) || this.cancelDelete(persistentEntity, this.createEntityAccess(persistentEntity, object))) continue;
                keys.add(key);
                deleteList.add(object);
            }
            if (!keys.isEmpty()) {
                this.deleteEntries(this.getEntityFamily(), new ArrayList(keys));
                for (Object object : deleteList) {
                    this.firePostDeleteEvent(persistentEntity, this.createEntityAccess(persistentEntity, object));
                }
            }
        }
    }

    protected K readIdentifierFromObject(Object object) {
        EntityAccess access = this.createEntityAccess(this.getPersistentEntity(), object);
        Object idValue = access.getIdentifier();
        Object key = null;
        if (idValue != null) {
            key = this.inferNativeKey(this.getEntityFamily(), idValue);
        }
        return (K)key;
    }

    @Override
    public final Object lock(Serializable id) throws CannotAcquireLockException {
        return this.lock(id, DEFAULT_TIMEOUT);
    }

    @Override
    public final Object lock(Serializable id, int timeout) throws CannotAcquireLockException {
        this.lockEntry(this.getPersistentEntity(), this.getEntityFamily(), id, timeout);
        return this.retrieve(id);
    }

    protected void lockEntry(PersistentEntity persistentEntity, String entityFamily, Serializable id, int timeout) {
    }

    @Override
    public boolean isLocked(Object o) {
        return false;
    }

    @Override
    public void unlock(Object o) {
        this.unlockEntry(this.getPersistentEntity(), this.getEntityFamily(), (Serializable)this.createEntityAccess(this.getPersistentEntity(), o).getIdentifier());
    }

    protected void unlockEntry(PersistentEntity persistentEntity, String entityFamily, Serializable id) {
    }

    @Override
    protected final Object retrieveEntity(PersistentEntity persistentEntity, Serializable nativeKey) {
        Serializable key = this.convertToNativeKey(nativeKey);
        T nativeEntry = this.getFromTPCache(persistentEntity, nativeKey);
        if (nativeEntry == null && (nativeEntry = this.retrieveEntry(persistentEntity, this.getEntityFamily(), key)) == null) {
            return null;
        }
        return this.createObjectFromNativeEntry(persistentEntity, key, nativeEntry);
    }

    protected Serializable convertToNativeKey(Serializable nativeKey) {
        return nativeKey;
    }

    @Override
    public Serializable refresh(Object o) {
        PersistentEntity entity = this.getPersistentEntity();
        EntityAccess ea = this.createEntityAccess(entity, o);
        Serializable identifier = (Serializable)ea.getIdentifier();
        if (identifier == null) {
            return null;
        }
        T entry = this.retrieveEntry(entity, this.getEntityFamily(), identifier);
        this.refreshObjectStateFromNativeEntry(entity, o, identifier, entry, false);
        return identifier;
    }

    public Object createObjectFromNativeEntry(PersistentEntity persistentEntity, Serializable nativeKey, T nativeEntry) {
        persistentEntity = this.discriminatePersistentEntity(persistentEntity, nativeEntry);
        this.cacheNativeEntry(persistentEntity, nativeKey, nativeEntry);
        Object obj = this.newEntityInstance(persistentEntity);
        this.refreshObjectStateFromNativeEntry(persistentEntity, obj, nativeKey, nativeEntry, false);
        return obj;
    }

    public Object createObjectFromEmbeddedNativeEntry(PersistentEntity persistentEntity, T nativeEntry) {
        persistentEntity = this.discriminatePersistentEntity(persistentEntity, nativeEntry);
        Object obj = this.newEntityInstance(persistentEntity);
        this.refreshObjectStateFromNativeEntry(persistentEntity, obj, null, nativeEntry, true);
        return obj;
    }

    protected void cacheNativeEntry(PersistentEntity persistentEntity, Serializable nativeKey, T nativeEntry) {
        SessionImplementor si = (SessionImplementor)((Object)this.session);
        Serializable key = (Serializable)this.getMappingContext().getConversionService().convert((Object)nativeKey, persistentEntity.getIdentity().getType());
        si.cacheEntry(persistentEntity, key, nativeEntry);
    }

    protected void refreshObjectStateFromNativeEntry(PersistentEntity persistentEntity, Object obj, Serializable nativeKey, T nativeEntry) {
        this.refreshObjectStateFromNativeEntry(persistentEntity, obj, nativeKey, nativeEntry, false);
    }

    protected void refreshObjectStateFromNativeEntry(PersistentEntity persistentEntity, Object obj, Serializable nativeKey, T nativeEntry, boolean isEmbedded) {
        EntityAccess ea = this.createEntityAccess(persistentEntity, obj, nativeEntry);
        ea.setConversionService(this.getMappingContext().getConversionService());
        if (!(persistentEntity instanceof EmbeddedPersistentEntity)) {
            String idName = ea.getIdentifierName();
            ea.setProperty(idName, nativeKey);
        }
        List<PersistentProperty> props = persistentEntity.getPersistentProperties();
        for (PersistentProperty prop : props) {
            PropertyMapping<Property> associationPropertyMapping;
            Association association;
            String propKey = this.getNativePropertyKey(prop);
            if (prop instanceof Simple) {
                ea.setProperty(prop.getName(), this.getEntryValue(nativeEntry, propKey));
                continue;
            }
            if (prop instanceof Basic) {
                Object entryValue = this.getEntryValue(nativeEntry, propKey);
                entryValue = this.convertBasicEntryValue(persistentEntity, prop, entryValue);
                ea.setProperty(prop.getName(), entryValue);
                continue;
            }
            if (prop instanceof Custom) {
                this.handleCustom(prop, ea, nativeEntry);
                continue;
            }
            if (prop instanceof ToOne) {
                Serializable associationKey;
                PersistentEntity associatedEntity;
                if (prop instanceof Embedded) {
                    T embeddedEntry;
                    Embedded embedded = (Embedded)prop;
                    if (embedded.getAssociatedEntity() == null || (embeddedEntry = this.getEmbedded(nativeEntry, propKey)) == null) continue;
                    Object embeddedInstance = this.createObjectFromEmbeddedNativeEntry(embedded.getAssociatedEntity(), embeddedEntry);
                    ea.setProperty(propKey, embeddedInstance);
                    Association inverseSide = embedded.getInverseSide();
                    if (!embedded.isBidirectional() || inverseSide == null) continue;
                    EntityAccess embeddedEa = this.createEntityAccess(embedded.getAssociatedEntity(), embeddedInstance);
                    embeddedEa.setProperty(inverseSide.getName(), obj);
                    continue;
                }
                association = (ToOne)prop;
                Serializable tmp = null;
                if (!((ToOne)association).isForeignKeyInChild()) {
                    tmp = (Serializable)this.getEntryValue(nativeEntry, propKey);
                } else if (association.isBidirectional() && association.getAssociatedEntity() != null) {
                    Query query = this.session.createQuery(association.getAssociatedEntity().getJavaClass());
                    query.eq(association.getInverseSide().getName(), obj).projections().id();
                    tmp = (Serializable)query.singleResult();
                }
                if (this.isEmbeddedEntry(tmp)) {
                    PersistentEntity associatedEntity2 = ((ToOne)prop).getAssociatedEntity();
                    associatedEntity2 = this.discriminatePersistentEntity(associatedEntity2, tmp);
                    Object instance = this.newEntityInstance(associatedEntity2);
                    this.refreshObjectStateFromNativeEntry(associatedEntity2, instance, null, tmp, false);
                    ea.setProperty(prop.getName(), instance);
                    continue;
                }
                if (tmp == null || prop.getType().isInstance(tmp) || (associatedEntity = association.getAssociatedEntity()) == null || (associationKey = (Serializable)this.getMappingContext().getConversionService().convert((Object)tmp, associatedEntity.getIdentity().getType())) == null) continue;
                PropertyMapping<Property> associationPropertyMapping2 = prop.getMapping();
                boolean isLazy = this.isLazyAssociation(associationPropertyMapping2);
                Class<?> propType = prop.getType();
                Object value = isLazy ? this.session.proxy(propType, associationKey) : this.session.retrieve(propType, associationKey);
                ea.setProperty(prop.getName(), value);
                continue;
            }
            if (prop instanceof EmbeddedCollection) {
                Object loadedInstances;
                Object embeddedInstances = this.getEntryValue(nativeEntry, propKey);
                EmbeddedCollection embeddedCollection = (EmbeddedCollection)prop;
                this.loadEmbeddedCollection(embeddedCollection, ea, embeddedInstances, propKey);
                Association inverseSide = embeddedCollection.getInverseSide();
                if (!embeddedCollection.isBidirectional() || inverseSide == null || !((loadedInstances = ea.getProperty(embeddedCollection.getName())) instanceof Collection)) continue;
                Collection embeddedInstancesCollection = (Collection)loadedInstances;
                for (Object embeddedInstance : embeddedInstancesCollection) {
                    if (embeddedInstance == null) continue;
                    EntityAccess embeddedEa = this.createEntityAccess(embeddedCollection.getAssociatedEntity(), embeddedInstance);
                    embeddedEa.setProperty(inverseSide.getName(), obj);
                }
                continue;
            }
            if (prop instanceof OneToMany) {
                association = (Association)prop;
                associationPropertyMapping = association.getMapping();
                if (isEmbedded) {
                    List keys = this.loadEmbeddedCollectionKeys((Association)prop, ea, nativeEntry);
                    if (List.class.isAssignableFrom(association.getType())) {
                        ea.setPropertyNoConversion(association.getName(), new PersistentList(keys, association.getAssociatedEntity().getJavaClass(), this.session));
                        continue;
                    }
                    if (!Set.class.isAssignableFrom(association.getType())) continue;
                    ea.setPropertyNoConversion(association.getName(), new PersistentSet(keys, association.getAssociatedEntity().getJavaClass(), this.session));
                    continue;
                }
                boolean isLazy = this.isLazyAssociation(associationPropertyMapping);
                AssociationIndexer indexer = this.getAssociationIndexer(nativeEntry, association);
                nativeKey = (Serializable)this.getMappingContext().getConversionService().convert((Object)nativeKey, this.getPersistentEntity().getIdentity().getType());
                if (isLazy) {
                    if (List.class.isAssignableFrom(association.getType())) {
                        ea.setPropertyNoConversion(association.getName(), new PersistentList(nativeKey, this.session, indexer));
                        continue;
                    }
                    if (SortedSet.class.isAssignableFrom(association.getType())) {
                        ea.setPropertyNoConversion(association.getName(), new PersistentSortedSet(nativeKey, this.session, indexer));
                        continue;
                    }
                    if (!Set.class.isAssignableFrom(association.getType())) continue;
                    ea.setPropertyNoConversion(association.getName(), new PersistentSet(nativeKey, this.session, indexer));
                    continue;
                }
                if (indexer == null) continue;
                List keys = indexer.query(nativeKey);
                ea.setProperty(association.getName(), this.session.retrieveAll(association.getAssociatedEntity().getJavaClass(), keys));
                continue;
            }
            if (!(prop instanceof ManyToMany)) continue;
            ManyToMany manyToMany = (ManyToMany)prop;
            associationPropertyMapping = manyToMany.getMapping();
            boolean isLazy = this.isLazyAssociation(associationPropertyMapping);
            nativeKey = (Serializable)this.getMappingContext().getConversionService().convert((Object)nativeKey, this.getPersistentEntity().getIdentity().getType());
            PersistentEntity associatedEntity = manyToMany.getAssociatedEntity();
            if (associatedEntity == null) continue;
            Class childType = associatedEntity.getJavaClass();
            Collection cached = ((SessionImplementor)((Object)this.session)).getCachedCollection(persistentEntity, nativeKey, manyToMany.getName());
            if (cached == null) {
                Collection<Object> collection;
                if (isLazy) {
                    Collection keys = this.getManyToManyKeys(persistentEntity, obj, nativeKey, nativeEntry, manyToMany);
                    if (List.class.isAssignableFrom(manyToMany.getType())) {
                        collection = new PersistentList(keys, childType, this.session);
                        ea.setPropertyNoConversion(manyToMany.getName(), collection);
                    } else if (Set.class.isAssignableFrom(manyToMany.getType())) {
                        collection = new PersistentSet(keys, childType, this.session);
                        ea.setPropertyNoConversion(manyToMany.getName(), collection);
                    } else {
                        collection = Collections.emptyList();
                    }
                } else {
                    AssociationIndexer indexer = this.getAssociationIndexer(nativeEntry, manyToMany);
                    if (indexer == null) {
                        collection = List.class.isAssignableFrom(manyToMany.getType()) ? Collections.emptyList() : (Set.class.isAssignableFrom(manyToMany.getType()) ? Collections.emptySet() : Collections.emptyList());
                    } else {
                        List keys = indexer.query(nativeKey);
                        collection = this.session.retrieveAll(childType, keys);
                        ea.setProperty(manyToMany.getName(), collection);
                    }
                }
                ((SessionImplementor)((Object)this.session)).cacheCollection(persistentEntity, nativeKey, collection, manyToMany.getName());
                continue;
            }
            ea.setProperty(manyToMany.getName(), cached);
        }
        this.firePostLoadEvent(persistentEntity, ea);
    }

    protected Object convertBasicEntryValue(PersistentEntity persistentEntity, PersistentProperty prop, Object entryValue) {
        if (entryValue instanceof Map) {
            Map nativeMap = (Map)entryValue;
            LinkedHashMap targetMap = new LinkedHashMap();
            Class<?> propertyType = prop.getType();
            Class genericType = MappingUtils.getGenericTypeForMapProperty(persistentEntity.getJavaClass(), prop.getName(), false);
            if (genericType != null) {
                SimpleTypeConverter converter = new SimpleTypeConverter();
                converter.setConversionService(this.getMappingContext().getConversionService());
                Iterator i$ = nativeMap.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    value = converter.convertIfNecessary(value, genericType);
                    targetMap.put(key, value);
                }
            } else {
                targetMap.putAll(nativeMap);
            }
            entryValue = targetMap;
        } else if (entryValue instanceof Collection) {
            Collection collection = MappingUtils.createConcreteCollection(prop.getType());
            Class<?> propertyType = prop.getType();
            Class genericType = MappingUtils.getGenericTypeForProperty(persistentEntity.getJavaClass(), prop.getName());
            Collection collectionValue = (Collection)entryValue;
            if (genericType != null) {
                SimpleTypeConverter converter = new SimpleTypeConverter();
                converter.setConversionService(this.getMappingContext().getConversionService());
                for (Object o : collectionValue) {
                    o = converter.convertIfNecessary(o, genericType);
                    collection.add(o);
                }
            } else {
                collection.addAll(collectionValue);
            }
            entryValue = collection;
        }
        return entryValue;
    }

    protected List loadEmbeddedCollectionKeys(Association association, EntityAccess ea, T nativeEntry) {
        return Collections.emptyList();
    }

    protected void setEmbeddedCollectionKeys(Association association, EntityAccess embeddedEntityAccess, T embeddedEntry, List<Serializable> keys) {
    }

    protected boolean isEmbeddedEntry(Object entry) {
        return false;
    }

    protected void loadEmbeddedCollection(EmbeddedCollection embeddedCollection, EntityAccess ea, Object embeddedInstances, String propertyKey) {
    }

    protected T getEmbedded(T nativeEntry, String key) {
        return null;
    }

    private void handleCustom(PersistentProperty prop, EntityAccess ea, T nativeEntry) {
        CustomTypeMarshaller customTypeMarshaller = ((Custom)prop).getCustomTypeMarshaller();
        if (!customTypeMarshaller.supports(this.getSession().getDatastore())) {
            return;
        }
        Object value = customTypeMarshaller.read(prop, nativeEntry);
        ea.setProperty(prop.getName(), value);
    }

    protected Collection getManyToManyKeys(PersistentEntity persistentEntity, Object obj, Serializable nativeKey, T nativeEntry, ManyToMany manyToMany) {
        return null;
    }

    protected String getNativePropertyKey(PersistentProperty prop) {
        PropertyMapping pm = prop.getMapping();
        String propKey = null;
        if (pm.getMappedForm() != null) {
            propKey = ((Property)pm.getMappedForm()).getTargetName();
        }
        if (propKey == null) {
            propKey = prop.getName();
        }
        return propKey;
    }

    protected PersistentEntity discriminatePersistentEntity(PersistentEntity persistentEntity, T nativeEntry) {
        return persistentEntity;
    }

    private boolean isLazyAssociation(PropertyMapping<Property> associationPropertyMapping) {
        if (associationPropertyMapping == null) {
            return true;
        }
        Property kv = associationPropertyMapping.getMappedForm();
        return kv.getFetchStrategy() == FetchType.LAZY;
    }

    @Override
    protected final Serializable persistEntity(final PersistentEntity persistentEntity, Object obj) {
        PendingOperationAdapter postOperation;
        K updateId;
        PendingOperationAdapter pendingOperation;
        T tmp = null;
        ProxyFactory proxyFactory = this.getProxyFactory();
        obj = proxyFactory.unwrap(obj);
        final NativeEntryModifyingEntityAccess entityAccess = (NativeEntryModifyingEntityAccess)this.createEntityAccess(persistentEntity, obj, tmp);
        K k = this.readObjectIdentifier(entityAccess, persistentEntity.getMapping());
        boolean isUpdate = k != null;
        boolean assignedId = false;
        if (isUpdate && !this.getSession().isDirty(obj)) {
            return (Serializable)k;
        }
        PropertyMapping mapping = persistentEntity.getIdentity().getMapping();
        if (mapping != null) {
            Property p = (Property)mapping.getMappedForm();
            boolean bl = assignedId = p != null && "assigned".equals(p.getGenerator());
            if (assignedId && isUpdate && !this.session.contains(obj)) {
                isUpdate = false;
            }
        }
        String family = this.getEntityFamily();
        SessionImplementor si = (SessionImplementor)((Object)this.session);
        if (!isUpdate) {
            tmp = this.createNewEntry(family);
            if (!assignedId) {
                k = this.generateIdentifier(persistentEntity, tmp);
            }
            this.cacheNativeEntry(persistentEntity, (Serializable)k, tmp);
            pendingOperation = new PendingInsertAdapter<T, K>(persistentEntity, k, tmp, entityAccess){

                @Override
                public void run() {
                    NativeEntryEntityPersister.this.executeInsert(persistentEntity, entityAccess, this.getNativeKey(), this.getNativeEntry());
                }
            };
            entityAccess.setProperty(entityAccess.getIdentifierName(), k);
        } else {
            tmp = si.getCachedEntry(persistentEntity, (Serializable)k);
            if (tmp == null && (tmp = (T)this.getFromTPCache(persistentEntity, (Serializable)k)) == null) {
                tmp = this.retrieveEntry(persistentEntity, family, (Serializable)k);
            }
            if (tmp == null) {
                tmp = this.createNewEntry(family);
            }
            final T finalTmp = tmp;
            final K finalK = k;
            pendingOperation = new PendingUpdateAdapter<T, K>(persistentEntity, finalK, finalTmp, entityAccess){

                @Override
                public void run() {
                    if (NativeEntryEntityPersister.this.cancelUpdate(persistentEntity, entityAccess)) {
                        return;
                    }
                    NativeEntryEntityPersister.this.updateEntry(persistentEntity, entityAccess, this.getNativeKey(), this.getNativeEntry());
                    NativeEntryEntityPersister.this.updateTPCache(persistentEntity, finalTmp, (Serializable)finalK);
                    NativeEntryEntityPersister.this.firePostUpdateEvent(persistentEntity, entityAccess);
                }
            };
        }
        final T e = tmp;
        entityAccess.setNativeEntry(e);
        List<PersistentProperty> props = persistentEntity.getPersistentProperties();
        final HashMap<Association, List<Serializable>> toManyKeys = new HashMap<Association, List<Serializable>>();
        final HashMap<OneToMany, Serializable> inverseCollectionUpdates = new HashMap<OneToMany, Serializable>();
        final HashMap<PersistentProperty, Object> toIndex = new HashMap<PersistentProperty, Object>();
        final HashMap<PersistentProperty, Object> toUnindex = new HashMap<PersistentProperty, Object>();
        entityAccess.setToIndex(toIndex);
        for (PersistentProperty prop : props) {
            Collection associatedObjects;
            Object propValue;
            PropertyMapping pm = prop.getMapping();
            Property mappedProperty = (Property)pm.getMappedForm();
            String key = null;
            if (mappedProperty != null) {
                key = mappedProperty.getTargetName();
            }
            if (key == null) {
                key = prop.getName();
            }
            boolean indexed = this.isPropertyIndexed(mappedProperty);
            if (prop instanceof Simple || prop instanceof Basic) {
                Object propValue2 = entityAccess.getProperty(prop.getName());
                this.handleIndexing(isUpdate, e, toIndex, toUnindex, prop, key, indexed, propValue2);
                this.setEntryValue(e, key, propValue2);
                continue;
            }
            if (prop instanceof Custom) {
                CustomTypeMarshaller customTypeMarshaller = ((Custom)prop).getCustomTypeMarshaller();
                if (!customTypeMarshaller.supports(this.getSession().getDatastore())) continue;
                propValue = entityAccess.getProperty(prop.getName());
                Object customValue = customTypeMarshaller.write(prop, propValue, e);
                this.handleIndexing(isUpdate, e, toIndex, toUnindex, prop, key, indexed, customValue);
                continue;
            }
            if (prop instanceof OneToMany) {
                PersistentCollection persistentCollection;
                EntityPersister associationPersister;
                PersistentEntity associatedEntity;
                OneToMany oneToMany = (OneToMany)prop;
                propValue = entityAccess.getProperty(oneToMany.getName());
                if (!(propValue instanceof Collection) || !this.isInitializedCollection(associatedObjects = (Collection)propValue) || (associatedEntity = oneToMany.getAssociatedEntity()) == null || (associationPersister = (EntityPersister)this.session.getPersister(associatedEntity)) == null) continue;
                boolean newCollection = false;
                if (associatedObjects instanceof PersistentCollection) {
                    persistentCollection = (PersistentCollection)associatedObjects;
                } else {
                    Class associationType = associatedEntity.getJavaClass();
                    persistentCollection = this.getPersistentCollection(associatedObjects, associationType);
                    entityAccess.setProperty(oneToMany.getName(), persistentCollection);
                    persistentCollection.markDirty();
                    newCollection = true;
                }
                if (!persistentCollection.isDirty()) continue;
                persistentCollection.resetDirty();
                List<Serializable> keys = associationPersister.persist(associatedObjects);
                toManyKeys.put(oneToMany, keys);
                if (!newCollection) continue;
                entityAccess.setProperty(oneToMany.getName(), associatedObjects);
                continue;
            }
            if (prop instanceof ManyToMany) {
                ManyToMany manyToMany = (ManyToMany)prop;
                propValue = entityAccess.getProperty(manyToMany.getName());
                if (!(propValue instanceof Collection) || !this.isInitializedCollection(associatedObjects = (Collection)propValue)) continue;
                this.setManyToMany(persistentEntity, obj, e, manyToMany, associatedObjects, toManyKeys);
                continue;
            }
            if (prop instanceof ToOne) {
                ToOne association = (ToOne)prop;
                if (prop instanceof Embedded) {
                    this.handleEmbeddedToOne(association, key, entityAccess, e);
                    continue;
                }
                if (!association.doesCascade(CascadeType.PERSIST) || association.getAssociatedEntity() == null) continue;
                Object associatedObject = entityAccess.getProperty(prop.getName());
                if (associatedObject != null) {
                    Object inverseEntity;
                    Serializable associationId;
                    NativeEntryEntityPersister associationPersister = (NativeEntryEntityPersister)this.session.getPersister(associatedObject);
                    if (proxyFactory.isInitialized(associatedObject) && !this.session.contains(associatedObject)) {
                        Serializable tempId = associationPersister.getObjectIdentifier(associatedObject);
                        if (tempId == null && association.isOwningSide()) {
                            tempId = this.session.persist(associatedObject);
                        }
                        associationId = tempId;
                    } else {
                        associationId = associationPersister.getObjectIdentifier(associatedObject);
                    }
                    if (association.isForeignKeyInChild()) {
                        Association inverseSide;
                        Object cachedAssociationEntry = si.getCachedEntry(association.getAssociatedEntity(), associationId);
                        if (cachedAssociationEntry != null && association.isBidirectional()) {
                            inverseSide = association.getInverseSide();
                            if (inverseSide != null) {
                                this.setEntryValue(cachedAssociationEntry, inverseSide.getName(), this.formulateDatabaseReference(association.getAssociatedEntity(), inverseSide, (Serializable)k));
                            } else {
                                this.setEntryValue(cachedAssociationEntry, key, this.formulateDatabaseReference(association.getAssociatedEntity(), inverseSide, (Serializable)k));
                            }
                        }
                        if (!association.doesCascade(CascadeType.PERSIST)) continue;
                        if (association.isBidirectional() && (inverseSide = association.getInverseSide()) != null) {
                            EntityAccess inverseAccess = new EntityAccess(inverseSide.getOwner(), associatedObject);
                            inverseAccess.setProperty(inverseSide.getName(), obj);
                        }
                        associationPersister.persist(associatedObject);
                        continue;
                    }
                    if (associationId == null) continue;
                    if (indexed && this.doesRequirePropertyIndexing()) {
                        toIndex.put(prop, associationId);
                        if (isUpdate) {
                            Object oldValue = this.getEntryValue(e, key);
                            Object object = oldValue = oldValue != null ? this.convertToNativeKey((Serializable)oldValue) : oldValue;
                            if (oldValue != null && !oldValue.equals(associationId)) {
                                toUnindex.put(prop, oldValue);
                            }
                        }
                    }
                    this.setEntryValue(e, key, this.formulateDatabaseReference(persistentEntity, association, associationId));
                    if (!association.isBidirectional()) continue;
                    Association inverse = association.getInverseSide();
                    if (inverse instanceof OneToMany) {
                        inverseCollectionUpdates.put((OneToMany)inverse, associationId);
                    }
                    if ((inverseEntity = proxyFactory.unwrap(entityAccess.getProperty(association.getName()))) == null) continue;
                    EntityAccess inverseAccess = this.createEntityAccess(association.getAssociatedEntity(), inverseEntity);
                    Object entity = entityAccess.getEntity();
                    if (inverse instanceof OneToMany) {
                        Collection existingValues = (Collection)inverseAccess.getProperty(inverse.getName());
                        if (existingValues == null) {
                            existingValues = MappingUtils.createConcreteCollection(inverse.getType());
                            inverseAccess.setProperty(inverse.getName(), existingValues);
                        }
                        if (existingValues.contains(entity)) continue;
                        existingValues.add(entity);
                        continue;
                    }
                    if (!(inverse instanceof ToOne)) continue;
                    inverseAccess.setProperty(inverse.getName(), entity);
                    continue;
                }
                this.setEntryValue(e, this.getPropertyKey(prop), null);
                continue;
            }
            if (!(prop instanceof EmbeddedCollection)) continue;
            this.handleEmbeddedToMany(entityAccess, e, prop, key);
        }
        if (!isUpdate) {
            updateId = k;
            postOperation = new PendingOperationAdapter<T, K>(persistentEntity, k, e){

                @Override
                public void run() {
                    NativeEntryEntityPersister.this.updateToManyIndices(e, updateId, toManyKeys);
                    if (NativeEntryEntityPersister.this.doesRequirePropertyIndexing()) {
                        toIndex.put(persistentEntity.getIdentity(), updateId);
                        NativeEntryEntityPersister.this.updatePropertyIndices(updateId, toIndex, toUnindex);
                    }
                    for (OneToMany inverseCollection : inverseCollectionUpdates.keySet()) {
                        Serializable primaryKey = (Serializable)inverseCollectionUpdates.get(inverseCollection);
                        NativeEntryEntityPersister inversePersister = (NativeEntryEntityPersister)NativeEntryEntityPersister.this.session.getPersister(inverseCollection.getOwner());
                        AssociationIndexer associationIndexer = inversePersister.getAssociationIndexer(e, inverseCollection);
                        associationIndexer.index(primaryKey, updateId);
                    }
                }
            };
            pendingOperation.addCascadeOperation(postOperation);
            if (k == null) {
                PendingOperationExecution.executePendingOperation(pendingOperation);
            } else {
                si.addPendingInsert((PendingInsert)((Object)pendingOperation));
            }
        } else {
            updateId = k;
            postOperation = new PendingOperationAdapter<T, K>(persistentEntity, k, e){

                @Override
                public void run() {
                    NativeEntryEntityPersister.this.updateToManyIndices(e, updateId, toManyKeys);
                    if (NativeEntryEntityPersister.this.doesRequirePropertyIndexing()) {
                        NativeEntryEntityPersister.this.updatePropertyIndices(updateId, toIndex, toUnindex);
                    }
                }
            };
            pendingOperation.addCascadeOperation(postOperation);
            si.addPendingUpdate((PendingUpdate)((Object)pendingOperation));
        }
        return (Serializable)k;
    }

    private AbstractPersistentCollection getPersistentCollection(Collection associatedObjects, Class associationType) {
        if (associatedObjects instanceof Set) {
            return associatedObjects instanceof SortedSet ? new PersistentSortedSet(associationType, this.getSession(), (SortedSet)associatedObjects) : new PersistentSet(associationType, this.getSession(), associatedObjects);
        }
        return new PersistentList(associationType, this.getSession(), (List)associatedObjects);
    }

    private boolean isInitializedCollection(Collection associatedObjects) {
        return !(associatedObjects instanceof PersistentCollection) || ((PersistentCollection)associatedObjects).isInitialized();
    }

    protected Object formulateDatabaseReference(PersistentEntity persistentEntity, Association association, Serializable associationId) {
        return associationId;
    }

    protected void handleEmbeddedToMany(EntityAccess entityAccess, T e, PersistentProperty prop, String key) {
        Object embeddedInstances = entityAccess.getProperty(prop.getName());
        if (!(embeddedInstances instanceof Collection) || ((Collection)embeddedInstances).isEmpty()) {
            if (embeddedInstances == null) {
                this.setEmbeddedCollection(e, key, null, null);
            } else {
                this.setEmbeddedCollection(e, key, MappingUtils.createConcreteCollection(prop.getType()), new ArrayList());
            }
            return;
        }
        Collection instances = (Collection)embeddedInstances;
        ArrayList<T> embeddedEntries = new ArrayList<T>();
        for (Object instance : instances) {
            T entry = this.handleEmbeddedInstance((Association)prop, instance);
            embeddedEntries.add(entry);
        }
        this.setEmbeddedCollection(e, key, instances, embeddedEntries);
    }

    protected void handleEmbeddedToOne(Association association, String key, EntityAccess entityAccess, T nativeEntry) {
        Object embeddedInstance = entityAccess.getProperty(association.getName());
        if (embeddedInstance == null) {
            this.setEmbedded(nativeEntry, key, null);
            return;
        }
        T embeddedEntry = this.handleEmbeddedInstance(association, embeddedInstance);
        this.setEmbedded(nativeEntry, key, embeddedEntry);
    }

    protected T handleEmbeddedInstance(Association association, Object embeddedInstance) {
        PersistentEntity associatedEntity;
        NativeEntryEntityPersister embeddedPersister = (NativeEntryEntityPersister)this.session.getPersister(embeddedInstance);
        T embeddedEntry = embeddedPersister == null ? this.createNewEntry(association.getName()) : embeddedPersister.createNewEntry(embeddedPersister.getEntityFamily());
        PersistentEntity persistentEntity = associatedEntity = embeddedPersister == null ? association.getAssociatedEntity() : embeddedPersister.getPersistentEntity();
        if (associatedEntity != null) {
            Object embeddedId;
            List<PersistentProperty> embeddedProperties = associatedEntity.getPersistentProperties();
            EntityAccess embeddedEntityAccess = this.createEntityAccess(associatedEntity, embeddedInstance);
            PersistentProperty identity = associatedEntity.getIdentity();
            if (identity != null && (embeddedId = embeddedEntityAccess.getProperty(identity.getName())) != null) {
                this.setEntryValue(embeddedEntry, this.getPropertyKey(identity), embeddedId);
            }
            for (PersistentProperty persistentProperty : embeddedProperties) {
                ManyToMany manyToMany;
                List<Serializable> keys;
                Collection associatedObjects;
                Object propValue;
                Association toOne;
                Association inverseSide;
                if (persistentProperty instanceof Simple) {
                    this.setEntryValue(embeddedEntry, this.getPropertyKey(persistentProperty), embeddedEntityAccess.getProperty(persistentProperty.getName()));
                    continue;
                }
                if (persistentProperty instanceof Custom) {
                    CustomTypeMarshaller customTypeMarshaller = ((Custom)persistentProperty).getCustomTypeMarshaller();
                    if (!customTypeMarshaller.supports(this.getSession().getDatastore())) continue;
                    customTypeMarshaller.write(persistentProperty, embeddedEntityAccess.getProperty(persistentProperty.getName()), embeddedEntry);
                    continue;
                }
                if (!(persistentProperty instanceof Association) || (inverseSide = ((Association)persistentProperty).getInverseSide()) instanceof Embedded || inverseSide instanceof EmbeddedCollection) continue;
                if (persistentProperty instanceof Embedded) {
                    toOne = (Association)persistentProperty;
                    this.handleEmbeddedToOne(toOne, this.getPropertyKey(persistentProperty), embeddedEntityAccess, embeddedEntry);
                    continue;
                }
                if (persistentProperty instanceof ToOne) {
                    Serializable id;
                    toOne = (Association)persistentProperty;
                    Object obj = embeddedEntityAccess.getProperty(toOne.getName());
                    Persister persister = this.getSession().getPersister(obj);
                    if (persister == null || (id = persister.persist(obj)) == null) continue;
                    this.setEntryValue(embeddedEntry, this.getPropertyKey(toOne), this.formulateDatabaseReference(embeddedPersister.getPersistentEntity(), association, id));
                    continue;
                }
                if (persistentProperty instanceof Basic) {
                    this.setEntryValue(embeddedEntry, this.getPropertyKey(persistentProperty), embeddedEntityAccess.getProperty(persistentProperty.getName()));
                    continue;
                }
                if (persistentProperty instanceof EmbeddedCollection) {
                    this.handleEmbeddedToMany(embeddedEntityAccess, embeddedEntry, persistentProperty, persistentProperty.getName());
                    continue;
                }
                if (persistentProperty instanceof OneToMany) {
                    OneToMany oneToMany = (OneToMany)persistentProperty;
                    propValue = embeddedEntityAccess.getProperty(oneToMany.getName());
                    if (!(propValue instanceof Collection)) continue;
                    associatedObjects = (Collection)propValue;
                    keys = this.session.persist(associatedObjects);
                    this.setEmbeddedCollectionKeys(oneToMany, embeddedEntityAccess, embeddedEntry, keys);
                    continue;
                }
                if (!(persistentProperty instanceof ManyToMany) || !((propValue = embeddedEntityAccess.getProperty((manyToMany = (ManyToMany)persistentProperty).getName())) instanceof Collection)) continue;
                associatedObjects = (Collection)propValue;
                keys = this.session.persist(associatedObjects);
                this.setManyToMany(embeddedPersister.getPersistentEntity(), embeddedInstance, embeddedEntry, manyToMany, associatedObjects, Collections.<Association, List<Serializable>>emptyMap());
            }
        }
        return embeddedEntry;
    }

    private void handleIndexing(boolean update, T e, Map<PersistentProperty, Object> toIndex, Map<PersistentProperty, Object> toUnindex, PersistentProperty prop, String key, boolean indexed, Object propValue) {
        if (!indexed) {
            return;
        }
        if (update) {
            boolean unindex;
            Object oldValue = this.getEntryValue(e, key);
            boolean bl = oldValue == null ? propValue != null : (unindex = !oldValue.equals(propValue));
            if (unindex) {
                toUnindex.put(prop, oldValue);
            }
        }
        toIndex.put(prop, propValue);
    }

    protected boolean isPropertyIndexed(Property mappedProperty) {
        return mappedProperty != null && mappedProperty.isIndex();
    }

    protected void setManyToMany(PersistentEntity persistentEntity, Object obj, T nativeEntry, ManyToMany manyToMany, Collection associatedObjects, Map<Association, List<Serializable>> toManyKeys) {
    }

    protected void setEmbedded(T nativeEntry, String key, T embeddedEntry) {
    }

    protected void setEmbeddedCollection(T nativeEntry, String key, Collection<?> instances, List<T> embeddedEntries) {
    }

    protected abstract K generateIdentifier(PersistentEntity var1, T var2);

    private void updateToManyIndices(T nativeEntry, Object identifier, Map<Association, List<Serializable>> toManyKeys) {
        for (Association association : toManyKeys.keySet()) {
            AssociationIndexer indexer;
            if (!association.doesCascade(CascadeType.PERSIST) || (indexer = this.getAssociationIndexer(nativeEntry, association)) == null) continue;
            indexer.index(identifier, toManyKeys.get(association));
        }
    }

    private void updatePropertyIndices(Object identifier, Map<PersistentProperty, Object> valuesToIndex, Map<PersistentProperty, Object> valuesToDeindex) {
        for (PersistentProperty persistentProperty : valuesToIndex.keySet()) {
            Object value = valuesToIndex.get(persistentProperty);
            PropertyValueIndexer indexer = this.getPropertyIndexer(persistentProperty);
            if (indexer == null) continue;
            indexer.index(value, identifier);
        }
        for (PersistentProperty persistentProperty : valuesToDeindex.keySet()) {
            PropertyValueIndexer indexer = this.getPropertyIndexer(persistentProperty);
            Object value = valuesToDeindex.get(persistentProperty);
            if (indexer == null) continue;
            indexer.deindex(value, identifier);
        }
    }

    public abstract PropertyValueIndexer getPropertyIndexer(PersistentProperty var1);

    public abstract AssociationIndexer getAssociationIndexer(T var1, Association var2);

    protected K readObjectIdentifier(EntityAccess entityAccess, ClassMapping cm) {
        return (K)entityAccess.getIdentifier();
    }

    protected String getIdentifierName(ClassMapping cm) {
        return cm.getIdentifier().getIdentifierName()[0];
    }

    @Override
    protected List<Serializable> persistEntities(PersistentEntity persistentEntity, Iterable objs) {
        ArrayList<Serializable> keys = new ArrayList<Serializable>();
        ArrayList newIter = objs;
        if (objs instanceof Collection) {
            newIter = new ArrayList(objs);
        }
        for (Object obj : newIter) {
            if (!persistentEntity.isInstance(obj)) continue;
            if (persistentEntity.getJavaClass().equals(obj.getClass())) {
                keys.add(this.persist(obj));
                continue;
            }
            EntityPersister persister = (EntityPersister)this.getSession().getPersister(obj);
            keys.add(persister.persist(obj));
        }
        return keys;
    }

    @Override
    protected List<Object> retrieveAllEntities(PersistentEntity persistentEntity, Iterable<Serializable> keys) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Serializable key : keys) {
            results.add(this.retrieveEntity(persistentEntity, key));
        }
        return results;
    }

    @Override
    protected List<Object> retrieveAllEntities(PersistentEntity persistentEntity, Serializable[] keys) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Serializable key : keys) {
            results.add(this.retrieveEntity(persistentEntity, key));
        }
        return results;
    }

    protected Object inferNativeKey(String family, Object identifier) {
        return identifier;
    }

    protected abstract T createNewEntry(String var1);

    protected abstract Object getEntryValue(T var1, String var2);

    protected abstract void setEntryValue(T var1, String var2, Object var3);

    protected abstract T retrieveEntry(PersistentEntity var1, String var2, Serializable var3);

    protected abstract K storeEntry(PersistentEntity var1, EntityAccess var2, K var3, T var4);

    protected abstract void updateEntry(PersistentEntity var1, EntityAccess var2, K var3, T var4);

    protected abstract void deleteEntries(String var1, List<K> var2);

    protected K executeInsert(PersistentEntity persistentEntity, NativeEntryModifyingEntityAccess entityAccess, K id, T e) {
        if (this.cancelInsert(persistentEntity, entityAccess)) {
            return null;
        }
        K newId = this.storeEntry(persistentEntity, entityAccess, id, e);
        entityAccess.setIdentifier(newId);
        this.updateTPCache(persistentEntity, e, (Serializable)newId);
        this.firePostInsertEvent(persistentEntity, entityAccess);
        return newId;
    }

    protected void updateTPCache(PersistentEntity persistentEntity, T e, Serializable id) {
        if (this.cacheAdapterRepository == null) {
            return;
        }
        TPCacheAdapter<T> cacheAdapter = this.cacheAdapterRepository.getTPCacheAdapter(persistentEntity);
        if (cacheAdapter != null) {
            cacheAdapter.cacheEntry(id, e);
        }
    }

    protected T getFromTPCache(PersistentEntity persistentEntity, Serializable id) {
        if (this.cacheAdapterRepository == null) {
            return null;
        }
        TPCacheAdapter<T> cacheAdapter = this.cacheAdapterRepository.getTPCacheAdapter(persistentEntity);
        if (cacheAdapter != null) {
            return cacheAdapter.getCachedEntry(id);
        }
        return null;
    }

    public boolean isDirty(Object instance, Object entry) {
        Object nativeEntry;
        if (instance == null) {
            return false;
        }
        if (entry == null) {
            return true;
        }
        try {
            nativeEntry = entry;
        }
        catch (ClassCastException ignored) {
            return false;
        }
        EntityAccess entityAccess = this.createEntityAccess(this.getPersistentEntity(), instance, nativeEntry);
        List<PersistentProperty> props = this.getPersistentEntity().getPersistentProperties();
        for (PersistentProperty prop : props) {
            String key = this.getPropertyKey(prop);
            Object currentValue = entityAccess.getProperty(prop.getName());
            Object oldValue = this.getEntryValue(nativeEntry, key);
            if (prop instanceof Simple || prop instanceof Basic || prop instanceof ToOne) {
                if (this.areEqual(oldValue, currentValue, key)) continue;
                return true;
            }
            if (prop instanceof OneToMany || prop instanceof ManyToMany) {
                if (this.areCollectionsEqual(oldValue, currentValue)) continue;
                return true;
            }
            if (prop instanceof EmbeddedCollection) {
                if (currentValue != null && oldValue == null) {
                    return true;
                }
                if (!(currentValue instanceof Collection) || !(oldValue instanceof Collection)) continue;
                Collection currentCollection = (Collection)currentValue;
                Collection oldCollection = (Collection)oldValue;
                if (currentCollection.size() != oldCollection.size()) {
                    return true;
                }
                if (this.areCollectionsEqual(oldValue, currentValue)) continue;
                return true;
            }
            if (prop instanceof Custom) {
                CustomTypeMarshaller marshaller = ((Custom)prop).getCustomTypeMarshaller();
                if (this.areEqual(marshaller.read(prop, entry), currentValue, key)) continue;
                return true;
            }
            throw new UnsupportedOperationException("dirty not detected for property " + prop.toString() + " " + prop.getClass().getSuperclass().toString());
        }
        return false;
    }

    protected String getPropertyKey(PersistentProperty prop) {
        PropertyMapping pm = prop.getMapping();
        Property mappedProperty = (Property)pm.getMappedForm();
        String key = null;
        if (mappedProperty != null) {
            key = mappedProperty.getTargetName();
        }
        if (key == null) {
            key = prop.getName();
        }
        return key;
    }

    protected boolean areCollectionsEqual(Object oldValue, Object currentValue) {
        if (oldValue == currentValue) {
            return true;
        }
        if (currentValue instanceof PersistentCollection) {
            return !((PersistentCollection)currentValue).isDirty();
        }
        return this.replaceNullOrUninitialized(oldValue, currentValue).equals(this.replaceNullOrUninitialized(currentValue, oldValue));
    }

    private Object replaceNullOrUninitialized(Object c, Object other) {
        if (c == null) {
            if (other instanceof Set) {
                return Collections.emptySet();
            }
            return Collections.emptyList();
        }
        if (c instanceof PersistentCollection && !((PersistentCollection)c).isInitialized()) {
            if (c instanceof Set) {
                return Collections.emptySet();
            }
            return Collections.emptyList();
        }
        return c;
    }

    protected boolean areEqual(Object oldValue, Object currentValue, String propName) {
        Class<?> oldValueClass;
        if (oldValue == currentValue) {
            return true;
        }
        if (oldValue == null || currentValue == null) {
            return false;
        }
        if ("version".equals(propName)) {
            if (oldValue instanceof Number && currentValue instanceof Number) {
                oldValue = ((Number)oldValue).longValue();
                currentValue = ((Number)currentValue).longValue();
            } else {
                oldValue = oldValue.toString();
                currentValue = currentValue.toString();
            }
        }
        if (!(oldValueClass = oldValue.getClass()).isArray()) {
            if (oldValue instanceof Float) {
                return Float.floatToIntBits(((Float)oldValue).floatValue()) == Float.floatToIntBits(((Float)currentValue).floatValue());
            }
            if (oldValue instanceof Double) {
                return Double.doubleToLongBits((Double)oldValue) == Double.doubleToLongBits((Double)currentValue);
            }
            return oldValue.equals(currentValue);
        }
        if (oldValue.getClass() != currentValue.getClass()) {
            return false;
        }
        if (oldValue instanceof long[]) {
            return Arrays.equals((long[])oldValue, (long[])currentValue);
        }
        if (oldValue instanceof int[]) {
            return Arrays.equals((int[])oldValue, (int[])currentValue);
        }
        if (oldValue instanceof short[]) {
            return Arrays.equals((short[])oldValue, (short[])currentValue);
        }
        if (oldValue instanceof char[]) {
            return Arrays.equals((char[])oldValue, (char[])currentValue);
        }
        if (oldValue instanceof byte[]) {
            return Arrays.equals((byte[])oldValue, (byte[])currentValue);
        }
        if (oldValue instanceof double[]) {
            return Arrays.equals((double[])oldValue, (double[])currentValue);
        }
        if (oldValue instanceof float[]) {
            return Arrays.equals((float[])oldValue, (float[])currentValue);
        }
        if (oldValue instanceof boolean[]) {
            return Arrays.equals((boolean[])oldValue, (boolean[])currentValue);
        }
        return Arrays.equals((Object[])oldValue, (Object[])currentValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NativeEntryModifyingEntityAccess
    extends EntityAccess {
        T nativeEntry;
        private Map<PersistentProperty, Object> toIndex;

        public NativeEntryModifyingEntityAccess(PersistentEntity persistentEntity, Object entity) {
            super(persistentEntity, entity);
        }

        @Override
        public void setProperty(String name, Object value) {
            super.setProperty(name, value);
            if (this.nativeEntry != null) {
                PropertyMapping pm;
                PersistentProperty property = this.persistentEntity.getPropertyByName(name);
                if (property != null && (property instanceof Simple || property instanceof Basic)) {
                    NativeEntryEntityPersister.this.setEntryValue(this.nativeEntry, name, value);
                }
                if (this.toIndex != null && property != null && (pm = property.getMapping()) != null && NativeEntryEntityPersister.this.isPropertyIndexed((Property)pm.getMappedForm())) {
                    if (property instanceof ToOne) {
                        NativeEntryEntityPersister associationPersister;
                        ToOne association = (ToOne)property;
                        if (!association.isForeignKeyInChild() && (associationPersister = (NativeEntryEntityPersister)NativeEntryEntityPersister.this.session.getPersister(value)) != null) {
                            if (value == null) {
                                this.toIndex.put(property, null);
                            } else {
                                this.toIndex.put(property, associationPersister.getObjectIdentifier(value));
                            }
                        }
                    } else {
                        this.toIndex.put(property, value);
                    }
                }
            }
        }

        public void setNativeEntry(T nativeEntry) {
            this.nativeEntry = nativeEntry;
        }

        public void setToIndex(Map<PersistentProperty, Object> toIndex) {
            this.toIndex = toIndex;
        }
    }
}

