/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.engine.event.PostDeleteEvent;
import org.grails.datastore.mapping.engine.event.PostInsertEvent;
import org.grails.datastore.mapping.engine.event.PostLoadEvent;
import org.grails.datastore.mapping.engine.event.PostUpdateEvent;
import org.grails.datastore.mapping.engine.event.PreDeleteEvent;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreLoadEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityPersister
implements Persister {
    private PersistentEntity persistentEntity;
    private MappingContext mappingContext;
    protected Session session;
    protected ProxyFactory proxyFactory;
    protected ApplicationEventPublisher publisher;

    public EntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher) {
        this.persistentEntity = entity;
        this.mappingContext = mappingContext;
        this.session = session;
        this.publisher = publisher;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public Object proxy(Serializable key) {
        return this.getProxyFactory().createProxy(this.session, this.getPersistentEntity().getJavaClass(), key);
    }

    public ProxyFactory getProxyFactory() {
        if (this.proxyFactory == null) {
            this.proxyFactory = this.mappingContext.getProxyFactory();
        }
        return this.proxyFactory;
    }

    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    public PersistentEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    @Override
    public Class getType() {
        return this.persistentEntity.getJavaClass();
    }

    @Override
    public Serializable getObjectIdentifier(Object obj) {
        if (obj == null) {
            return null;
        }
        ProxyFactory pf = this.getProxyFactory();
        if (pf.isProxy(obj)) {
            return pf.getIdentifier(obj);
        }
        return (Serializable)new EntityAccess(this.getPersistentEntity(), obj).getIdentifier();
    }

    public void setObjectIdentifier(Object obj, Serializable id) {
        new EntityAccess(this.getPersistentEntity(), obj).setIdentifier(id);
    }

    @Override
    public final Serializable persist(Object obj) {
        if (!this.persistentEntity.isInstance(obj)) {
            Persister persister = this.getSession().getPersister(obj);
            if (persister == null) {
                throw new IllegalArgumentException("Object [" + obj + "] is not an instance supported by the persister for class [" + this.getType().getName() + "]");
            }
            return persister.persist(obj);
        }
        return this.persistEntity(this.getPersistentEntity(), obj);
    }

    @Override
    public List<Serializable> persist(Iterable objs) {
        return this.persistEntities(this.getPersistentEntity(), objs);
    }

    @Override
    public List<Object> retrieveAll(Iterable<Serializable> keys) {
        return this.retrieveAllEntities(this.getPersistentEntity(), keys);
    }

    @Override
    public List<Object> retrieveAll(Serializable[] keys) {
        return this.retrieveAllEntities(this.getPersistentEntity(), keys);
    }

    protected abstract List<Object> retrieveAllEntities(PersistentEntity var1, Serializable[] var2);

    protected abstract List<Object> retrieveAllEntities(PersistentEntity var1, Iterable<Serializable> var2);

    protected abstract List<Serializable> persistEntities(PersistentEntity var1, Iterable var2);

    @Override
    public final Object retrieve(Serializable key) {
        if (key == null) {
            return null;
        }
        PersistentEntity entity = this.getPersistentEntity();
        Object o = this.retrieveEntity(entity, key);
        if (o == null) {
            return null;
        }
        return o;
    }

    protected abstract Object retrieveEntity(PersistentEntity var1, Serializable var2);

    protected abstract Serializable persistEntity(PersistentEntity var1, Object var2);

    @Override
    public final void delete(Iterable objects) {
        if (objects == null) {
            return;
        }
        this.deleteEntities(this.getPersistentEntity(), objects);
    }

    @Override
    public void delete(Object obj) {
        if (obj == null) {
            return;
        }
        this.deleteEntity(this.getPersistentEntity(), obj);
    }

    protected abstract void deleteEntity(PersistentEntity var1, Object var2);

    protected abstract void deleteEntities(PersistentEntity var1, Iterable var2);

    protected EntityAccess createEntityAccess(PersistentEntity pe, Object obj) {
        return new EntityAccess(this.persistentEntity, obj);
    }

    protected Object newEntityInstance(PersistentEntity persistentEntity) {
        Object o = persistentEntity.newInstance();
        this.publisher.publishEvent((ApplicationEvent)new PreLoadEvent(this.session.getDatastore(), this.getPersistentEntity(), new EntityAccess(persistentEntity, o)));
        return o;
    }

    public boolean cancelInsert(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        PreInsertEvent event = new PreInsertEvent(this.session.getDatastore(), persistentEntity, entityAccess);
        this.publisher.publishEvent((ApplicationEvent)event);
        return event.isCancelled();
    }

    public void firePostInsertEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PostInsertEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    public boolean cancelUpdate(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        PreUpdateEvent event = new PreUpdateEvent(this.session.getDatastore(), persistentEntity, entityAccess);
        this.publisher.publishEvent((ApplicationEvent)event);
        return event.isCancelled();
    }

    public boolean cancelDelete(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        PreDeleteEvent event = new PreDeleteEvent(this.session.getDatastore(), persistentEntity, entityAccess);
        this.publisher.publishEvent((ApplicationEvent)event);
        return event.isCancelled();
    }

    public void firePostUpdateEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PostUpdateEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    public void firePostDeleteEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PostDeleteEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    public void firePreLoadEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PreLoadEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    public void firePostLoadEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PostLoadEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    protected boolean isVersioned(EntityAccess ea) {
        if (!ea.getPersistentEntity().isVersioned()) {
            return false;
        }
        Class type = ea.getPropertyType("version");
        return Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type);
    }

    protected void incrementVersion(EntityAccess ea) {
        if (Number.class.isAssignableFrom(ea.getPropertyType("version"))) {
            Number currentVersion = (Number)ea.getProperty("version");
            if (currentVersion == null) {
                currentVersion = 0L;
            }
            ea.setProperty("version", currentVersion.longValue() + 1L);
        } else {
            this.setDateVersion(ea);
        }
    }

    protected void setVersion(EntityAccess ea) {
        if (Number.class.isAssignableFrom(ea.getPropertyType("version"))) {
            ea.setProperty("version", 0);
        } else {
            this.setDateVersion(ea);
        }
    }

    protected void setDateVersion(EntityAccess ea) {
        if (Timestamp.class.isAssignableFrom(ea.getPropertyType("version"))) {
            ea.setProperty("version", new Timestamp(System.currentTimeMillis()));
        } else {
            ea.setProperty("version", new Date());
        }
    }
}

