/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.document.config;

import groovy.lang.Closure;
import org.grails.datastore.mapping.document.config.Attribute;
import org.grails.datastore.mapping.document.config.Collection;
import org.grails.datastore.mapping.document.config.DocumentPersistentEntity;
import org.grails.datastore.mapping.document.config.GormDocumentMappingFactory;
import org.grails.datastore.mapping.model.AbstractMappingContext;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.GormMappingConfigurationStrategy;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentMappingContext
extends AbstractMappingContext {
    String defaultDatabaseName;
    MappingFactory<Collection, Attribute> mappingFactory;
    private MappingConfigurationStrategy syntaxStrategy;
    private Closure defaultMapping;

    public DocumentMappingContext(String defaultDatabaseName) {
        Assert.notNull((Object)defaultDatabaseName, (String)"Argument [defaultDatabaseName] cannot be null");
        this.defaultDatabaseName = defaultDatabaseName;
        this.mappingFactory = this.createDocumentMappingFactory(null);
        this.syntaxStrategy = new GormMappingConfigurationStrategy(this.mappingFactory);
    }

    public DocumentMappingContext(String defaultDatabaseName, Closure defaultMapping) {
        Assert.notNull((Object)defaultDatabaseName, (String)"Argument [defaultDatabaseName] cannot be null");
        this.defaultDatabaseName = defaultDatabaseName;
        this.mappingFactory = this.createDocumentMappingFactory(defaultMapping);
        this.defaultMapping = defaultMapping;
        this.syntaxStrategy = new GormMappingConfigurationStrategy(this.mappingFactory);
    }

    public Closure getDefaultMapping() {
        return this.defaultMapping;
    }

    protected MappingFactory createDocumentMappingFactory(Closure defaultMapping) {
        return new GormDocumentMappingFactory();
    }

    public String getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    @Override
    public MappingConfigurationStrategy getMappingSyntaxStrategy() {
        return this.syntaxStrategy;
    }

    @Override
    public MappingFactory<Collection, Attribute> getMappingFactory() {
        return this.mappingFactory;
    }

    @Override
    protected PersistentEntity createPersistentEntity(Class javaClass) {
        return new DocumentPersistentEntity(javaClass, this);
    }
}

