/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.grails.datastore.mapping.cache.TPCacheAdapterRepository;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.ConnectionNotFoundException;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionCreationEvent;
import org.grails.datastore.mapping.core.SoftThreadLocalMap;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.BasicTypeConverterRegistrar;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.grails.datastore.mapping.validation.ValidatingEventListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.validation.Errors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatastore
implements Datastore,
DisposableBean {
    private ApplicationContext applicationContext;
    private static final SoftThreadLocalMap ERRORS_MAP = new SoftThreadLocalMap();
    private static final SoftThreadLocalMap VALIDATE_MAP = new SoftThreadLocalMap();
    protected MappingContext mappingContext;
    protected Map<String, String> connectionDetails = Collections.emptyMap();
    protected TPCacheAdapterRepository cacheAdapterRepository;

    public AbstractDatastore() {
    }

    public AbstractDatastore(MappingContext mappingContext) {
        this(mappingContext, null, null);
    }

    public AbstractDatastore(MappingContext mappingContext, Map<String, String> connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx, null);
    }

    public AbstractDatastore(MappingContext mappingContext, Map<String, String> connectionDetails, ConfigurableApplicationContext ctx, TPCacheAdapterRepository cacheAdapterRepository) {
        this.mappingContext = mappingContext;
        this.connectionDetails = connectionDetails != null ? connectionDetails : Collections.emptyMap();
        this.setApplicationContext(ctx);
        this.cacheAdapterRepository = cacheAdapterRepository;
    }

    public void destroy() throws Exception {
        ERRORS_MAP.remove();
        VALIDATE_MAP.remove();
    }

    public void setApplicationContext(ConfigurableApplicationContext ctx) {
        this.applicationContext = ctx;
        if (ctx != null && this.registerValidationListener()) {
            ctx.addApplicationListener((ApplicationListener)new ValidatingEventListener(this));
        }
    }

    protected boolean registerValidationListener() {
        return true;
    }

    public void setConnectionDetails(Map<String, String> connectionDetails) {
        this.connectionDetails = connectionDetails;
    }

    @Override
    public Session connect() {
        return this.connect(this.connectionDetails);
    }

    public final Session connect(Map<String, String> connDetails) {
        Session session = this.createSession(connDetails);
        ApplicationEventPublisher applicationEventPublisher = this.getApplicationEventPublisher();
        if (applicationEventPublisher != null) {
            applicationEventPublisher.publishEvent((ApplicationEvent)new SessionCreationEvent(session));
        }
        return session;
    }

    protected abstract Session createSession(Map<String, String> var1);

    @Override
    public Session getCurrentSession() throws ConnectionNotFoundException {
        return DatastoreUtils.doGetSession(this, false);
    }

    @Override
    public boolean hasCurrentSession() {
        return TransactionSynchronizationManager.hasResource((Object)this);
    }

    public static Session retrieveSession() throws ConnectionNotFoundException {
        return AbstractDatastore.retrieveSession(Datastore.class);
    }

    public static Session retrieveSession(Class datastoreClass) throws ConnectionNotFoundException {
        Map resourceMap = TransactionSynchronizationManager.getResourceMap();
        Session session = null;
        if (resourceMap != null && !resourceMap.isEmpty()) {
            for (Object key : resourceMap.keySet()) {
                SessionHolder sessionHolder;
                if (!datastoreClass.isInstance(key) || (sessionHolder = (SessionHolder)((Object)resourceMap.get(key))) == null) continue;
                session = sessionHolder.getSession();
            }
        }
        if (session == null) {
            throw new ConnectionNotFoundException("Not datastore session found. Call Datastore.connect(..) before calling Datastore.getCurrentSession()");
        }
        return session;
    }

    @Override
    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public ConfigurableApplicationContext getApplicationContext() {
        return (ConfigurableApplicationContext)this.applicationContext;
    }

    @Override
    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.getApplicationContext();
    }

    @Override
    public Errors getObjectErrors(Object o) {
        return AbstractDatastore.getValidationErrorsMap().get(o);
    }

    @Override
    public void setObjectErrors(Object object, Errors errors) {
        AbstractDatastore.getValidationErrorsMap().put(object, errors);
    }

    @Override
    public void setSkipValidation(Object o, boolean skip) {
        ((ReferenceMap)VALIDATE_MAP.get()).put(o, (Object)skip);
    }

    @Override
    public boolean skipValidation(Object o) {
        Object skipValidation = ((ReferenceMap)VALIDATE_MAP.get()).get(o);
        return skipValidation instanceof Boolean && (Boolean)skipValidation != false;
    }

    public static Map<Object, Errors> getValidationErrorsMap() {
        return (Map)ERRORS_MAP.get();
    }

    public static Map<Object, Boolean> getValidationSkipMap() {
        return (Map)VALIDATE_MAP.get();
    }

    protected void initializeConverters(MappingContext mappingContext) {
        ConverterRegistry conversionService = mappingContext.getConverterRegistry();
        BasicTypeConverterRegistrar registrar = new BasicTypeConverterRegistrar();
        registrar.register(conversionService);
    }

    protected boolean isIndexed(PersistentProperty property) {
        PropertyMapping pm = property.getMapping();
        Property keyValue = (Property)pm.getMappedForm();
        return keyValue != null && keyValue.isIndex();
    }

    @Override
    public boolean isSchemaless() {
        return false;
    }
}

