/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.context.annotation;

import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.Metadata;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ComponentScanBeanDefinitionParser;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.w3c.dom.Element;

public class ClosureClassIgnoringComponentScanBeanDefinitionParser
extends ComponentScanBeanDefinitionParser {
    private static final Log LOG = LogFactory.getLog(ClosureClassIgnoringComponentScanBeanDefinitionParser.class);

    protected ClassPathBeanDefinitionScanner createScanner(XmlReaderContext readerContext, boolean useDefaultFilters) {
        HierarchicalBeanFactory beanFactory;
        BeanFactory parent;
        ClassPathBeanDefinitionScanner scanner = super.createScanner(readerContext, useDefaultFilters);
        BeanDefinitionRegistry beanDefinitionRegistry = readerContext.getRegistry();
        GrailsPluginManager pluginManager = null;
        if (beanDefinitionRegistry instanceof HierarchicalBeanFactory && (parent = (beanFactory = (HierarchicalBeanFactory)beanDefinitionRegistry).getParentBeanFactory()) != null && parent.containsBean("pluginManager")) {
            pluginManager = (GrailsPluginManager)parent.getBean("pluginManager", GrailsPluginManager.class);
        }
        if (pluginManager != null) {
            List<TypeFilter> typeFilters = pluginManager.getTypeFilters();
            for (TypeFilter typeFilter : typeFilters) {
                scanner.addIncludeFilter(typeFilter);
            }
        }
        return scanner;
    }

    protected ClassPathBeanDefinitionScanner configureScanner(ParserContext parserContext, Element element) {
        ResourceLoader parentOnlyResourceLoader;
        ClassPathBeanDefinitionScanner scanner = super.configureScanner(parserContext, element);
        final ResourceLoader originalResourceLoader = parserContext.getReaderContext().getResourceLoader();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scanning only this classloader:" + originalResourceLoader.getClassLoader()));
        }
        try {
            parentOnlyResourceLoader = new ResourceLoader(){
                ClassLoader parentOnlyGetResourcesClassLoader;
                {
                    this.parentOnlyGetResourcesClassLoader = new ParentOnlyGetResourcesClassLoader(originalResourceLoader.getClassLoader());
                }

                public Resource getResource(String location) {
                    return originalResourceLoader.getResource(location);
                }

                public ClassLoader getClassLoader() {
                    return this.parentOnlyGetResourcesClassLoader;
                }
            };
        }
        catch (Throwable t) {
            parentOnlyResourceLoader = originalResourceLoader;
        }
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(parentOnlyResourceLoader){

            protected Resource[] findAllClassPathResources(String location) throws IOException {
                String path;
                BuildSettings buildSettings;
                LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
                URL classesDir = null;
                boolean warDeployed = Metadata.getCurrent().isWarDeployed();
                if (!warDeployed && (buildSettings = BuildSettingsHolder.getSettings()) != null && buildSettings.getClassesDir() != null) {
                    classesDir = buildSettings.getClassesDir().toURI().toURL();
                }
                if ((path = location).startsWith("/")) {
                    path = path.substring(1);
                }
                Enumeration<URL> resourceUrls = this.getClassLoader().getResources(path);
                while (resourceUrls.hasMoreElements()) {
                    URL url = resourceUrls.nextElement();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Scanning URL " + url.toExternalForm() + " while searching for '" + location + "'"));
                    }
                    result.add(this.convertClassLoaderURL(url));
                }
                return result.toArray(new Resource[result.size()]);
            }
        };
        resourceResolver.setPathMatcher((PathMatcher)new AntPathMatcher(){

            public boolean match(String pattern, String path) {
                String filename;
                if (path.endsWith(".class") && (filename = FilenameUtils.getBaseName((String)path)).indexOf("$") > -1) {
                    return false;
                }
                return super.match(pattern, path);
            }
        });
        scanner.setResourceLoader((ResourceLoader)resourceResolver);
        return scanner;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ParentOnlyGetResourcesClassLoader
    extends ClassLoader {
        private final Method findResourcesMethod = ReflectionUtils.findMethod(ClassLoader.class, (String)"findResources", (Class[])new Class[]{String.class});
        private final Method findResourceMethod = ReflectionUtils.findMethod(ClassLoader.class, (String)"findResource", (Class[])new Class[]{String.class});
        private ClassLoader rootLoader;

        public ParentOnlyGetResourcesClassLoader(ClassLoader parent) {
            super(parent);
            this.rootLoader = DefaultGroovyMethods.getRootLoader((ClassLoader)parent);
            ReflectionUtils.makeAccessible((Method)this.findResourceMethod);
            ReflectionUtils.makeAccessible((Method)this.findResourcesMethod);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (this.rootLoader != null) {
                LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
                this.findResourcesRecursive(this.getParent(), name, urls);
                return Collections.enumeration(urls);
            }
            return this.invokeFindResources(this.getParent(), name);
        }

        private void findResourcesRecursive(ClassLoader parent, String name, Collection<URL> urls) {
            Enumeration<URL> result = this.invokeFindResources(parent, name);
            while (result.hasMoreElements()) {
                urls.add(result.nextElement());
            }
            if (parent != this.rootLoader) {
                this.findResourcesRecursive(parent.getParent(), name, urls);
            }
        }

        private Enumeration<URL> invokeFindResources(ClassLoader parent, String name) {
            return (Enumeration)ReflectionUtils.invokeMethod((Method)this.findResourcesMethod, (Object)parent, (Object[])new Object[]{name});
        }

        @Override
        public URL getResource(String name) {
            if (this.rootLoader != null) {
                return this.findResourceRecursive(this.getParent(), name);
            }
            return this.invokeFindResource(this.getParent(), name);
        }

        private URL findResourceRecursive(ClassLoader parent, String name) {
            URL url = this.invokeFindResource(parent, name);
            if (url != null) {
                return url;
            }
            if (parent != this.rootLoader) {
                return this.findResourceRecursive(parent.getParent(), name);
            }
            return null;
        }

        private URL invokeFindResource(ClassLoader parent, String name) {
            return (URL)ReflectionUtils.invokeMethod((Method)this.findResourceMethod, (Object)parent, (Object[])new Object[]{name});
        }
    }
}

