/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.util.PluginBuildSettings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AllArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.metadata.GrailsPlugin;

@AstTransformer
public class PluginAwareAstTransformer
implements AllArtefactClassInjector {
    PluginBuildSettings pluginBuildSettings = GrailsPluginUtils.getPluginBuildSettings();

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        File sourcePath = new File(source.getName());
        try {
            String absolutePath = sourcePath.getCanonicalPath();
            if (this.pluginBuildSettings == null) {
                return;
            }
            GrailsPluginInfo info = this.pluginBuildSettings.getPluginInfoForSource(absolutePath);
            if (info == null) {
                return;
            }
            ClassNode annotation = new ClassNode(GrailsPlugin.class);
            List list = classNode.getAnnotations(annotation);
            if (!list.isEmpty()) {
                return;
            }
            if (classNode.isAnnotationDefinition()) {
                return;
            }
            AnnotationNode annotationNode = new AnnotationNode(annotation);
            annotationNode.addMember("name", (Expression)new ConstantExpression((Object)info.getName()));
            annotationNode.addMember("version", (Expression)new ConstantExpression((Object)info.getVersion()));
            annotationNode.setRuntimeRetention(true);
            annotationNode.setClassRetention(true);
            classNode.addAnnotation(annotationNode);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    public boolean shouldInject(URL url) {
        return true;
    }
}

