/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import grails.util.Environment;
import java.util.Map;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsControllerClass;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.springframework.context.ApplicationContext;

public class ControllerArtefactHandler
extends ArtefactHandlerAdapter
implements GrailsApplicationAware {
    private static final String URL_MAPPING_CACHE_MAX_SIZE = "grails.urlmapping.cache.maxsize";
    private static final GrailsClass NO_CONTROLLER = new AbstractGrailsClass((Class)Object.class, "Controller"){};
    public static final String TYPE = "Controller";
    public static final String PLUGIN_NAME = "controllers";
    private ConcurrentLinkedHashMap<String, GrailsClass> uriToControllerClassCache;
    private ArtefactInfo artefactInfo;
    private GrailsApplication grailsApplication;

    public ControllerArtefactHandler() {
        super(TYPE, GrailsControllerClass.class, DefaultGrailsControllerClass.class, TYPE, false);
    }

    public void initialize(ArtefactInfo artefacts) {
        Object cacheSize = this.grailsApplication.getFlatConfig().get(URL_MAPPING_CACHE_MAX_SIZE);
        if (cacheSize == null) {
            cacheSize = 10000;
        }
        this.uriToControllerClassCache = new ConcurrentLinkedHashMap.Builder().initialCapacity(500).maximumWeightedCapacity((long)new Integer(cacheSize.toString()).intValue()).build();
        this.artefactInfo = artefacts;
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public GrailsClass getArtefactForFeature(Object featureId) {
        if (this.artefactInfo == null) {
            return null;
        }
        String uri = null;
        String pluginName = null;
        if (featureId instanceof Map) {
            Map featureIdMap = (Map)featureId;
            uri = (String)featureIdMap.get("uri");
            pluginName = (String)featureIdMap.get("pluginName");
        } else {
            uri = featureId.toString();
        }
        String cacheKey = (pluginName != null ? pluginName : "") + ":" + uri;
        GrailsClass controllerClass = (GrailsClass)this.uriToControllerClassCache.get((Object)cacheKey);
        if (controllerClass == null) {
            Object pluginManagerBean;
            ApplicationContext mainContext = this.grailsApplication.getMainContext();
            GrailsPluginManager grailsPluginManager = null;
            if (mainContext.containsBean("pluginManager") && (pluginManagerBean = mainContext.getBean("pluginManager")) instanceof GrailsPluginManager) {
                grailsPluginManager = (GrailsPluginManager)pluginManagerBean;
            }
            GrailsClass[] controllerClasses = this.artefactInfo.getGrailsClasses();
            for (int i = controllerClasses.length - 1; i >= 0; --i) {
                GrailsClass c = controllerClasses[i];
                if (!((GrailsControllerClass)c).mapsToURI(uri)) continue;
                boolean foundController = false;
                if (pluginName != null && grailsPluginManager != null) {
                    GrailsPlugin pluginForClass = grailsPluginManager.getPluginForClass(c.getClazz());
                    if (pluginForClass != null && pluginName.equals(pluginForClass.getName())) {
                        foundController = true;
                    }
                } else {
                    foundController = true;
                }
                if (!foundController) continue;
                controllerClass = c;
                break;
            }
            if (controllerClass == null) {
                controllerClass = NO_CONTROLLER;
            }
            if (Environment.getCurrent() != Environment.DEVELOPMENT) {
                this.uriToControllerClassCache.put((Object)cacheKey, (Object)controllerClass);
            }
        }
        if (controllerClass == NO_CONTROLLER) {
            controllerClass = null;
        }
        return controllerClass;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

