/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;

final class ScorerPriorityQueue
implements Iterable<ScorerWrapper> {
    private final ScorerWrapper[] heap;
    private int size;

    static int leftNode(int node) {
        return (node + 1 << 1) - 1;
    }

    static int rightNode(int leftNode) {
        return leftNode + 1;
    }

    static int parentNode(int node) {
        return (node + 1 >>> 1) - 1;
    }

    ScorerPriorityQueue(int maxSize) {
        this.heap = new ScorerWrapper[maxSize];
        this.size = 0;
    }

    int size() {
        return this.size;
    }

    ScorerWrapper top() {
        return this.heap[0];
    }

    ScorerWrapper topList() {
        ScorerWrapper[] heap = this.heap;
        int size = this.size;
        ScorerWrapper list = heap[0];
        list.next = null;
        if (size >= 3) {
            list = ScorerPriorityQueue.topList(list, heap, size, 1);
            list = ScorerPriorityQueue.topList(list, heap, size, 2);
        } else if (size == 2 && heap[1].doc == list.doc) {
            list = ScorerPriorityQueue.prepend(heap[1], list);
        }
        return list;
    }

    private static ScorerWrapper prepend(ScorerWrapper w1, ScorerWrapper w2) {
        w1.next = w2;
        return w1;
    }

    private static ScorerWrapper topList(ScorerWrapper list, ScorerWrapper[] heap, int size, int i) {
        ScorerWrapper w = heap[i];
        if (w.doc == list.doc) {
            list = ScorerPriorityQueue.prepend(w, list);
            int left = ScorerPriorityQueue.leftNode(i);
            int right = left + 1;
            if (right < size) {
                list = ScorerPriorityQueue.topList(list, heap, size, left);
                list = ScorerPriorityQueue.topList(list, heap, size, right);
            } else if (left < size && heap[left].doc == list.doc) {
                list = ScorerPriorityQueue.prepend(heap[left], list);
            }
        }
        return list;
    }

    ScorerWrapper add(ScorerWrapper entry) {
        ScorerWrapper[] heap = this.heap;
        int size = this.size;
        heap[size] = entry;
        ScorerPriorityQueue.upHeap(heap, size);
        this.size = size + 1;
        return heap[0];
    }

    ScorerWrapper pop() {
        ScorerWrapper[] heap = this.heap;
        ScorerWrapper result = heap[0];
        int i = --this.size;
        heap[0] = heap[i];
        heap[i] = null;
        ScorerPriorityQueue.downHeap(heap, i);
        return result;
    }

    ScorerWrapper updateTop() {
        ScorerPriorityQueue.downHeap(this.heap, this.size);
        return this.heap[0];
    }

    ScorerWrapper updateTop(ScorerWrapper topReplacement) {
        this.heap[0] = topReplacement;
        return this.updateTop();
    }

    static void upHeap(ScorerWrapper[] heap, int i) {
        ScorerWrapper node = heap[i];
        int nodeDoc = node.doc;
        int j = ScorerPriorityQueue.parentNode(i);
        while (j >= 0 && nodeDoc < heap[j].doc) {
            heap[i] = heap[j];
            i = j;
            j = ScorerPriorityQueue.parentNode(j);
        }
        heap[i] = node;
    }

    static void downHeap(ScorerWrapper[] heap, int size) {
        int i = 0;
        ScorerWrapper node = heap[0];
        int j = ScorerPriorityQueue.leftNode(i);
        if (j < size) {
            int k = ScorerPriorityQueue.rightNode(j);
            if (k < size && heap[k].doc < heap[j].doc) {
                j = k;
            }
            if (heap[j].doc < node.doc) {
                do {
                    heap[i] = heap[j];
                    i = j;
                    k = ScorerPriorityQueue.rightNode(j = ScorerPriorityQueue.leftNode(i));
                    if (k >= size || heap[k].doc >= heap[j].doc) continue;
                    j = k;
                } while (j < size && heap[j].doc < node.doc);
                heap[i] = node;
            }
        }
    }

    @Override
    public Iterator<ScorerWrapper> iterator() {
        return Arrays.asList(this.heap).subList(0, this.size).iterator();
    }

    static class ScorerWrapper {
        final Scorer scorer;
        final long cost;
        int doc;
        ScorerWrapper next;
        final DocIdSetIterator approximation;
        final TwoPhaseIterator twoPhaseView;

        ScorerWrapper(Scorer scorer) {
            this.scorer = scorer;
            this.cost = scorer.cost();
            this.doc = -1;
            this.twoPhaseView = scorer.asTwoPhaseIterator();
            this.approximation = this.twoPhaseView != null ? this.twoPhaseView.approximation() : scorer;
        }
    }
}

