/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Query;

public interface QueryCachingPolicy {
    public static final QueryCachingPolicy ALWAYS_CACHE = new QueryCachingPolicy(){

        @Override
        public void onUse(Query query) {
        }

        @Override
        public boolean shouldCache(Query query, LeafReaderContext context) throws IOException {
            return true;
        }
    };

    public void onUse(Query var1);

    public boolean shouldCache(Query var1, LeafReaderContext var2) throws IOException;

    public static class CacheOnLargeSegments
    implements QueryCachingPolicy {
        public static final CacheOnLargeSegments DEFAULT = new CacheOnLargeSegments(0.03f);
        private final float minSizeRatio;

        public CacheOnLargeSegments(float minSizeRatio) {
            if (minSizeRatio <= 0.0f || minSizeRatio >= 1.0f) {
                throw new IllegalArgumentException("minSizeRatio must be in ]0, 1[, got " + minSizeRatio);
            }
            this.minSizeRatio = minSizeRatio;
        }

        @Override
        public void onUse(Query query) {
        }

        @Override
        public boolean shouldCache(Query query, LeafReaderContext context) throws IOException {
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(context);
            float sizeRatio = (float)context.reader().maxDoc() / (float)topLevelContext.reader().maxDoc();
            return sizeRatio >= this.minSizeRatio;
        }
    }
}

