/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;

final class MultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends Query {
    protected final Q query;

    protected MultiTermQueryConstantScoreWrapper(Q query) {
        this.query = query;
    }

    @Override
    public String toString(String field) {
        return ((Query)this.query).toString(field);
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass().equals(o.getClass())) {
            MultiTermQueryConstantScoreWrapper that = (MultiTermQueryConstantScoreWrapper)o;
            return ((MultiTermQuery)this.query).equals(that.query) && this.getBoost() == that.getBoost();
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.getClass(), this.query, Float.valueOf(this.getBoost()));
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    public final String getField() {
        return ((MultiTermQuery)this.query).getField();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            Scorer scorer(LeafReaderContext context, Bits acceptDocs, final float score) throws IOException {
                Terms terms = context.reader().terms(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field);
                if (terms == null) {
                    return null;
                }
                TermsEnum termsEnum = ((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).getTermsEnum(terms);
                assert (termsEnum != null);
                BitDocIdSet.Builder builder = new BitDocIdSet.Builder(context.reader().maxDoc());
                PostingsEnum docs = null;
                while (termsEnum.next() != null) {
                    docs = termsEnum.postings(acceptDocs, docs, 0);
                    builder.or(docs);
                }
                BitDocIdSet set = builder.build();
                if (set == null) {
                    return null;
                }
                final DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                return new Scorer(this){

                    @Override
                    public float score() throws IOException {
                        return score;
                    }

                    @Override
                    public int freq() throws IOException {
                        return 1;
                    }

                    @Override
                    public int docID() {
                        return disi.docID();
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return disi.nextDoc();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        return disi.advance(target);
                    }

                    @Override
                    public long cost() {
                        return disi.cost();
                    }
                };
            }
        };
    }
}

