/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public abstract class Filter
extends Query {
    public abstract DocIdSet getDocIdSet(LeafReaderContext var1, Bits var2) throws IOException;

    @Override
    public boolean equals(Object that) {
        return this == that;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new Weight(this){

            @Override
            public float getValueForNormalization() throws IOException {
                return 0.0f;
            }

            @Override
            public void normalize(float norm, float topLevelBoost) {
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                String desc;
                boolean match;
                Scorer scorer = this.scorer(context, context.reader().getLiveDocs());
                boolean bl = match = scorer != null && scorer.advance(doc) == doc;
                if (match) {
                    assert (scorer.score() == 0.0f);
                    desc = "Match on id " + doc;
                } else {
                    desc = "No match on id " + doc;
                }
                return new ComplexExplanation(match, 0.0f, desc);
            }

            @Override
            public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                DocIdSet set = Filter.this.getDocIdSet(context, acceptDocs);
                if (set == null) {
                    return null;
                }
                final DocIdSetIterator iterator = set.iterator();
                if (iterator == null) {
                    return null;
                }
                return new Scorer(this){

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    public int freq() throws IOException {
                        return 1;
                    }

                    @Override
                    public int docID() {
                        return iterator.docID();
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return iterator.nextDoc();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        return iterator.advance(target);
                    }

                    @Override
                    public long cost() {
                        return iterator.cost();
                    }
                };
            }
        };
    }
}

