/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public final class FieldValueQuery
extends Query {
    private final String field;

    public FieldValueQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FieldValueQuery)) {
            return false;
        }
        FieldValueQuery that = (FieldValueQuery)obj;
        return super.equals(obj) && this.field.equals(that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.field, Float.valueOf(this.getBoost()));
    }

    @Override
    public String toString(String field) {
        return "FieldValueQuery [field=" + this.field + "]" + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context, final Bits acceptDocs, final float score) throws IOException {
                final Bits docsWithField = context.reader().getDocsWithField(FieldValueQuery.this.field);
                if (docsWithField == null || docsWithField instanceof Bits.MatchNoBits) {
                    return null;
                }
                DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                final TwoPhaseIterator twoPhaseIterator = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() throws IOException {
                        int doc = this.approximation.docID();
                        if (acceptDocs != null && !acceptDocs.get(doc)) {
                            return false;
                        }
                        return docsWithField.get(doc);
                    }
                };
                final DocIdSetIterator disi = TwoPhaseIterator.asDocIdSetIterator(twoPhaseIterator);
                return new Scorer(this){

                    @Override
                    public TwoPhaseIterator asTwoPhaseIterator() {
                        return twoPhaseIterator;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return disi.nextDoc();
                    }

                    @Override
                    public int docID() {
                        return disi.docID();
                    }

                    @Override
                    public long cost() {
                        return disi.cost();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        return disi.advance(target);
                    }

                    @Override
                    public int freq() throws IOException {
                        return 1;
                    }

                    @Override
                    public float score() throws IOException {
                        return score;
                    }
                };
            }
        };
    }
}

