/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LongBitSet;

public final class DocValuesRewriteMethod
extends MultiTermQuery.RewriteMethod {
    @Override
    public Query rewrite(IndexReader reader, MultiTermQuery query) {
        ConstantScoreQuery result = new ConstantScoreQuery(new MultiTermQueryDocValuesWrapper(query));
        result.setBoost(query.getBoost());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return 641;
    }

    static class MultiTermQueryDocValuesWrapper
    extends Query {
        protected final MultiTermQuery query;

        protected MultiTermQueryDocValuesWrapper(MultiTermQuery query) {
            this.query = query;
        }

        @Override
        public String toString(String field) {
            return this.query.toString(field);
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass().equals(o.getClass())) {
                MultiTermQueryDocValuesWrapper that = (MultiTermQueryDocValuesWrapper)o;
                return this.query.equals(that.query) && this.getBoost() == that.getBoost();
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(this.getClass(), this.query, Float.valueOf(this.getBoost()));
        }

        public final String getField() {
            return this.query.getField();
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            return new ConstantScoreWeight(this){

                @Override
                Scorer scorer(LeafReaderContext context, final Bits acceptDocs, final float score) throws IOException {
                    final SortedSetDocValues fcsi = DocValues.getSortedSet(context.reader(), MultiTermQueryDocValuesWrapper.this.query.field);
                    TermsEnum termsEnum = MultiTermQueryDocValuesWrapper.this.query.getTermsEnum(new Terms(){

                        @Override
                        public TermsEnum iterator(TermsEnum reuse) {
                            return fcsi.termsEnum();
                        }

                        @Override
                        public long getSumTotalTermFreq() {
                            return -1L;
                        }

                        @Override
                        public long getSumDocFreq() {
                            return -1L;
                        }

                        @Override
                        public int getDocCount() {
                            return -1;
                        }

                        @Override
                        public long size() {
                            return -1L;
                        }

                        @Override
                        public boolean hasFreqs() {
                            return false;
                        }

                        @Override
                        public boolean hasOffsets() {
                            return false;
                        }

                        @Override
                        public boolean hasPositions() {
                            return false;
                        }

                        @Override
                        public boolean hasPayloads() {
                            return false;
                        }
                    });
                    assert (termsEnum != null);
                    if (termsEnum.next() == null) {
                        return null;
                    }
                    final LongBitSet termSet = new LongBitSet(fcsi.getValueCount());
                    do {
                        long ord;
                        if ((ord = termsEnum.ord()) < 0L) continue;
                        termSet.set(ord);
                    } while (termsEnum.next() != null);
                    DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                    final TwoPhaseIterator twoPhaseIterator = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            int doc = this.approximation.docID();
                            if (acceptDocs != null && !acceptDocs.get(doc)) {
                                return false;
                            }
                            fcsi.setDocument(doc);
                            long ord = fcsi.nextOrd();
                            while (ord != -1L) {
                                if (termSet.get(ord)) {
                                    return true;
                                }
                                ord = fcsi.nextOrd();
                            }
                            return false;
                        }
                    };
                    final DocIdSetIterator disi = TwoPhaseIterator.asDocIdSetIterator(twoPhaseIterator);
                    return new Scorer(this){

                        @Override
                        public TwoPhaseIterator asTwoPhaseIterator() {
                            return twoPhaseIterator;
                        }

                        @Override
                        public float score() throws IOException {
                            return score;
                        }

                        @Override
                        public int freq() throws IOException {
                            return 1;
                        }

                        @Override
                        public int docID() {
                            return disi.docID();
                        }

                        @Override
                        public int nextDoc() throws IOException {
                            return disi.nextDoc();
                        }

                        @Override
                        public int advance(int target) throws IOException {
                            return disi.advance(target);
                        }

                        @Override
                        public long cost() {
                            return disi.cost();
                        }
                    };
                }
            };
        }
    }
}

