/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldValueQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;

public final class DocValuesRangeQuery
extends Query {
    private final String field;
    private final Object lowerVal;
    private final Object upperVal;
    private final boolean includeLower;
    private final boolean includeUpper;

    public static Query newLongRange(String field, Long lowerVal, Long upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeQuery(field, lowerVal, upperVal, includeLower, includeUpper);
    }

    public static Query newBytesRefRange(String field, BytesRef lowerVal, BytesRef upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeQuery(field, DocValuesRangeQuery.deepCopyOf(lowerVal), DocValuesRangeQuery.deepCopyOf(upperVal), includeLower, includeUpper);
    }

    private static BytesRef deepCopyOf(BytesRef b) {
        if (b == null) {
            return null;
        }
        return BytesRef.deepCopyOf(b);
    }

    private DocValuesRangeQuery(String field, Object lowerVal, Object upperVal, boolean includeLower, boolean includeUpper) {
        this.field = Objects.requireNonNull(field);
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DocValuesRangeQuery)) {
            return false;
        }
        DocValuesRangeQuery that = (DocValuesRangeQuery)obj;
        return this.field.equals(that.field) && Objects.equals(this.lowerVal, that.lowerVal) && Objects.equals(this.upperVal, that.upperVal) && this.includeLower == that.includeLower && this.includeUpper == that.includeUpper && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.lowerVal, this.upperVal, this.includeLower, this.includeUpper, Float.valueOf(this.getBoost()));
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field).append(':');
        }
        sb.append(this.includeLower ? (char)'[' : '{');
        sb.append(this.lowerVal == null ? "*" : this.lowerVal.toString());
        sb.append(" TO ");
        sb.append(this.upperVal == null ? "*" : this.upperVal.toString());
        sb.append(this.includeUpper ? (char)']' : '}');
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.lowerVal == null && this.upperVal == null) {
            FieldValueQuery rewritten = new FieldValueQuery(this.field);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (this.lowerVal == null && this.upperVal == null) {
            throw new IllegalStateException("Both min and max values cannot be null, call rewrite first");
        }
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context, Bits acceptDocs, float score) throws IOException {
                TwoPhaseIterator twoPhaseRange;
                Bits docsWithField = context.reader().getDocsWithField(DocValuesRangeQuery.this.field);
                if (docsWithField == null || docsWithField instanceof Bits.MatchNoBits) {
                    return null;
                }
                DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                if (DocValuesRangeQuery.this.lowerVal instanceof Long || DocValuesRangeQuery.this.upperVal instanceof Long) {
                    long max;
                    SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), DocValuesRangeQuery.this.field);
                    long min = DocValuesRangeQuery.this.lowerVal == null ? Long.MIN_VALUE : (DocValuesRangeQuery.this.includeLower ? (Long)DocValuesRangeQuery.this.lowerVal : 1L + (Long)DocValuesRangeQuery.this.lowerVal);
                    if (min > (max = DocValuesRangeQuery.this.upperVal == null ? Long.MAX_VALUE : (DocValuesRangeQuery.this.includeUpper ? (Long)DocValuesRangeQuery.this.upperVal : -1L + (Long)DocValuesRangeQuery.this.upperVal))) {
                        return null;
                    }
                    twoPhaseRange = new TwoPhaseNumericRange(values, min, max, approximation, acceptDocs);
                } else if (DocValuesRangeQuery.this.lowerVal instanceof BytesRef || DocValuesRangeQuery.this.upperVal instanceof BytesRef) {
                    long ord;
                    long maxOrd;
                    long ord2;
                    SortedSetDocValues values = DocValues.getSortedSet(context.reader(), DocValuesRangeQuery.this.field);
                    long minOrd = DocValuesRangeQuery.this.lowerVal == null ? 0L : ((ord2 = values.lookupTerm((BytesRef)DocValuesRangeQuery.this.lowerVal)) < 0L ? -1L - ord2 : (DocValuesRangeQuery.this.includeLower ? ord2 : ord2 + 1L));
                    if (minOrd > (maxOrd = DocValuesRangeQuery.this.upperVal == null ? values.getValueCount() - 1L : ((ord = values.lookupTerm((BytesRef)DocValuesRangeQuery.this.upperVal)) < 0L ? -2L - ord : (DocValuesRangeQuery.this.includeUpper ? ord : ord - 1L)))) {
                        return null;
                    }
                    twoPhaseRange = new TwoPhaseOrdRange(values, minOrd, maxOrd, approximation, acceptDocs);
                } else {
                    throw new AssertionError();
                }
                return new RangeScorer(this, twoPhaseRange, score);
            }
        };
    }

    private static class RangeScorer
    extends Scorer {
        private final TwoPhaseIterator twoPhaseRange;
        private final DocIdSetIterator disi;
        private final float score;

        RangeScorer(Weight weight, TwoPhaseIterator twoPhaseRange, float score) {
            super(weight);
            this.twoPhaseRange = twoPhaseRange;
            this.disi = TwoPhaseIterator.asDocIdSetIterator(twoPhaseRange);
            this.score = score;
        }

        @Override
        public TwoPhaseIterator asTwoPhaseIterator() {
            return this.twoPhaseRange;
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }
    }

    private static class TwoPhaseOrdRange
    extends TwoPhaseIterator {
        private final SortedSetDocValues values;
        private final long minOrd;
        private final long maxOrd;
        private final Bits acceptDocs;

        TwoPhaseOrdRange(SortedSetDocValues values, long minOrd, long maxOrd, DocIdSetIterator approximation, Bits acceptDocs) {
            super(approximation);
            this.values = values;
            this.minOrd = minOrd;
            this.maxOrd = maxOrd;
            this.acceptDocs = acceptDocs;
        }

        @Override
        public boolean matches() throws IOException {
            int doc = this.approximation.docID();
            if (this.acceptDocs == null || this.acceptDocs.get(doc)) {
                this.values.setDocument(doc);
                long ord = this.values.nextOrd();
                while (ord != -1L) {
                    if (ord >= this.minOrd && ord <= this.maxOrd) {
                        return true;
                    }
                    ord = this.values.nextOrd();
                }
            }
            return false;
        }
    }

    private static class TwoPhaseNumericRange
    extends TwoPhaseIterator {
        private final SortedNumericDocValues values;
        private final long min;
        private final long max;
        private final Bits acceptDocs;

        TwoPhaseNumericRange(SortedNumericDocValues values, long min, long max, DocIdSetIterator approximation, Bits acceptDocs) {
            super(approximation);
            this.values = values;
            this.min = min;
            this.max = max;
            this.acceptDocs = acceptDocs;
        }

        @Override
        public boolean matches() throws IOException {
            int doc = this.approximation.docID();
            if (this.acceptDocs == null || this.acceptDocs.get(doc)) {
                this.values.setDocument(doc);
                int count = this.values.count();
                for (int i = 0; i < count; ++i) {
                    long value = this.values.valueAt(i);
                    if (value < this.min || value > this.max) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

