/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerPriorityQueue;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

abstract class DisjunctionScorer
extends Scorer {
    private final boolean needsScores;
    private final ScorerPriorityQueue subScorers;
    private final long cost;
    private ScorerPriorityQueue.ScorerWrapper topScorers;

    protected DisjunctionScorer(Weight weight, List<Scorer> subScorers, boolean needsScores) {
        super(weight);
        if (subScorers.size() <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.subScorers = new ScorerPriorityQueue(subScorers.size());
        long cost = 0L;
        for (Scorer scorer : subScorers) {
            ScorerPriorityQueue.ScorerWrapper w = new ScorerPriorityQueue.ScorerWrapper(scorer);
            cost += w.cost;
            this.subScorers.add(w);
        }
        this.cost = cost;
        this.needsScores = needsScores;
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        boolean hasApproximation = false;
        for (ScorerPriorityQueue.ScorerWrapper w : this.subScorers) {
            if (w.twoPhaseView == null) continue;
            hasApproximation = true;
            break;
        }
        if (!hasApproximation) {
            return null;
        }
        return new TwoPhaseIterator(new DisjunctionDISIApproximation(this.subScorers)){

            @Override
            public boolean matches() throws IOException {
                ScorerPriorityQueue.ScorerWrapper topScorers = DisjunctionScorer.this.subScorers.topList();
                while (topScorers.twoPhaseView != null && !topScorers.twoPhaseView.matches()) {
                    topScorers = topScorers.next;
                    if (topScorers != null) continue;
                    return false;
                }
                if (DisjunctionScorer.this.needsScores) {
                    ScorerPriorityQueue.ScorerWrapper previous = topScorers;
                    ScorerPriorityQueue.ScorerWrapper w = topScorers.next;
                    while (w != null) {
                        if (w.twoPhaseView != null && !w.twoPhaseView.matches()) {
                            previous.next = w.next;
                        } else {
                            previous = w;
                        }
                        w = w.next;
                    }
                } else {
                    topScorers.next = null;
                }
                DisjunctionScorer.this.topScorers = topScorers;
                return true;
            }
        };
    }

    @Override
    public final long cost() {
        return this.cost;
    }

    @Override
    public final int docID() {
        return this.subScorers.top().doc;
    }

    @Override
    public final int nextDoc() throws IOException {
        this.topScorers = null;
        ScorerPriorityQueue.ScorerWrapper top = this.subScorers.top();
        int doc = top.doc;
        do {
            top.doc = top.scorer.nextDoc();
            top = this.subScorers.updateTop();
        } while (top.doc == doc);
        return top.doc;
    }

    @Override
    public final int advance(int target) throws IOException {
        this.topScorers = null;
        ScorerPriorityQueue.ScorerWrapper top = this.subScorers.top();
        do {
            top.doc = top.scorer.advance(target);
            top = this.subScorers.updateTop();
        } while (top.doc < target);
        return top.doc;
    }

    @Override
    public final int freq() throws IOException {
        if (this.topScorers == null) {
            this.topScorers = this.subScorers.topList();
        }
        int freq = 1;
        ScorerPriorityQueue.ScorerWrapper w = this.topScorers.next;
        while (w != null) {
            ++freq;
            w = w.next;
        }
        return freq;
    }

    @Override
    public final float score() throws IOException {
        if (this.topScorers == null) {
            this.topScorers = this.subScorers.topList();
        }
        return this.score(this.topScorers);
    }

    protected abstract float score(ScorerPriorityQueue.ScorerWrapper var1) throws IOException;

    @Override
    public final Collection<Scorer.ChildScorer> getChildren() {
        ArrayList<Scorer.ChildScorer> children = new ArrayList<Scorer.ChildScorer>();
        for (ScorerPriorityQueue.ScorerWrapper scorer : this.subScorers) {
            children.add(new Scorer.ChildScorer(scorer.scorer, "SHOULD"));
        }
        return children;
    }

    private static class DisjunctionDISIApproximation
    extends DocIdSetIterator {
        final ScorerPriorityQueue subScorers;
        final long cost;

        DisjunctionDISIApproximation(ScorerPriorityQueue subScorers) {
            this.subScorers = subScorers;
            long cost = 0L;
            for (ScorerPriorityQueue.ScorerWrapper w : subScorers) {
                cost += w.cost;
            }
            this.cost = cost;
        }

        @Override
        public long cost() {
            return this.cost;
        }

        @Override
        public int docID() {
            return this.subScorers.top().doc;
        }

        @Override
        public int nextDoc() throws IOException {
            ScorerPriorityQueue.ScorerWrapper top = this.subScorers.top();
            int doc = top.doc;
            do {
                top.doc = top.approximation.nextDoc();
                top = this.subScorers.updateTop();
            } while (top.doc == doc);
            return top.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            ScorerPriorityQueue.ScorerWrapper top = this.subScorers.top();
            do {
                top.doc = top.approximation.advance(target);
                top = this.subScorers.updateTop();
            } while (top.doc < target);
            return top.doc;
        }
    }
}

