/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

abstract class ConstantScoreWeight
extends Weight {
    private float queryNorm;
    private float queryWeight;

    protected ConstantScoreWeight(Query query) {
        super(query);
    }

    @Override
    public final float getValueForNormalization() throws IOException {
        this.queryWeight = this.getQuery().getBoost();
        return this.queryWeight * this.queryWeight;
    }

    @Override
    public final void normalize(float norm, float topLevelBoost) {
        this.queryNorm = norm * topLevelBoost;
        this.queryWeight *= this.queryNorm;
    }

    @Override
    public final Explanation explain(LeafReaderContext context, int doc) throws IOException {
        Scorer s = this.scorer(context, context.reader().getLiveDocs());
        boolean exists = s != null && s.advance(doc) == doc;
        ComplexExplanation result = new ComplexExplanation();
        if (exists) {
            result.setDescription(this.getQuery().toString() + ", product of:");
            result.setValue(this.queryWeight);
            result.setMatch(Boolean.TRUE);
            result.addDetail(new Explanation(this.getQuery().getBoost(), "boost"));
            result.addDetail(new Explanation(this.queryNorm, "queryNorm"));
        } else {
            result.setDescription(this.getQuery().toString() + " doesn't match id " + doc);
            result.setValue(0.0f);
            result.setMatch(Boolean.FALSE);
        }
        return result;
    }

    @Override
    public final Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
        return this.scorer(context, acceptDocs, this.queryWeight);
    }

    abstract Scorer scorer(LeafReaderContext var1, Bits var2, float var3) throws IOException;
}

