/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class ConstantScoreQuery
extends Query {
    protected final Query query;

    public ConstantScoreQuery(Query query) {
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten;
        Query sub = this.query;
        if (sub instanceof QueryWrapperFilter) {
            sub = ((QueryWrapperFilter)sub).getQuery();
        }
        if ((rewritten = sub.rewrite(reader)) != this.query) {
            rewritten = new ConstantScoreQuery(rewritten);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        if (!(this.query instanceof Filter)) {
            this.query.extractTerms(terms);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        Weight innerWeight = searcher.createWeight(this.query, false);
        if (needsScores) {
            return new ConstantWeight(innerWeight);
        }
        return innerWeight;
    }

    @Override
    public String toString(String field) {
        return "ConstantScore(" + this.query.toString(field) + ')' + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof ConstantScoreQuery) {
            ConstantScoreQuery other = (ConstantScoreQuery)o;
            return this.query.equals(other.query);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.query.hashCode();
    }

    protected class ConstantDocIdSetIteratorScorer
    extends Scorer {
        final DocIdSetIterator docIdSetIterator;
        final float theScore;

        public ConstantDocIdSetIteratorScorer(DocIdSetIterator docIdSetIterator, Weight w, float theScore) {
            super(w);
            this.theScore = theScore;
            this.docIdSetIterator = docIdSetIterator;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.docIdSetIterator.nextDoc();
        }

        @Override
        public int docID() {
            return this.docIdSetIterator.docID();
        }

        @Override
        public float score() throws IOException {
            assert (this.docIdSetIterator.docID() != Integer.MAX_VALUE);
            return this.theScore;
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.docIdSetIterator.advance(target);
        }

        @Override
        public long cost() {
            return this.docIdSetIterator.cost();
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            if (ConstantScoreQuery.this.query != null) {
                return Collections.singletonList(new Scorer.ChildScorer((Scorer)this.docIdSetIterator, "constant"));
            }
            return Collections.emptyList();
        }
    }

    protected class ConstantScoreScorer
    extends FilterScorer {
        private final float score;

        public ConstantScoreScorer(Scorer wrapped, float score) {
            super(wrapped);
            this.score = score;
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singletonList(new Scorer.ChildScorer(this.in, "constant"));
        }
    }

    protected class ConstantBulkScorer
    extends BulkScorer {
        final BulkScorer bulkScorer;
        final Weight weight;
        final float theScore;

        public ConstantBulkScorer(BulkScorer bulkScorer, Weight weight, float theScore) {
            this.bulkScorer = bulkScorer;
            this.weight = weight;
            this.theScore = theScore;
        }

        @Override
        public int score(LeafCollector collector, int min, int max) throws IOException {
            return this.bulkScorer.score(this.wrapCollector(collector), min, max);
        }

        private LeafCollector wrapCollector(LeafCollector collector) {
            return new FilterLeafCollector(collector){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    this.in.setScorer(new ConstantScoreScorer(scorer, ConstantBulkScorer.this.theScore));
                }
            };
        }

        @Override
        public long cost() {
            return this.bulkScorer.cost();
        }
    }

    protected class ConstantWeight
    extends Weight {
        private final Weight innerWeight;
        private float queryNorm;
        private float queryWeight;

        public ConstantWeight(Weight innerWeight) throws IOException {
            super(ConstantScoreQuery.this);
            this.innerWeight = innerWeight;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            this.innerWeight.getValueForNormalization();
            this.queryWeight = ConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
            this.innerWeight.normalize(norm, topLevelBoost);
        }

        @Override
        public BulkScorer bulkScorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
            BulkScorer bulkScorer = this.innerWeight.bulkScorer(context, acceptDocs);
            if (bulkScorer == null) {
                return null;
            }
            return new ConstantBulkScorer(bulkScorer, this, this.queryWeight);
        }

        @Override
        public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
            Scorer scorer = this.innerWeight.scorer(context, acceptDocs);
            if (scorer == null) {
                return null;
            }
            return new ConstantScoreScorer(scorer, this.queryWeight);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Scorer cs = this.scorer(context, context.reader().getLiveDocs());
            boolean exists = cs != null && cs.advance(doc) == doc;
            ComplexExplanation result = new ComplexExplanation();
            if (exists) {
                result.setDescription(ConstantScoreQuery.this.toString() + ", product of:");
                result.setValue(this.queryWeight);
                result.setMatch(Boolean.TRUE);
                result.addDetail(new Explanation(ConstantScoreQuery.this.getBoost(), "boost"));
                result.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            } else {
                result.setDescription(ConstantScoreQuery.this.toString() + " doesn't match id " + doc);
                result.setValue(0.0f);
                result.setMatch(Boolean.FALSE);
            }
            return result;
        }
    }
}

